/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.run;

import fitnesse.responders.run.RunningTestingTracker;
import fitnesse.responders.run.RunningTestingTrackerTest;
import fitnesse.responders.run.Stoppable;
import org.junit.Assert;
import org.junit.Test;

public class RunningTestingTrackerTest {
    @Test
    public void testAddStoppable() {
        StoppedRecorder stoppableA = new StoppedRecorder(this);
        StoppedRecorder stoppableB = new StoppedRecorder(this);
        RunningTestingTracker tracker = new RunningTestingTracker();
        tracker.addStartedProcess((Stoppable)stoppableA);
        tracker.addStartedProcess((Stoppable)stoppableB);
        tracker.stopAllProcesses();
        Assert.assertTrue((boolean)stoppableA.wasStopped());
        Assert.assertTrue((boolean)stoppableB.wasStopped());
    }

    @Test
    public void testRemoveStoppable() {
        StoppedRecorder stoppableA = new StoppedRecorder(this);
        StoppedRecorder stoppableB = new StoppedRecorder(this);
        StoppedRecorder stoppableC = new StoppedRecorder(this);
        RunningTestingTracker tracker = new RunningTestingTracker();
        tracker.addStartedProcess((Stoppable)stoppableA);
        String idB = tracker.addStartedProcess((Stoppable)stoppableB);
        tracker.addStartedProcess((Stoppable)stoppableC);
        tracker.removeEndedProcess(idB);
        tracker.stopAllProcesses();
        Assert.assertTrue((boolean)stoppableA.wasStopped());
        Assert.assertFalse((boolean)stoppableB.wasStopped());
        Assert.assertTrue((boolean)stoppableC.wasStopped());
    }

    @Test
    public void testStopProcess() {
        StoppedRecorder stoppableA = new StoppedRecorder(this);
        StoppedRecorder stoppableB = new StoppedRecorder(this);
        StoppedRecorder stoppableC = new StoppedRecorder(this);
        RunningTestingTracker tracker = new RunningTestingTracker();
        tracker.addStartedProcess((Stoppable)stoppableA);
        String idB = tracker.addStartedProcess((Stoppable)stoppableB);
        tracker.addStartedProcess((Stoppable)stoppableC);
        String results = tracker.stopProcess(idB);
        Assert.assertFalse((boolean)stoppableA.wasStopped());
        Assert.assertTrue((boolean)stoppableB.wasStopped());
        Assert.assertFalse((boolean)stoppableC.wasStopped());
        Assert.assertTrue((boolean)results.contains("1"));
    }

    @Test
    public void testStopAllProcesses() {
        StoppedRecorder stoppableA = new StoppedRecorder(this);
        StoppedRecorder stoppableB = new StoppedRecorder(this);
        StoppedRecorder stoppableC = new StoppedRecorder(this);
        RunningTestingTracker tracker = new RunningTestingTracker();
        tracker.addStartedProcess((Stoppable)stoppableA);
        tracker.addStartedProcess((Stoppable)stoppableB);
        tracker.addStartedProcess((Stoppable)stoppableC);
        String results = tracker.stopAllProcesses();
        Assert.assertTrue((boolean)stoppableA.wasStopped());
        Assert.assertTrue((boolean)stoppableB.wasStopped());
        Assert.assertTrue((boolean)stoppableC.wasStopped());
        Assert.assertTrue((boolean)results.contains("3"));
    }
}

