/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.run;

import fitnesse.components.SuiteSpecificationMatchFinder;
import fitnesse.components.TraversalListener;
import fitnesse.testsystems.slim.HtmlTable;
import fitnesse.testsystems.slim.HtmlTableScanner;
import fitnesse.testsystems.slim.Table;
import fitnesse.wiki.PageCrawler;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.WikiPage;
import java.util.LinkedList;

/*
 * Exception performing whole class analysis ignored.
 */
public class SuiteSpecificationRunner
implements TraversalListener<WikiPage> {
    public String titleRegEx;
    public String contentRegEx;
    public LinkedList<WikiPage> testPageList = new LinkedList();
    public WikiPage searchRoot;
    private WikiPage root;
    public PageCrawler crawler;

    public SuiteSpecificationRunner(WikiPage root) {
        this.root = root;
        this.searchRoot = root;
        this.titleRegEx = "";
        this.contentRegEx = "";
        this.crawler = root.getPageCrawler();
    }

    public void findPageMatches() {
        SuiteSpecificationMatchFinder finder = new SuiteSpecificationMatchFinder(this.titleRegEx, this.contentRegEx, (TraversalListener)this);
        finder.search(this.searchRoot);
    }

    public boolean getPageListFromPageContent(String pageContent) {
        HtmlTableScanner scanner = new HtmlTableScanner(pageContent);
        for (int tableIndex = 0; tableIndex < scanner.getTableCount(); ++tableIndex) {
            HtmlTable table = scanner.getTable(tableIndex);
            if (this.getPageListFromTable((Table)table)) continue;
            return false;
        }
        return true;
    }

    private boolean getPageListFromTable(Table table) {
        if (!this.getImportantTableInformation(table)) {
            return false;
        }
        this.findPageMatches();
        this.titleRegEx = "";
        this.contentRegEx = "";
        return true;
    }

    public boolean getImportantTableInformation(Table table) {
        if (!SuiteSpecificationRunner.isASuiteSpecificationsTable((Table)table)) {
            return false;
        }
        for (int rowIndex = 0; rowIndex < table.getRowCount(); ++rowIndex) {
            this.getImportantRowInformation(table, rowIndex);
        }
        return true;
    }

    private void getImportantRowInformation(Table table, int rowIndex) {
        String cellContent = table.getCellContents(0, rowIndex);
        if (this.isPageRootRow(cellContent)) {
            this.getSearchRoot(table, rowIndex);
        }
        if (this.isTitleRegExRow(cellContent)) {
            this.setTitleRegEx(table, rowIndex);
        }
        if (this.isContentRegExRow(cellContent)) {
            this.setContentRegEx(table, rowIndex);
        }
    }

    private boolean isPageRootRow(String cellContent) {
        return cellContent != null && cellContent.equals("Page");
    }

    private void getSearchRoot(Table table, int rowIndex) {
        if (table.getCellContents(1, rowIndex) != null) {
            String searchRootPath = table.getCellContents(1, rowIndex);
            this.searchRoot = this.crawler.getPage(this.root, PathParser.parse((String)searchRootPath));
        }
    }

    private void setContentRegEx(Table table, int rowIndex) {
        if (table.getCellContents(1, rowIndex) != null) {
            this.contentRegEx = table.getCellContents(1, rowIndex);
        }
    }

    private boolean isContentRegExRow(String cellContent) {
        return cellContent != null && cellContent.equals("Content");
    }

    private void setTitleRegEx(Table table, int rowIndex) {
        if (table.getCellContents(1, rowIndex) != null) {
            this.titleRegEx = table.getCellContents(1, rowIndex);
        }
    }

    private boolean isTitleRegExRow(String cellContent) {
        return cellContent != null && cellContent.equals("Title");
    }

    private static boolean tableIsTooSmall(Table table) {
        return table.getRowCount() < 3;
    }

    public static boolean isASuiteSpecificationsTable(Table table) {
        return !SuiteSpecificationRunner.tableIsTooSmall((Table)table) && table.getCellContents(0, 0).equals("Suite");
    }

    public void process(WikiPage page) {
        for (WikiPage hit : this.testPageList) {
            if (hit != page) continue;
            return;
        }
        if (page.getData().hasAttribute("Test")) {
            this.testPageList.add(page);
        }
    }

    public static boolean isASuiteSpecificationsPage(String page) {
        HtmlTableScanner scanner = new HtmlTableScanner(page);
        if (scanner.getTableCount() > 0) {
            HtmlTable table = scanner.getTable(0);
            return SuiteSpecificationRunner.isASuiteSpecificationsTable((Table)table);
        }
        return false;
    }
}

