/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.run.formatters;

import fitnesse.FitNesseContext;
import fitnesse.responders.run.formatters.SuiteHtmlFormatter;
import fitnesse.testsystems.TestPage;
import fitnesse.testsystems.TestSummary;
import fitnesse.testutil.FitNesseUtil;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPageDummy;
import util.RegexTestCase;
import util.TimeMeasurement;

/*
 * Exception performing whole class analysis ignored.
 */
public class SuiteHtmlFormatterTest
extends RegexTestCase {
    private SuiteHtmlFormatter formatter;
    private StringBuffer pageBuffer = new StringBuffer();

    public void setUp() throws Exception {
        FitNesseContext context = FitNesseUtil.makeTestContext();
        this.formatter = new /* Unavailable Anonymous Inner Class!! */;
    }

    public void tearDown() throws Exception {
    }

    public void testTestSummary() throws Exception {
        this.formatter.processTestResults("TestName", new TestSummary(49, 0, 0, 0));
        this.formatter.processTestResults("TestName2", new TestSummary(1, 0, 2, 0));
        this.formatter.processTestResults("TestName3", new TestSummary(1, 1, 0, 0));
        this.formatter.finishWritingOutput();
        SuiteHtmlFormatterTest.assertSubString((String)"<strong>Test Pages:</strong> 2 right, 1 wrong, 0 ignored, 0 exceptions", (String)this.pageBuffer.toString());
        SuiteHtmlFormatterTest.assertSubString((String)"<strong>Assertions:</strong> 51 right, 1 wrong, 2 ignored, 0 exceptions", (String)this.pageBuffer.toString());
    }

    private void testSuiteMetaTestSummaryWithTestResults(String pageName) throws Exception {
        this.formatter.processTestResults(pageName, new TestSummary(2, 0, 0, 0));
        this.formatter.finishWritingOutput();
        SuiteHtmlFormatterTest.assertSubString((String)"<span class=\\\"results pass\\\">2 right, 0 wrong, 0 ignored, 0 exceptions</span>", (String)this.pageBuffer.toString());
        SuiteHtmlFormatterTest.assertSubString((String)"<strong>Test Pages:</strong> 1 right, 0 wrong, 0 ignored, 0 exceptions", (String)this.pageBuffer.toString());
        SuiteHtmlFormatterTest.assertSubString((String)"<strong>Assertions:</strong> 2 right, 0 wrong, 0 ignored, 0 exceptions", (String)this.pageBuffer.toString());
    }

    public void testSuiteSetUpSummaryWithTestResults() throws Exception {
        this.testSuiteMetaTestSummaryWithTestResults("SuiteSetUp");
    }

    public void testSuiteTearDownSummaryWithTestResults() throws Exception {
        this.testSuiteMetaTestSummaryWithTestResults("SuiteTearDown");
    }

    private void testSuiteMetaTestSummaryWithoutTestResults(String pageName) throws Exception {
        this.formatter.processTestResults(pageName, new TestSummary(0, 0, 0, 0));
        this.formatter.finishWritingOutput();
        SuiteHtmlFormatterTest.assertSubString((String)"<span class=\\\"results pass\\\">0 right, 0 wrong, 0 ignored, 0 exceptions</span>", (String)this.pageBuffer.toString());
        SuiteHtmlFormatterTest.assertSubString((String)"<strong>Test Pages:</strong> 1 right, 0 wrong, 0 ignored, 0 exceptions", (String)this.pageBuffer.toString());
        SuiteHtmlFormatterTest.assertSubString((String)"<strong>Assertions:</strong> 0 right, 0 wrong, 0 ignored, 0 exceptions", (String)this.pageBuffer.toString());
    }

    public void testSuiteSetUpSummaryWithoutTestResults() throws Exception {
        this.testSuiteMetaTestSummaryWithoutTestResults("SuiteSetUp");
    }

    public void testSuiteTearDownSummaryWithoutTestResults() throws Exception {
        this.testSuiteMetaTestSummaryWithoutTestResults("SuiteTearDown");
    }

    public void testCountsHtml() throws Exception {
        this.formatter.processTestResults("RelativePageName", new TestSummary(1, 0, 0, 0));
        SuiteHtmlFormatterTest.assertSubString((String)"<span class=\\\"results pass\\\">1 right, 0 wrong, 0 ignored, 0 exceptions</span>", (String)this.pageBuffer.toString());
        SuiteHtmlFormatterTest.assertSubString((String)"<a href=\\\"#RelativePageName0\\\" class=\\\"link\\\">RelativePageName</a>", (String)this.pageBuffer.toString());
        this.pageBuffer.setLength(0);
        this.formatter.processTestResults("AnotherPageName", new TestSummary(0, 1, 0, 0));
        SuiteHtmlFormatterTest.assertSubString((String)"<span class=\\\"results fail\\\">0 right, 1 wrong, 0 ignored, 0 exceptions</span>", (String)this.pageBuffer.toString());
        SuiteHtmlFormatterTest.assertSubString((String)"<a href=\\\"#AnotherPageName0\\\" class=\\\"link\\\">AnotherPageName</a>", (String)this.pageBuffer.toString());
    }

    public void testResultsHtml() throws Exception {
        this.formatter.testSystemStarted(null, "Fit", "laughing.fit");
        this.formatter.announceNumberTestsToRun(2);
        this.formatter.announceStartNewTest("RelativeName", "FullName");
        this.formatter.testOutputChunk("starting");
        this.formatter.testOutputChunk(" output");
        this.formatter.processTestResults("RelativeName", new TestSummary(1, 0, 0, 0));
        this.formatter.testSystemStarted(null, "Slim", "very.slim");
        this.formatter.announceStartNewTest("NewRelativeName", "NewFullName");
        this.formatter.testOutputChunk("second");
        this.formatter.testOutputChunk(" test");
        this.formatter.processTestResults("NewRelativeName", new TestSummary(0, 1, 0, 0));
        this.formatter.finishWritingOutput();
        String results = this.pageBuffer.toString();
        SuiteHtmlFormatterTest.assertSubString((String)"<h2>Test Output</h2>", (String)results);
        SuiteHtmlFormatterTest.assertSubString((String)"<h2>Test System: Slim:very.slim</h2>", (String)results);
        SuiteHtmlFormatterTest.assertSubString((String)"<div class=\"test_output_name\">", (String)results);
        SuiteHtmlFormatterTest.assertSubString((String)"<a href=\"FullName\" id=\"RelativeName1\" class=\"test_name\">RelativeName</a>", (String)results);
        SuiteHtmlFormatterTest.assertSubString((String)"<div class=\"alternating_block\">starting output</div>", (String)results);
        SuiteHtmlFormatterTest.assertSubString((String)"<a href=\"NewFullName\" id=\"NewRelativeName2\" class=\"test_name\">NewRelativeName</a>", (String)results);
        SuiteHtmlFormatterTest.assertSubString((String)"<div class=\"alternating_block\">second test</div>", (String)results);
    }

    public void testTestingProgressIndicator() throws Exception {
        this.formatter.testSystemStarted(null, "Fit", "laughing.fit");
        this.formatter.announceNumberTestsToRun(20);
        this.formatter.announceStartNewTest("RelativeName", "FullName");
        SuiteHtmlFormatterTest.assertSubString((String)"<script>document.getElementById(\"test-summary\").innerHTML = \"<div id=\\\"progressBar\\\" class=\\\"pass\\\" style=\\\"width:0.0%\\\">", (String)this.pageBuffer.toString());
        SuiteHtmlFormatterTest.assertSubString((String)"Running&nbsp;tests&nbsp;...&nbsp;(1/20)", (String)this.pageBuffer.toString());
        this.pageBuffer.setLength(0);
        this.formatter.processTestResults("RelativeName", new TestSummary(1, 0, 0, 0));
        this.formatter.announceStartNewTest("RelativeName", "FullName");
        SuiteHtmlFormatterTest.assertSubString((String)"<script>document.getElementById(\"test-summary\").innerHTML = \"<div id=\\\"progressBar\\\" class=\\\"pass\\\" style=\\\"width:5.0%\\\">", (String)this.pageBuffer.toString());
        SuiteHtmlFormatterTest.assertSubString((String)"(2/20)", (String)this.pageBuffer.toString());
        this.pageBuffer.setLength(0);
        this.formatter.processTestResults("RelativeName", new TestSummary(1, 0, 0, 0));
        this.formatter.announceStartNewTest("RelativeName", "FullName");
        SuiteHtmlFormatterTest.assertSubString((String)"<script>document.getElementById(\"test-summary\").innerHTML = \"<div id=\\\"progressBar\\\" class=\\\"pass\\\" style=\\\"width:10.0%\\\">", (String)this.pageBuffer.toString());
        SuiteHtmlFormatterTest.assertSubString((String)"(3/20)", (String)this.pageBuffer.toString());
    }

    public void testTotalTimingShouldAppearInSummary() throws Exception {
        TimeMeasurement totalTimeMeasurement = this.newConstantElapsedTimeMeasurement(900L).start();
        TimeMeasurement timeMeasurement = this.newConstantElapsedTimeMeasurement(666L);
        this.formatter.page = new WikiPageDummy();
        this.formatter.announceNumberTestsToRun(1);
        TestPage firstPage = new TestPage((WikiPage)new WikiPageDummy("page1", "content"));
        this.formatter.newTestStarted(firstPage, timeMeasurement.start());
        this.formatter.testComplete(firstPage, new TestSummary(1, 2, 3, 4), timeMeasurement.stop());
        this.formatter.allTestingComplete(totalTimeMeasurement.stop());
        SuiteHtmlFormatterTest.assertSubString((String)"<strong>Assertions:</strong> 1 right, 2 wrong, 3 ignored, 4 exceptions (0.900 seconds)", (String)this.pageBuffer.toString());
    }

    public void testIndividualTestTimingsShouldAppearInSummary() throws Exception {
        TimeMeasurement totalTimeMeasurement = this.newConstantElapsedTimeMeasurement(900L).start();
        TimeMeasurement firstTimeMeasurement = this.newConstantElapsedTimeMeasurement(670L);
        TimeMeasurement secondTimeMeasurement = this.newConstantElapsedTimeMeasurement(890L);
        this.formatter.page = new WikiPageDummy();
        this.formatter.announceNumberTestsToRun(2);
        TestPage firstPage = new TestPage((WikiPage)new WikiPageDummy("page1", "content"));
        TestPage secondPage = new TestPage((WikiPage)new WikiPageDummy("page2", "content"));
        this.formatter.newTestStarted(firstPage, firstTimeMeasurement.start());
        this.formatter.testComplete(firstPage, new TestSummary(1, 2, 3, 4), firstTimeMeasurement.stop());
        this.formatter.newTestStarted(secondPage, secondTimeMeasurement.start());
        this.formatter.testComplete(secondPage, new TestSummary(5, 6, 7, 8), secondTimeMeasurement.stop());
        this.formatter.allTestingComplete(totalTimeMeasurement.stop());
        SuiteHtmlFormatterTest.assertHasRegexp((String)"<li.*\\(page1\\).*<span.*>\\(0\\.670 seconds\\)</span>.*</li>", (String)this.pageBuffer.toString());
        SuiteHtmlFormatterTest.assertHasRegexp((String)"<li.*\\(page2\\).*<span.*>\\(0\\.890 seconds\\)</span>.*</li>", (String)this.pageBuffer.toString());
    }

    private TimeMeasurement newConstantElapsedTimeMeasurement(long theElapsedTime) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    static /* synthetic */ StringBuffer access$000(SuiteHtmlFormatterTest x0) {
        return x0.pageBuffer;
    }
}

