/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.run.formatters;

import fitnesse.FitNesseContext;
import fitnesse.responders.run.TestExecutionReport;
import fitnesse.responders.run.formatters.BaseFormatter;
import fitnesse.responders.run.formatters.XmlFormatter;
import fitnesse.slim.instructions.Instruction;
import fitnesse.testsystems.CompositeExecutionLog;
import fitnesse.testsystems.TestPage;
import fitnesse.testsystems.TestSummary;
import fitnesse.testsystems.TestSystem;
import fitnesse.testsystems.slim.results.ExceptionResult;
import fitnesse.testsystems.slim.results.TestResult;
import fitnesse.testsystems.slim.tables.Assertion;
import fitnesse.testsystems.slim.tables.Expectation;
import fitnesse.testsystems.slim.tables.SlimTable;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPageUtil;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;
import util.TimeMeasurement;

public class XmlFormatter
extends BaseFormatter {
    private WriterFactory writerFactory;
    private long currentTestStartTime;
    private StringBuilder outputBuffer;
    protected TestExecutionReport testResponse = new TestExecutionReport();
    public List<TestExecutionReport.InstructionResult> instructionResults = new ArrayList();
    protected TestSummary finalSummary = new TestSummary();

    public XmlFormatter(FitNesseContext context, WikiPage page, WriterFactory writerFactory) {
        super(context, page);
        this.writerFactory = writerFactory;
    }

    public void newTestStarted(TestPage test, TimeMeasurement timeMeasurement) {
        this.currentTestStartTime = timeMeasurement.startedAt();
        this.appendHtmlToBuffer(WikiPageUtil.getHeaderPageHtml((WikiPage)this.getPage()));
    }

    public void testSystemStarted(TestSystem testSystem, String testSystemName, String testRunner) {
    }

    public void testOutputChunk(String output) {
        this.appendHtmlToBuffer(output);
    }

    public void testAssertionVerified(Assertion assertion, TestResult testResult) {
        if (testResult == null) {
            return;
        }
        Instruction instruction = assertion.getInstruction();
        Expectation expectation = assertion.getExpectation();
        TestExecutionReport.InstructionResult instructionResult = new TestExecutionReport.InstructionResult();
        this.instructionResults.add(instructionResult);
        String id = instruction.getId();
        instructionResult.instruction = instruction.toString();
        instructionResult.slimResult = testResult.toString();
        try {
            TestExecutionReport.Expectation expectationResult = new TestExecutionReport.Expectation();
            instructionResult.addExpectation(expectationResult);
            expectationResult.instructionId = id;
            expectationResult.type = expectation.getClass().getSimpleName();
            expectationResult.actual = testResult.getActual();
            expectationResult.expected = testResult.getExpected();
            expectationResult.evaluationMessage = testResult.getMessage();
            if (testResult.getExecutionResult() != null) {
                expectationResult.status = testResult.getExecutionResult().toString();
            }
            if (expectation instanceof SlimTable.RowExpectation) {
                SlimTable.RowExpectation rowExpectation = (SlimTable.RowExpectation)expectation;
                expectationResult.col = Integer.toString(rowExpectation.getCol());
                expectationResult.row = Integer.toString(rowExpectation.getRow());
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public void testExceptionOccurred(Assertion assertion, ExceptionResult exceptionResult) {
        Instruction instruction = assertion.getInstruction();
        Expectation expectation = assertion.getExpectation();
        TestExecutionReport.InstructionResult instructionResult = new TestExecutionReport.InstructionResult();
        this.instructionResults.add(instructionResult);
        String id = instruction.getId();
        instructionResult.instruction = instruction.toString();
        try {
            TestExecutionReport.Expectation expectationResult = new TestExecutionReport.Expectation();
            instructionResult.addExpectation(expectationResult);
            expectationResult.instructionId = id;
            expectationResult.type = expectation.getClass().getSimpleName();
            expectationResult.evaluationMessage = exceptionResult.getMessage();
            expectationResult.status = exceptionResult.getExecutionResult().toString();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public void testComplete(TestPage test, TestSummary testSummary, TimeMeasurement timeMeasurement) throws IOException {
        super.testComplete(test, testSummary, timeMeasurement);
        this.processTestResults(test.getName(), testSummary, timeMeasurement);
    }

    public void processTestResults(String relativeTestName, TestSummary testSummary, TimeMeasurement timeMeasurement) {
        this.finalSummary = new TestSummary(testSummary);
        TestExecutionReport.TestResult currentResult = this.newTestResult();
        this.testResponse.results.add(currentResult);
        currentResult.startTime = this.currentTestStartTime;
        currentResult.content = this.outputBuffer == null ? null : this.outputBuffer.toString();
        this.outputBuffer = null;
        this.addCountsToResult(currentResult, testSummary);
        currentResult.runTimeInMillis = String.valueOf(timeMeasurement.elapsed());
        currentResult.relativePageName = relativeTestName;
        currentResult.tags = this.page.readOnlyData().getAttribute("Suites");
        currentResult.getInstructions().addAll(this.instructionResults);
        this.instructionResults = new ArrayList();
    }

    protected TestExecutionReport.TestResult newTestResult() {
        return new TestExecutionReport.TestResult();
    }

    public void setExecutionLogAndTrackingId(String stopResponderId, CompositeExecutionLog log) {
    }

    protected void setPage(WikiPage testPage) {
        this.page = testPage;
        this.testResponse.rootPath = testPage.getName();
    }

    public void allTestingComplete(TimeMeasurement totalTimeMeasurement) throws IOException {
        super.allTestingComplete(totalTimeMeasurement);
        this.setTotalRunTimeOnReport(totalTimeMeasurement);
        this.writeResults();
    }

    protected void setTotalRunTimeOnReport(TimeMeasurement totalTimeMeasurement) {
        this.testResponse.setTotalRunTimeInMillis(totalTimeMeasurement);
    }

    protected void writeResults() throws IOException {
        this.writeResults(this.writerFactory.getWriter(this.context, this.getPageForHistory(), this.finalSummary, this.currentTestStartTime));
    }

    protected WikiPage getPageForHistory() {
        return this.page;
    }

    public int getErrorCount() {
        return this.finalSummary.wrong + this.finalSummary.exceptions;
    }

    protected void writeResults(Writer writer) throws IOException {
        VelocityContext velocityContext = new VelocityContext();
        velocityContext.put("response", (Object)this.testResponse);
        Template template = this.context.pageFactory.getVelocityEngine().getTemplate("testResults.vm");
        template.merge((Context)velocityContext, writer);
        writer.close();
    }

    protected TestSummary getFinalSummary() {
        return this.finalSummary;
    }

    private void addCountsToResult(TestExecutionReport.TestResult currentResult, TestSummary testSummary) {
        currentResult.right = Integer.toString(testSummary.getRight());
        currentResult.wrong = Integer.toString(testSummary.getWrong());
        currentResult.ignores = Integer.toString(testSummary.getIgnores());
        currentResult.exceptions = Integer.toString(testSummary.getExceptions());
    }

    private void appendHtmlToBuffer(String output) {
        if (this.outputBuffer == null) {
            this.outputBuffer = new StringBuilder();
        }
        this.outputBuffer.append(output);
    }
}

