/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.testHistory;

import fitnesse.FitNesseContext;
import fitnesse.http.MockRequest;
import fitnesse.http.Request;
import fitnesse.http.Response;
import fitnesse.http.SimpleResponse;
import fitnesse.responders.testHistory.PageHistory;
import fitnesse.responders.testHistory.PurgeHistoryResponder;
import fitnesse.responders.testHistory.PurgeHistoryResponderTest;
import fitnesse.responders.testHistory.TestHistory;
import fitnesse.testutil.FitNesseUtil;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import util.FileUtil;

public class PurgeHistoryResponderTest {
    private File resultsDirectory;
    private TestHistory history;
    private FitNesseContext context;
    private PurgeHistoryResponder responder;
    private MockRequest request;

    @Before
    public void setup() throws Exception {
        this.resultsDirectory = new File("testHistoryDirectory");
        this.removeResultsDirectory();
        this.resultsDirectory.mkdir();
        this.history = new TestHistory();
        this.responder = new PurgeHistoryResponder();
        this.responder.setResultsDirectory(this.resultsDirectory);
        this.context = FitNesseUtil.makeTestContext();
        this.request = new MockRequest();
        this.request.setResource("TestPage");
    }

    @After
    public void teardown() {
        this.removeResultsDirectory();
    }

    private void removeResultsDirectory() {
        if (this.resultsDirectory.exists()) {
            FileUtil.deleteFileSystemDirectory((File)this.resultsDirectory);
        }
    }

    private File addTestResult(File pageDirectory, String testResultFileName) throws IOException {
        File testResultFile = new File(pageDirectory, testResultFileName + ".xml");
        testResultFile.createNewFile();
        return testResultFile;
    }

    private File addPageDirectory(String pageName) {
        File pageDirectory = new File(this.resultsDirectory, pageName);
        pageDirectory.mkdir();
        return pageDirectory;
    }

    @Test
    public void shouldBeAbleToSubtractDaysFromDates() throws Exception {
        Date date = this.makeDate("20090616171615");
        this.responder.setTodaysDate(date);
        Date resultDate = this.responder.getDateDaysAgo(10);
        Date tenDaysEarlier = this.makeDate("20090606171615");
        Assert.assertEquals((Object)tenDaysEarlier, (Object)resultDate);
    }

    private Date makeDate(String dateString) throws ParseException {
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMddHHmmss");
        Date date = format.parse(dateString);
        return date;
    }

    @Test
    public void shouldBeAbleToDeleteSomeTestHistory() throws Exception {
        this.responder.setTodaysDate(this.makeDate("20090616000000"));
        File pageDirectory = this.addPageDirectory("SomePage");
        this.addTestResult(pageDirectory, "20090614000000_1_0_0_0");
        this.addTestResult(pageDirectory, "20090615000000_1_0_0_0");
        this.history.readHistoryDirectory(this.resultsDirectory);
        PageHistory pageHistory = this.history.getPageHistory("SomePage");
        Assert.assertEquals((long)2L, (long)pageHistory.size());
        this.responder.deleteTestHistoryOlderThanDays(1);
        this.history.readHistoryDirectory(this.resultsDirectory);
        pageHistory = this.history.getPageHistory("SomePage");
        Assert.assertEquals((long)1L, (long)pageHistory.size());
        Assert.assertNotNull((Object)pageHistory.get(this.makeDate("20090615000000")));
        Assert.assertNull((Object)pageHistory.get(this.makeDate("20090614000000")));
    }

    @Test
    public void shouldDeletePageHistoryDirectoryIfEmptiedByPurge() throws Exception {
        this.responder.setTodaysDate(this.makeDate("20090616000000"));
        File pageDirectory = this.addPageDirectory("SomePage");
        this.addTestResult(pageDirectory, "20090614000000_1_0_0_0");
        this.responder.deleteTestHistoryOlderThanDays(1);
        String[] files = this.resultsDirectory.list();
        Assert.assertEquals((long)0L, (long)files.length);
    }

    @Test
    public void shouldDeleteHistoryFromRequestAndRedirect() throws Exception {
        StubbedPurgeHistoryResponder responder = new StubbedPurgeHistoryResponder(null);
        this.request.addInput("days", (Object)"30");
        SimpleResponse response = (SimpleResponse)responder.makeResponse(this.context, (Request)this.request);
        Assert.assertEquals((long)30L, (long)responder.daysDeleted);
        Assert.assertEquals((long)303L, (long)response.getStatus());
        Assert.assertEquals((Object)"?testHistory", (Object)response.getHeader("Location"));
    }

    @Test
    public void shouldMakeErrorResponseWhenGetsInvalidNumberOfDays() throws Exception {
        this.request.addInput("days", (Object)"-42");
        Response response = this.responder.makeResponse(this.context, (Request)this.request);
        Assert.assertEquals((long)400L, (long)response.getStatus());
    }

    @Test
    public void shouldMakeErrorResponseWhenItGetsInvalidTypeForNumberOfDays() throws Exception {
        this.request.addInput("days", (Object)"bob");
        Response response = this.responder.makeResponse(this.context, (Request)this.request);
        Assert.assertEquals((long)400L, (long)response.getStatus());
    }
}

