/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.testHistory;

import fitnesse.responders.testHistory.HistoryComparer;
import fitnesse.responders.testHistory.TableListComparer;
import fitnesse.testsystems.slim.HtmlTable;
import fitnesse.testsystems.slim.HtmlTableScanner;
import fitnesse.testsystems.slim.Table;
import java.util.ArrayList;
import java.util.Collections;

public class TableListComparer {
    private HtmlTableScanner leftHandScanner;
    private HtmlTableScanner rightHandScanner;
    protected ArrayList<HistoryComparer.MatchedPair> tableMatches;

    public TableListComparer(HtmlTableScanner leftHandScanner, HtmlTableScanner rightHandScanner) {
        this.leftHandScanner = leftHandScanner;
        this.rightHandScanner = rightHandScanner;
        this.tableMatches = new ArrayList();
    }

    public void compareAllTables() {
        for (int leftTableIndex = 0; leftTableIndex < this.leftHandScanner.getTableCount(); ++leftTableIndex) {
            for (int rightTableIndex = 0; rightTableIndex < this.rightHandScanner.getTableCount(); ++rightTableIndex) {
                double score = this.compareTables(leftTableIndex, rightTableIndex);
                this.saveMatch(leftTableIndex, rightTableIndex, score);
            }
        }
        this.sortMatchesByScore();
        this.saveOnlyTheBestMatches();
        this.sortMatchesByTableIndex();
    }

    private double compareTables(int leftTableIndex, int rightTableIndex) {
        HtmlTable table1 = this.leftHandScanner.getTable(leftTableIndex);
        HtmlTable table2 = this.rightHandScanner.getTable(rightTableIndex);
        return this.compareTables((Table)table1, (Table)table2);
    }

    double compareTables(Table table1, Table table2) {
        return new TableComparer(table1, table2).compareRowsOfTables();
    }

    public boolean theTablesMatch(double score) {
        return score >= 0.8;
    }

    public void saveMatch(int leftTableIndex, int rightTableIndex, double score) {
        if (!this.theTablesMatch(score)) {
            return;
        }
        this.tableMatches.add(new HistoryComparer.MatchedPair(Integer.valueOf(leftTableIndex), Integer.valueOf(rightTableIndex), score));
    }

    public void saveOnlyTheBestMatches() {
        for (int matchIndex = 0; matchIndex < this.tableMatches.size(); ++matchIndex) {
            for (int secondMatchIndex = matchIndex + 1; secondMatchIndex < this.tableMatches.size(); ++secondMatchIndex) {
                if (((HistoryComparer.MatchedPair)this.tableMatches.get((int)matchIndex)).first == ((HistoryComparer.MatchedPair)this.tableMatches.get((int)secondMatchIndex)).first) {
                    this.tableMatches.remove(secondMatchIndex);
                    --secondMatchIndex;
                    continue;
                }
                if (((HistoryComparer.MatchedPair)this.tableMatches.get((int)matchIndex)).second != ((HistoryComparer.MatchedPair)this.tableMatches.get((int)secondMatchIndex)).second) continue;
                this.tableMatches.remove(secondMatchIndex);
                --secondMatchIndex;
            }
        }
    }

    public void sortMatchesByScore() {
        Collections.sort(this.tableMatches, new /* Unavailable Anonymous Inner Class!! */);
    }

    public void sortMatchesByTableIndex() {
        Collections.sort(this.tableMatches, new /* Unavailable Anonymous Inner Class!! */);
    }
}

