/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.testHistory;

import fitnesse.FitNesseContext;
import fitnesse.authentication.AlwaysSecureOperation;
import fitnesse.authentication.SecureOperation;
import fitnesse.authentication.SecureResponder;
import fitnesse.http.Request;
import fitnesse.http.Response;
import fitnesse.http.SimpleResponse;
import fitnesse.responders.templateUtilities.HtmlPage;
import fitnesse.responders.templateUtilities.PageTitle;
import fitnesse.responders.testHistory.TestHistory;
import java.io.File;
import org.apache.velocity.VelocityContext;

public class TestHistoryResponder
implements SecureResponder {
    private FitNesseContext context;

    public Response makeResponse(FitNesseContext context, Request request) {
        this.context = context;
        File resultsDirectory = context.getTestHistoryDirectory();
        String pageName = request.getResource();
        TestHistory testHistory = new TestHistory();
        testHistory.readPageHistoryDirectory(resultsDirectory, pageName);
        if (this.formatIsXML(request)) {
            return this.makeTestHistoryXmlResponse(testHistory);
        }
        return this.makeTestHistoryResponse(testHistory, request, pageName);
    }

    private Response makeTestHistoryResponse(TestHistory testHistory, Request request, String pageName) {
        HtmlPage page = this.context.pageFactory.newPage();
        page.setTitle("Test History");
        page.setPageTitle(new PageTitle(this.makePageTitle(pageName)));
        page.setNavTemplate("viewNav");
        page.put("viewLocation", (Object)request.getResource());
        page.put("testHistory", (Object)testHistory);
        page.setMainTemplate("testHistory");
        SimpleResponse response = new SimpleResponse();
        response.setContent(page.html());
        return response;
    }

    private Response makeTestHistoryXmlResponse(TestHistory history) {
        SimpleResponse response = new SimpleResponse();
        VelocityContext velocityContext = new VelocityContext();
        velocityContext.put("testHistory", (Object)history);
        response.setContentType(Response.Format.XML);
        response.setContent(this.context.pageFactory.render(velocityContext, "testHistoryXML.vm"));
        return response;
    }

    private String makePageTitle(String pageName) {
        return "".equals(pageName) ? "Test History" : "Test History for " + pageName;
    }

    private boolean formatIsXML(Request request) {
        return request.getInput("format") != null && request.getInput("format").toString().toLowerCase().equals("xml");
    }

    public SecureOperation getSecureOperation() {
        return new AlwaysSecureOperation();
    }
}

