/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.runner;

import fitnesse.components.ContentBuffer;
import fitnesse.runner.PageResult;
import fitnesse.runner.ResultFormatter;
import fitnesse.testsystems.TestSummary;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import util.XmlUtil;
import util.XmlWriter;

public class XmlResultFormatter
implements ResultFormatter {
    private ContentBuffer buffer = new ContentBuffer(".xml");
    private Document document;
    private boolean closed = false;
    private byte[] tailBytes;

    public XmlResultFormatter(String host, String rootPath) throws IOException {
        this.createDocument(host, rootPath);
        this.writeDocumentHeader();
    }

    private void writeDocumentHeader() throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        XmlWriter writer = new XmlWriter((OutputStream)output);
        writer.write(this.document);
        writer.close();
        String xmlText = output.toString();
        int endIndex = xmlText.indexOf("</testResults>");
        String head = xmlText.substring(0, endIndex);
        String tail = xmlText.substring(endIndex);
        this.tailBytes = tail.getBytes();
        this.buffer.append(head);
    }

    private void createDocument(String host, String rootPath) {
        this.document = XmlUtil.newDocument();
        Element root = this.document.createElement("testResults");
        this.document.appendChild(root);
        XmlUtil.addTextNode((Document)this.document, (Element)root, (String)"host", (String)host);
        XmlUtil.addTextNode((Document)this.document, (Element)root, (String)"rootPath", (String)rootPath);
    }

    public void acceptResult(PageResult result) throws IOException {
        Element resultElement = this.document.createElement("result");
        XmlUtil.addTextNode((Document)this.document, (Element)resultElement, (String)"relativePageName", (String)result.title());
        XmlUtil.addCdataNode((Document)this.document, (Element)resultElement, (String)"content", (String)result.content());
        resultElement.appendChild(this.makeCountsElement("counts", result.testSummary()));
        this.writeElement(resultElement);
    }

    public void acceptFinalCount(TestSummary testSummary) throws IOException {
        Element countsElement = this.makeCountsElement("finalCounts", testSummary);
        this.writeElement(countsElement);
    }

    public int getByteCount() throws IOException {
        this.close();
        return this.buffer.getSize();
    }

    public InputStream getResultStream() throws IOException {
        this.close();
        return this.buffer.getInputStream();
    }

    private void close() throws IOException {
        if (!this.closed) {
            this.buffer.append(this.tailBytes);
            this.closed = true;
        }
    }

    private void writeElement(Element resultElement) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        XmlWriter writer = new XmlWriter((OutputStream)output);
        writer.write(resultElement, 1);
        writer.close();
        this.buffer.append(output.toByteArray());
    }

    private Element makeCountsElement(String name, TestSummary testSummary) {
        Element countsElement = this.document.createElement(name);
        XmlUtil.addTextNode((Document)this.document, (Element)countsElement, (String)"right", (String)(testSummary.getRight() + ""));
        XmlUtil.addTextNode((Document)this.document, (Element)countsElement, (String)"wrong", (String)(testSummary.getWrong() + ""));
        XmlUtil.addTextNode((Document)this.document, (Element)countsElement, (String)"ignores", (String)(testSummary.getIgnores() + ""));
        XmlUtil.addTextNode((Document)this.document, (Element)countsElement, (String)"exceptions", (String)(testSummary.getExceptions() + ""));
        return countsElement;
    }
}

