/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.schedule;

import fitnesse.schedule.Schedule;
import fitnesse.schedule.ScheduleItem;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import util.Clock;

public class ScheduleImpl
implements Schedule,
Runnable {
    private long delay;
    private Thread thread;
    private boolean running;
    private List<ScheduleItem> scheduleItems = Collections.synchronizedList(new LinkedList());

    public ScheduleImpl(long delay) {
        this.delay = delay;
    }

    public void add(ScheduleItem item) {
        this.scheduleItems.add(item);
    }

    public void start() {
        this.running = true;
        this.thread = new Thread((Runnable)this);
        this.thread.start();
    }

    public void stop() throws Exception {
        this.running = false;
        if (this.thread != null) {
            this.thread.join();
        }
        this.thread = null;
    }

    @Override
    public void run() {
        try {
            while (this.running) {
                this.runScheduledItems();
                Thread.sleep(this.delay);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runScheduledItems() throws Exception {
        long time = Clock.currentTimeInMillis();
        List list = this.scheduleItems;
        synchronized (list) {
            for (ScheduleItem item : this.scheduleItems) {
                this.runItem(item, time);
            }
        }
    }

    private void runItem(ScheduleItem item, long time) throws Exception {
        try {
            if (item.shouldRun(time)) {
                item.run(time);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

