/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.slim;

import fitnesse.slim.ConverterSupport;
import fitnesse.slim.MethodExecutionResult;
import fitnesse.slim.SlimService;
import fitnesse.slim.fixtureInteraction.FixtureInteraction;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public abstract class MethodExecutor {
    public abstract MethodExecutionResult execute(String var1, String var2, Object[] var3) throws Throwable;

    protected Method findMatchingMethod(String methodName, Class<? extends Object> k, int nArgs) {
        Method[] methods;
        for (Method method : methods = k.getMethods()) {
            boolean hasMatchingArguments;
            boolean hasMatchingName = method.getName().equals(methodName);
            boolean bl = hasMatchingArguments = method.getParameterTypes().length == nArgs;
            if (!hasMatchingName || !hasMatchingArguments) continue;
            return method;
        }
        return null;
    }

    protected MethodExecutionResult invokeMethod(Object instance, Method method, Object[] args) throws Throwable {
        Object[] convertedArgs = this.convertArgs(method, args);
        Object retval = this.callMethod(instance, method, convertedArgs);
        Class<?> retType = method.getReturnType();
        return new MethodExecutionResult(retval, retType);
    }

    protected Object[] convertArgs(Method method, Object[] args) {
        Class[] argumentTypes = method.getParameterTypes();
        return ConverterSupport.convertArgs((Object[])args, (Class[])argumentTypes);
    }

    protected Object callMethod(Object instance, Method method, Object[] convertedArgs) throws Throwable {
        FixtureInteraction interaction = (FixtureInteraction)SlimService.getInteractionClass().newInstance();
        try {
            return interaction.methodInvoke(method, instance, convertedArgs);
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
    }

    protected MethodExecutionResult findAndInvoke(String methodName, Object[] args, Object instance) throws Throwable {
        Method method = this.findMatchingMethod(methodName, instance.getClass(), args.length);
        if (method != null) {
            return this.invokeMethod(instance, method, args);
        }
        return MethodExecutionResult.noMethod((String)methodName, instance.getClass(), (int)args.length);
    }
}

