/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.slim.protocol;

import fitnesse.slim.protocol.SlimDeserializer;
import fitnesse.slim.protocol.SlimSerializer;
import fitnesse.slim.protocol.SyntaxError;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SlimDeserializerTest {
    private List<Object> list;

    @Before
    public void setUp() {
        this.list = new ArrayList();
    }

    private void check() {
        String serialized = SlimSerializer.serialize((List)this.list);
        List deserialized = SlimDeserializer.deserialize((String)serialized);
        Assert.assertEquals((Object)this.list, (Object)deserialized);
    }

    @Test(expected=SyntaxError.class)
    public void cantDeserializeNullString() throws Exception {
        SlimDeserializer.deserialize(null);
    }

    @Test(expected=SyntaxError.class)
    public void cantDeserializeEmptyString() throws Exception {
        SlimDeserializer.deserialize((String)"");
    }

    @Test(expected=SyntaxError.class)
    public void cantDeserializeStringThatDoesntStartWithBracket() throws Exception {
        SlimDeserializer.deserialize((String)"hello");
    }

    @Test(expected=SyntaxError.class)
    public void cantDeserializeStringThatDoesntEndWithBracket() throws Exception {
        SlimDeserializer.deserialize((String)"[000000:");
    }

    @Test
    public void emptyList() throws Exception {
        this.check();
    }

    @Test
    public void listWithOneElement() throws Exception {
        this.list.add("hello");
        this.check();
    }

    @Test
    public void listWithTwoElements() throws Exception {
        this.list.add("hello");
        this.list.add("world");
        this.check();
    }

    @Test
    public void listWithSubList() throws Exception {
        ArrayList<String> sublist = new ArrayList<String>();
        sublist.add("hello");
        sublist.add("world");
        this.list.add(sublist);
        this.list.add("single");
        this.check();
    }

    @Test
    public void listWithElementsWithBrackets() throws Exception {
        this.list.add("hello");
        this.list.add("[world, world2]");
        this.check();
    }
}

