/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.testsystems;

import fitnesse.FitNesseContext;
import fitnesse.testsystems.CommandRunner;
import fitnesse.testsystems.CompositeExecutionLog;
import fitnesse.testsystems.ExecutionLog;
import fitnesse.testsystems.MockCommandRunner;
import fitnesse.testutil.FitNesseUtil;
import fitnesse.wiki.InMemoryPage;
import fitnesse.wiki.PageData;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPageProperties;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import util.RegexTestCase;

public class CompositeExecutionLogTest {
    private static final String ErrorLogName = "ErrorLogs";
    private WikiPage testPage;
    private MockCommandRunner runner;
    private CompositeExecutionLog log;
    private WikiPage root;
    private FitNesseContext context;

    @Before
    public void setUp() throws Exception {
        this.root = InMemoryPage.makeRoot((String)"RooT");
        this.testPage = this.root.addChildPage("TestPage");
        PageData data = this.testPage.getData();
        WikiPageProperties properties = data.getProperties();
        properties.set("Suites", "Test Page tags");
        this.testPage.commit(data);
        this.context = FitNesseUtil.makeTestContext((WikiPage)this.root);
        this.runner = new MockCommandRunner("some command", 123);
        this.log = new CompositeExecutionLog(this.testPage);
    }

    @Test
    public void publish() throws Exception {
        this.log.add("testSystem1", new ExecutionLog(this.testPage, (CommandRunner)this.runner));
        this.log.add("testSystem2", new ExecutionLog(this.testPage, (CommandRunner)this.runner));
        this.log.publish(this.context.pageFactory);
        WikiPage errorLogPage = this.root.getChildPage(ErrorLogName);
        Assert.assertNotNull((Object)errorLogPage);
        WikiPage testErrorLog = errorLogPage.getChildPage("TestPage");
        Assert.assertNotNull((Object)testErrorLog);
        String content = testErrorLog.getData().getContent();
        RegexTestCase.assertSubString((String)"!3 !-testSystem1", (String)content);
        RegexTestCase.assertSubString((String)"!3 !-testSystem2", (String)content);
        RegexTestCase.assertSubString((String)"'''Command: '''", (String)content);
        RegexTestCase.assertSubString((String)"!-some command-!", (String)content);
        RegexTestCase.assertSubString((String)"'''Exit code: '''", (String)content);
        RegexTestCase.assertSubString((String)"123", (String)content);
        RegexTestCase.assertSubString((String)"'''Date: '''", (String)content);
        RegexTestCase.assertSubString((String)"'''Time elapsed: '''", (String)content);
        RegexTestCase.assertSubString((String)"Test Page tags", (String)testErrorLog.getData().getAttribute("Suites"));
    }
}

