/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.testsystems.slim.tables;

import fitnesse.slim.instructions.MakeInstruction;
import fitnesse.testsystems.slim.tables.LibraryTable;
import fitnesse.testsystems.slim.tables.SlimTableTestSupport;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import util.ListUtility;

public class LibraryTableTest
extends SlimTableTestSupport<LibraryTable> {
    private String tableHeader = "|Library|\n";

    private void buildInstructionsFor(String scriptStatements) throws Exception {
        this.makeSlimTableAndBuildInstructions(this.tableHeader + scriptStatements);
    }

    @Test
    public void emptyInstructionsForLibraryTable() throws Exception {
        this.buildInstructionsFor("||\n");
        Assert.assertEquals((long)0L, (long)this.instructions.size());
    }

    @Test
    public void correctInstructionsForLibraryTableForOneLibrary() throws Exception {
        this.buildInstructionsFor("|echo support|\n");
        List expectedInstructions = ListUtility.list((Object[])new MakeInstruction[]{new MakeInstruction("library_id_0", "library1", "EchoSupport")});
        Assert.assertEquals((Object)expectedInstructions, (Object)this.instructions);
    }

    @Test
    public void correctInstructionsForLibraryTableForMultipleLibraries() throws Exception {
        this.buildInstructionsFor("|echo support|\n|file support|\n");
        List expectedInstructions = ListUtility.list((Object[])new MakeInstruction[]{new MakeInstruction("library_id_0", "library1", "EchoSupport"), new MakeInstruction("library_id_1", "library2", "FileSupport")});
        Assert.assertEquals((Object)expectedInstructions, (Object)this.instructions);
    }
}

