/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.testsystems.slim.tables;

import fitnesse.slim.instructions.Instruction;
import fitnesse.testsystems.slim.SlimTestContext;
import fitnesse.testsystems.slim.Table;
import fitnesse.testsystems.slim.tables.Assertion;
import fitnesse.testsystems.slim.tables.Expectation;
import fitnesse.testsystems.slim.tables.ScenarioTable;
import fitnesse.testsystems.slim.tables.ScriptTable;
import fitnesse.testsystems.slim.tables.SlimTable;
import fitnesse.testsystems.slim.tables.SyntaxError;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import util.ListUtility;

/*
 * Exception performing whole class analysis ignored.
 */
public class ScriptTable
extends SlimTable {
    private static final String SEQUENTIAL_ARGUMENT_PROCESSING_SUFFIX = ";";

    public ScriptTable(Table table, String tableId, SlimTestContext context) {
        super(table, tableId, context);
    }

    protected String getTableType() {
        return "scriptTable";
    }

    public List<Assertion> getAssertions() throws SyntaxError {
        int rows = this.table.getRowCount();
        ArrayList<Assertion> assertions = new ArrayList<Assertion>();
        if (this.isScript() && this.table.getColumnCountInRow(0) > 1) {
            assertions.addAll(this.startActor(0));
        }
        for (int row = 1; row < rows; ++row) {
            assertions.addAll(this.instructionsForRow(row));
        }
        return assertions;
    }

    private boolean isScript() {
        return "script".equalsIgnoreCase(this.table.getCellContents(0, 0));
    }

    private List<Assertion> instructionsForRow(int row) throws SyntaxError {
        String match;
        String firstCell = this.table.getCellContents(0, row).trim();
        List assertions = firstCell.equalsIgnoreCase("start") ? this.startActor(row) : (firstCell.equalsIgnoreCase("check") ? this.checkAction(row) : (firstCell.equalsIgnoreCase("check not") ? this.checkNotAction(row) : (firstCell.equalsIgnoreCase("reject") ? this.reject(row) : (firstCell.equalsIgnoreCase("ensure") ? this.ensure(row) : (firstCell.equalsIgnoreCase("show") ? this.show(row) : (firstCell.equalsIgnoreCase("note") ? this.note(row) : ((match = this.ifSymbolAssignment(0, row)) != null ? this.actionAndAssign(match, row) : (firstCell.length() == 0 ? this.note(row) : (firstCell.trim().startsWith("#") || firstCell.trim().startsWith("*") ? this.note(row) : this.action(row))))))))));
        return assertions;
    }

    private List<Assertion> actionAndAssign(String symbolName, int row) {
        ArrayList<Assertion> assertions = new ArrayList<Assertion>();
        int lastCol = this.table.getColumnCountInRow(row) - 1;
        String actionName = this.getActionNameStartingAt(1, lastCol, row);
        if (!actionName.equals("")) {
            String[] args = this.getArgumentsStartingAt(2, lastCol, row, assertions);
            assertions.add(this.makeAssertion(this.callAndAssign(symbolName, "scriptTableActor", actionName, args), (Expectation)new SlimTable.SymbolAssignmentExpectation((SlimTable)this, symbolName, 0, row)));
        }
        return assertions;
    }

    private List<Assertion> action(int row) throws SyntaxError {
        List assertions = this.assertionsFromScenario(row);
        if (assertions.isEmpty()) {
            int lastCol = this.table.getColumnCountInRow(row) - 1;
            String actionName = this.getActionNameStartingAt(0, lastCol, row);
            String[] args = this.getArgumentsStartingAt(1, lastCol, row, assertions);
            assertions.add(this.makeAssertion(this.callFunction("scriptTableActor", actionName, (Object[])args), (Expectation)new ScriptActionExpectation(this, 0, row, null)));
        }
        return assertions;
    }

    private List<Assertion> assertionsFromScenario(int row) throws SyntaxError {
        int lastCol = this.table.getColumnCountInRow(row) - 1;
        String actionName = this.getActionNameStartingAt(0, lastCol, row);
        ScenarioTable scenario = this.getTestContext().getScenario(SlimTable.Disgracer.disgraceClassName((String)actionName));
        ArrayList<Assertion> assertions = new ArrayList<Assertion>();
        if (scenario != null) {
            String[] args = this.getArgumentsStartingAt(1, lastCol, row, assertions);
            assertions.addAll(scenario.call(args, this, row));
        } else if (lastCol == 0) {
            String firstNameCell = this.table.getCellContents(0, row);
            for (ScenarioTable s : this.getScenariosWithMostArgumentsFirst()) {
                String[] args = s.matchParameters(firstNameCell);
                if (args == null) continue;
                assertions.addAll(s.call(args, this, row));
                break;
            }
        }
        return assertions;
    }

    private List<ScenarioTable> getScenariosWithMostArgumentsFirst() {
        Collection scenarioMap = this.getTestContext().getScenarios();
        ArrayList<ScenarioTable> scenarios = new ArrayList<ScenarioTable>(scenarioMap);
        Collections.sort(scenarios, new ScenarioTableLengthComparator(null));
        return scenarios;
    }

    private List<Assertion> note(int row) {
        return Collections.emptyList();
    }

    private List<Assertion> show(int row) {
        int lastCol = this.table.getColumnCountInRow(row) - 1;
        return this.invokeAction(1, lastCol, row, (Expectation)new ShowActionExpectation(this, 0, row));
    }

    private List<Assertion> ensure(int row) {
        int lastCol = this.table.getColumnCountInRow(row) - 1;
        return this.invokeAction(1, lastCol, row, (Expectation)new EnsureActionExpectation(this, 0, row));
    }

    private List<Assertion> reject(int row) {
        int lastCol = this.table.getColumnCountInRow(row) - 1;
        return this.invokeAction(1, lastCol, row, (Expectation)new RejectActionExpectation(this, 0, row));
    }

    private List<Assertion> checkAction(int row) {
        int lastColInAction = this.table.getColumnCountInRow(row) - 1;
        this.table.getCellContents(lastColInAction, row);
        return this.invokeAction(1, lastColInAction - 1, row, (Expectation)new SlimTable.ReturnedValueExpectation((SlimTable)this, lastColInAction, row));
    }

    private List<Assertion> checkNotAction(int row) {
        int lastColInAction = this.table.getColumnCountInRow(row) - 1;
        this.table.getCellContents(lastColInAction, row);
        return this.invokeAction(1, lastColInAction - 1, row, (Expectation)new SlimTable.RejectedValueExpectation((SlimTable)this, lastColInAction, row));
    }

    private List<Assertion> invokeAction(int startingCol, int endingCol, int row, Expectation expectation) {
        String actionName = this.getActionNameStartingAt(startingCol, endingCol, row);
        ArrayList<Assertion> assertions = new ArrayList<Assertion>();
        String[] args = this.getArgumentsStartingAt(startingCol + 1, endingCol, row, assertions);
        assertions.add(this.makeAssertion(this.callFunction("scriptTableActor", actionName, (Object[])args), expectation));
        return assertions;
    }

    private String getActionNameStartingAt(int startingCol, int endingCol, int row) {
        StringBuffer actionName = new StringBuffer();
        actionName.append(this.table.getCellContents(startingCol, row));
        for (int actionNameCol = startingCol + 2; actionNameCol <= endingCol && !this.invokesSequentialArgumentProcessing(actionName.toString()); actionNameCol += 2) {
            actionName.append(" ").append(this.table.getCellContents(actionNameCol, row));
        }
        return actionName.toString().trim();
    }

    private String[] getArgumentsStartingAt(int startingCol, int endingCol, int row, List<Assertion> assertions) {
        ArgumentExtractor extractor = new ArgumentExtractor(this, startingCol, endingCol, row);
        while (extractor.hasMoreToExtract()) {
            assertions.add(this.makeAssertion(Instruction.NOOP_INSTRUCTION, (Expectation)new ArgumentExpectation(this, ArgumentExtractor.access$200((ArgumentExtractor)extractor), row, null)));
            extractor.extractNextArgument();
        }
        return extractor.getArguments();
    }

    private boolean invokesSequentialArgumentProcessing(String cellContents) {
        return cellContents.endsWith(";");
    }

    private List<Assertion> startActor(int row) {
        int classNameColumn = 1;
        String cellContents = this.table.getCellContents(classNameColumn, row);
        String className = SlimTable.Disgracer.disgraceClassName((String)cellContents);
        return ListUtility.list((Object[])new Assertion[]{this.constructInstance("scriptTableActor", className, classNameColumn, row)});
    }

    static /* synthetic */ boolean access$400(ScriptTable x0, String x1) {
        return x0.invokesSequentialArgumentProcessing(x1);
    }
}

