/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.testsystems.slim.tables;

import fitnesse.testsystems.slim.SlimTestContext;
import fitnesse.testsystems.slim.Table;
import fitnesse.testsystems.slim.tables.DecisionTable;
import fitnesse.testsystems.slim.tables.ImportTable;
import fitnesse.testsystems.slim.tables.LibraryTable;
import fitnesse.testsystems.slim.tables.OrderedQueryTable;
import fitnesse.testsystems.slim.tables.QueryTable;
import fitnesse.testsystems.slim.tables.ScenarioTable;
import fitnesse.testsystems.slim.tables.ScriptTable;
import fitnesse.testsystems.slim.tables.SlimErrorTable;
import fitnesse.testsystems.slim.tables.SlimTable;
import fitnesse.testsystems.slim.tables.SubsetQueryTable;
import fitnesse.testsystems.slim.tables.TableTable;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;

/*
 * Exception performing whole class analysis ignored.
 */
public class SlimTableFactory {
    private static final Map<String, Class<? extends SlimTable>> tableTypes = new HashMap(16);
    private Map<String, String> tableTypeArrays = new HashMap();

    public static void addTableType(String nameOrPrefix, Class<? extends SlimTable> tableClass) {
        if (tableTypes.get(nameOrPrefix) != null) {
            throw new IllegalStateException("A table type named '" + nameOrPrefix + "' already exists");
        }
        tableTypes.put(nameOrPrefix.toLowerCase(), tableClass);
    }

    public SlimTable makeSlimTable(Table table, String tableId, SlimTestContext slimTestContext) {
        String tableType = this.getFullTableName(table.getCellContents(0, 0));
        if (tableType.equalsIgnoreCase("define table type")) {
            this.parseDefineTableTypeTable(table);
            return null;
        }
        if (tableType.equalsIgnoreCase("comment")) {
            return null;
        }
        Class tableClass = this.getTableType(tableType);
        if (tableClass != null) {
            return this.newTableForType(tableClass, table, tableId, slimTestContext);
        }
        if (!this.hasColon(tableType)) {
            return new DecisionTable(table, tableId, slimTestContext);
        }
        return new SlimErrorTable(table, tableId, slimTestContext);
    }

    private boolean hasColon(String tableType) {
        return tableType.contains(":");
    }

    private Class<? extends SlimTable> getTableType(String tableType) {
        if (this.hasColon(tableType)) {
            tableType = tableType.substring(0, tableType.indexOf(58) + 1);
        }
        return (Class)tableTypes.get(tableType.toLowerCase());
    }

    private SlimTable newTableForType(Class<? extends SlimTable> tableClass, Table table, String tableId, SlimTestContext slimTestContext) {
        try {
            Constructor<? extends SlimTable> constructor = tableClass.getConstructor(Table.class, String.class, SlimTestContext.class);
            return constructor.newInstance(table, tableId, slimTestContext);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new SlimErrorTable(table, tableId, slimTestContext);
        }
    }

    private String getFullTableName(String tableName) {
        if (this.hasColon(tableName)) {
            return tableName;
        }
        String disgracedName = SlimTable.Disgracer.disgraceClassName((String)tableName);
        if (this.tableTypeArrays.containsKey(disgracedName)) {
            return (String)this.tableTypeArrays.get(disgracedName) + ":" + tableName;
        }
        return tableName;
    }

    private SlimTable parseDefineTableTypeTable(Table table) {
        for (int rowIndex = 1; rowIndex < table.getRowCount(); ++rowIndex) {
            this.parseDefineTableTypeRow(table, rowIndex);
        }
        return null;
    }

    private void parseDefineTableTypeRow(Table table, int rowIndex) {
        if (table.getColumnCountInRow(rowIndex) >= 2) {
            String fixtureName = table.getCellContents(0, rowIndex);
            String fixture = SlimTable.Disgracer.disgraceClassName((String)fixtureName);
            String tableSpecifier = table.getCellContents(1, rowIndex).toLowerCase();
            this.tableTypeArrays.put(fixture, this.makeTableType(tableSpecifier));
        }
    }

    private String makeTableType(String tableSpecifier) {
        String tableType = tableSpecifier.replace(':', ' ');
        if (tableType.startsWith("as")) {
            tableType = tableType.substring(2);
        }
        return tableType.trim();
    }

    static {
        SlimTableFactory.addTableType((String)"dt:", DecisionTable.class);
        SlimTableFactory.addTableType((String)"decision:", DecisionTable.class);
        SlimTableFactory.addTableType((String)"ordered query:", OrderedQueryTable.class);
        SlimTableFactory.addTableType((String)"subset query:", SubsetQueryTable.class);
        SlimTableFactory.addTableType((String)"query:", QueryTable.class);
        SlimTableFactory.addTableType((String)"table:", TableTable.class);
        SlimTableFactory.addTableType((String)"script", ScriptTable.class);
        SlimTableFactory.addTableType((String)"scenario", ScenarioTable.class);
        SlimTableFactory.addTableType((String)"import", ImportTable.class);
        SlimTableFactory.addTableType((String)"library", LibraryTable.class);
    }
}

