/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wiki;

import fitnesse.wiki.ExternalTestPage;
import fitnesse.wiki.PageType;
import org.junit.Assert;
import org.junit.Test;
import util.FileSystem;
import util.MemoryFileSystem;

public class ExternalTestPageTest {
    @Test
    public void PageDataIsFileContents() throws Exception {
        Assert.assertEquals((Object)"!-stuff-!", (Object)this.makePage("somewhere", "myfile.html", "stuff").getData().getContent());
    }

    @Test
    public void WhenHasNoTableThenIsNotTest() throws Exception {
        Assert.assertFalse((boolean)this.makePage("somewhere", "myfile.html", "stuff").getData().hasAttribute(PageType.TEST.toString()));
    }

    @Test
    public void WhenHasTableThenIsTest() throws Exception {
        Assert.assertTrue((boolean)this.makePage("somewhere", "myfile.html", "stuff and <table>").getData().hasAttribute(PageType.TEST.toString()));
    }

    private ExternalTestPage makePage(String directory, String name, String content) throws Exception {
        MemoryFileSystem fileSystem = new MemoryFileSystem();
        String path = directory + "/" + name;
        fileSystem.makeFile(path, content);
        return new ExternalTestPage(path, name, null, (FileSystem)fileSystem);
    }
}

