/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wiki;

import fitnesse.ComponentFactory;
import fitnesse.wiki.CommitingPage;
import fitnesse.wiki.NoSuchVersionException;
import fitnesse.wiki.PageData;
import fitnesse.wiki.ReadOnlyPageData;
import fitnesse.wiki.VersionInfo;
import fitnesse.wiki.WikiPage;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import util.Clock;
import util.FileSystem;

public class InMemoryPage
extends CommitingPage {
    private static final long serialVersionUID = 1L;
    protected static final String currentVersionName = "current_version";
    protected Map<String, PageData> versions = new ConcurrentHashMap();
    protected Map<String, WikiPage> children = new ConcurrentHashMap();

    public InMemoryPage(String rootPath, String rootPageName, ComponentFactory factory) {
        this(rootPageName, null);
    }

    public InMemoryPage(String rootPath, String rootPageName, FileSystem fileSystem, ComponentFactory factory) {
        this(rootPageName, null);
    }

    protected InMemoryPage(String name, WikiPage parent) {
        super(name, parent);
        this.versions.put(currentVersionName, new PageData((WikiPage)this, ""));
    }

    public WikiPage addChildPage(String name) {
        WikiPage page = this.createChildPage(name);
        this.children.put(name, page);
        return page;
    }

    public static WikiPage makeRoot(String name) {
        return new InMemoryPage(name, null);
    }

    protected WikiPage createChildPage(String name) {
        InMemoryPage newPage = new InMemoryPage(name, (WikiPage)this);
        this.children.put(newPage.getName(), newPage);
        return newPage;
    }

    public void removeChildPage(String name) {
        this.children.remove(name);
    }

    public boolean hasChildPage(String pageName) {
        return this.children.containsKey(pageName);
    }

    protected VersionInfo makeVersion() {
        PageData current = this.getDataVersion(currentVersionName);
        String name = String.valueOf(VersionInfo.nextId());
        VersionInfo version = this.makeVersionInfo(current, name);
        this.versions.put(version.getName(), current);
        return version;
    }

    protected WikiPage getNormalChildPage(String name) {
        return (WikiPage)this.children.get(name);
    }

    public List<WikiPage> getNormalChildren() {
        return new LinkedList<WikiPage>(this.children.values());
    }

    public PageData getData() {
        return new PageData(this.getDataVersion(currentVersionName));
    }

    public ReadOnlyPageData readOnlyData() {
        return this.getDataVersion(currentVersionName);
    }

    public void doCommit(PageData newData) {
        newData.setWikiPage((WikiPage)this);
        newData.getProperties().setLastModificationTime(Clock.currentDate());
        this.versions.put(currentVersionName, newData);
    }

    public PageData getDataVersion(String versionName) {
        PageData version = (PageData)this.versions.get(versionName);
        if (version == null) {
            throw new NoSuchVersionException("There is no version '" + versionName + "'");
        }
        HashSet names = new HashSet(this.versions.keySet());
        names.remove(currentVersionName);
        LinkedList<VersionInfo> pageVersions = new LinkedList<VersionInfo>();
        for (String name : names) {
            PageData data = (PageData)this.versions.get(name);
            pageVersions.add(this.makeVersionInfo(data, name));
        }
        version.addVersions(pageVersions);
        return new PageData(version);
    }

    public int numberOfVersions() {
        return this.versions.size() - 1;
    }

    protected VersionInfo makeVersionInfo(PageData current, String name) {
        String author = current.getAttribute("LastModifyingUser");
        if (author == null) {
            author = "";
        }
        Date date = current.getProperties().getLastModificationTime();
        return new VersionInfo(name, author, date);
    }
}

