/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wiki;

import fitnesse.wiki.InMemoryPage;
import fitnesse.wiki.PageCrawler;
import fitnesse.wiki.PageData;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.VersionInfo;
import fitnesse.wiki.WikiPage;
import java.util.Set;
import junit.framework.TestCase;

/*
 * Exception performing whole class analysis ignored.
 */
public class InMemoryPageTest
extends TestCase {
    private WikiPage root;
    private PageCrawler crawler;
    private WikiPage page1;
    private WikiPage page2;

    public void setUp() throws Exception {
        this.root = InMemoryPage.makeRoot((String)"RooT");
        this.crawler = this.root.getPageCrawler();
        this.page1 = this.crawler.addPage(this.root, PathParser.parse((String)"PageOne"), "page one");
        this.page2 = this.crawler.addPage(this.root, PathParser.parse((String)"PageTwo"), "page two");
    }

    public void tearDown() throws Exception {
    }

    public void testCommitUsesProperPageWhenCommitingFromOtherPage() throws Exception {
        PageData data = this.page1.getData();
        this.page2.commit(data);
        data = this.page2.getData();
        InMemoryPageTest.assertSame((Object)this.page2, (Object)data.getWikiPage());
    }

    public void testVersions() throws Exception {
        PageData data = this.page1.getData();
        data.setContent("version 1");
        this.page1.commit(data);
        data.setContent("version 2");
        this.page1.commit(data);
        data = this.page1.getData();
        Set versions = data.getVersions();
        InMemoryPageTest.assertEquals((int)3, (int)versions.size());
    }

    public void testVersionAuthor() throws Exception {
        PageData data = this.page1.getData();
        Set versions = data.getVersions();
        for (VersionInfo versionInfo : versions) {
            InMemoryPageTest.assertEquals((String)"", (String)versionInfo.getAuthor());
        }
        data.setAttribute("LastModifyingUser", "Joe");
        this.page1.commit(data);
        this.page1.commit(data);
        data = this.page1.getData();
        versions = data.getVersions();
        boolean joeFound = false;
        for (VersionInfo versionInfo : versions) {
            if (!"Joe".equals(versionInfo.getAuthor())) continue;
            joeFound = true;
        }
        InMemoryPageTest.assertTrue((boolean)joeFound);
    }
}

