/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wiki;

import fitnesse.http.ResponseParser;
import fitnesse.wiki.CachingPage;
import fitnesse.wiki.NoSuchVersionException;
import fitnesse.wiki.PageData;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.VersionInfo;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPagePath;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import util.Clock;

/*
 * Exception performing whole class analysis ignored.
 */
public class ProxyPage
extends CachingPage
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static int retrievalCount = 0;
    private String host;
    private int hostPort;
    private WikiPagePath realPath;
    public ResponseParser parser;
    private long lastLoadChildrenTime = 0L;

    public ProxyPage(WikiPage original) {
        super(original.getName(), null);
        this.realPath = original.getPageCrawler().getFullPath(original);
        List children = original.getChildren();
        Iterator iterator = children.iterator();
        while (iterator.hasNext()) {
            ProxyPage child = new ProxyPage((WikiPage)iterator.next());
            child.parent = this;
            this.children.put(child.getName(), child);
        }
    }

    protected ProxyPage(String name, WikiPage parent) {
        super(name, parent);
    }

    public ProxyPage(String name, WikiPage parent, String host, int port, WikiPagePath path) {
        super(name, parent);
        this.host = host;
        this.hostPort = port;
        this.realPath = path;
    }

    public static ProxyPage retrievePage(String urlString) {
        URL url;
        ++retrievalCount;
        try {
            url = new URL(urlString + "?responder=proxy&type=bones");
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        ProxyPage page = (ProxyPage)ProxyPage.getObjectFromUrl((URL)url);
        page.setTransientValues(url.getHost(), Clock.currentTimeInMillis());
        int port = url.getPort();
        page.setHostPort(port == -1 ? 80 : port);
        page.lastLoadChildrenTime = Clock.currentTimeInMillis();
        return page;
    }

    protected WikiPage createChildPage(String name) {
        WikiPagePath childPath = this.realPath.copy().addNameToEnd(name);
        return new ProxyPage(name, (WikiPage)this, this.host, this.getHostPort(), childPath);
    }

    protected void loadChildren() {
        if ((long)cacheTime <= Clock.currentTimeInMillis() - this.lastLoadChildrenTime) {
            ProxyPage page = ProxyPage.retrievePage((String)this.getThisPageUrl());
            this.children.clear();
            for (ProxyPage child : page.children.values()) {
                child.parent = this;
                this.children.put(child.getName(), child);
            }
            this.lastLoadChildrenTime = Clock.currentTimeInMillis();
        }
    }

    public String getThisPageUrl() {
        StringBuffer url = new StringBuffer("http://");
        url.append(this.host);
        url.append(":").append(this.getHostPort());
        url.append("/").append(PathParser.render((WikiPagePath)this.realPath));
        return url.toString();
    }

    public boolean hasChildPage(String pageName) {
        if (this.children.containsKey(pageName)) {
            return true;
        }
        this.loadChildren();
        return this.children.containsKey(pageName);
    }

    public void setTransientValues(String host, long lastLoadTime) {
        this.host = host;
        this.lastLoadChildrenTime = lastLoadTime;
        for (ProxyPage page : this.children.values()) {
            page.setTransientValues(host, lastLoadTime);
        }
    }

    public String getHost() {
        return this.host;
    }

    public void setHostPort(int port) {
        this.hostPort = port;
        for (ProxyPage page : this.children.values()) {
            page.setHostPort(port);
        }
    }

    public int getHostPort() {
        return this.hostPort;
    }

    public PageData getMeat() {
        return this.getMeat(null);
    }

    public PageData getMeat(String versionName) {
        URL url;
        StringBuffer urlString = new StringBuffer(this.getThisPageUrl());
        urlString.append("?responder=proxy&type=meat");
        if (versionName != null) {
            urlString.append("&version=").append(versionName);
        }
        try {
            url = new URL(urlString.toString());
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        PageData data = (PageData)ProxyPage.getObjectFromUrl((URL)url);
        if (data != null) {
            data.setWikiPage((WikiPage)this);
        }
        return data;
    }

    private static Object getObjectFromUrl(URL url) {
        InputStream is = null;
        ObjectInputStream ois = null;
        try {
            Object obj;
            is = url.openStream();
            ois = new ObjectInputStream(is);
            Object object = obj = ois.readObject();
            return object;
        }
        catch (IOException e) {
            throw new RuntimeException("An error occured reading data from " + url, e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("An error occured reading data from " + url, e);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
                if (ois != null) {
                    ois.close();
                }
            }
            catch (IOException e) {}
        }
    }

    protected PageData makePageData() {
        return this.getMeat();
    }

    public PageData getDataVersion(String versionName) {
        PageData data = this.getMeat(versionName);
        if (data == null) {
            throw new NoSuchVersionException("There is no version '" + versionName + "'");
        }
        return data;
    }

    public boolean isOpenInNewWindow() {
        return true;
    }

    protected VersionInfo makeVersion() {
        return null;
    }

    protected void doCommit(PageData data) {
    }
}

