/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wiki;

import fitnesse.testutil.FitNesseUtil;
import fitnesse.wiki.CachingPage;
import fitnesse.wiki.InMemoryPage;
import fitnesse.wiki.PageCrawler;
import fitnesse.wiki.PageData;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.ProxyPage;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPagePath;
import java.util.List;
import junit.framework.TestCase;
import util.Clock;

/*
 * Exception performing whole class analysis ignored.
 */
public class ProxyPageTest
extends TestCase {
    private WikiPage root;
    private WikiPage original;
    private ProxyPage proxy;
    public WikiPage child1;
    private PageCrawler crawler;
    private WikiPagePath page1Path;

    public void setUp() throws Exception {
        CachingPage.cacheTime = 0;
        this.root = InMemoryPage.makeRoot((String)"RooT");
        this.crawler = this.root.getPageCrawler();
        this.page1Path = PathParser.parse((String)"PageOne");
        this.original = this.crawler.addPage(this.root, this.page1Path, "page one content");
        this.child1 = this.crawler.addPage(this.original, PathParser.parse((String)"ChildOne"), "child one");
        this.crawler.addPage(this.original, PathParser.parse((String)"ChildTwo"), "child two");
        PageData data = this.original.getData();
        data.setAttribute("Attr1");
        this.original.commit(data);
        FitNesseUtil.startFitnesse((WikiPage)this.root);
        this.proxy = new ProxyPage(this.original);
        this.proxy.setTransientValues("localhost", Clock.currentTimeInMillis());
        this.proxy.setHostPort(1999);
    }

    public void tearDown() throws Exception {
        FitNesseUtil.stopFitnesse();
    }

    public void testConstructor() throws Exception {
        ProxyPageTest.assertEquals((String)"page one content", (String)this.proxy.getData().getContent());
        ProxyPageTest.assertEquals((String)"PageOne", (String)this.proxy.getName());
        ProxyPageTest.assertEquals((boolean)true, (boolean)this.proxy.getData().hasAttribute("Attr1"));
    }

    public void testHasChildren() throws Exception {
        ProxyPageTest.assertEquals((boolean)false, (boolean)this.proxy.hasChildPage("BlaH"));
        ProxyPageTest.assertEquals((boolean)true, (boolean)this.proxy.hasChildPage("ChildOne"));
        ProxyPageTest.assertEquals((boolean)true, (boolean)this.proxy.hasChildPage("ChildTwo"));
    }

    public void testGetChildrenOneAtATime() throws Exception {
        WikiPage child1 = this.proxy.getChildPage("ChildOne");
        ProxyPageTest.assertEquals((String)"child one", (String)child1.getData().getContent());
        WikiPage child2 = this.proxy.getChildPage("ChildTwo");
        ProxyPageTest.assertEquals((String)"child two", (String)child2.getData().getContent());
    }

    public void testGetAllChildren() throws Exception {
        List children = this.proxy.getChildren();
        ProxyPageTest.assertEquals((int)2, (int)children.size());
        WikiPage child = (WikiPage)children.get(0);
        ProxyPageTest.assertEquals((boolean)true, ("ChildOne".equals(child.getName()) || "ChildTwo".equals(child.getName()) ? 1 : 0) != 0);
        child = (WikiPage)children.get(1);
        ProxyPageTest.assertEquals((boolean)true, ("ChildOne".equals(child.getName()) || "ChildTwo".equals(child.getName()) ? 1 : 0) != 0);
    }

    public void testSetHostAndPort() throws Exception {
        List children = this.proxy.getChildren();
        this.proxy.setTransientValues("a.new.host", Clock.currentTimeInMillis());
        this.proxy.setHostPort(123);
        ProxyPageTest.assertEquals((String)"a.new.host", (String)this.proxy.getHost());
        ProxyPageTest.assertEquals((int)123, (int)this.proxy.getHostPort());
        for (ProxyPage page : children) {
            ProxyPageTest.assertEquals((String)"a.new.host", (String)page.getHost());
            ProxyPageTest.assertEquals((int)123, (int)page.getHostPort());
        }
    }

    public void testCanFindNewChildOfAProxy() throws Exception {
        ProxyPage child1Proxy = (ProxyPage)this.proxy.getChildPage("ChildOne");
        ProxyPageTest.assertNull((Object)child1Proxy.getChildPage("ChildOneChild"));
        this.crawler.addPage(this.child1, PathParser.parse((String)"ChildOneChild"), "child one child");
        ProxyPageTest.assertNotNull((Object)child1Proxy.getChildPage("ChildOneChild"));
    }

    public void testHasSubpageCallsLoadChildrenNoMoreThanNeeded() throws Exception {
        this.proxy.loadChildren();
        ProxyPage.retrievalCount = 0;
        this.proxy.hasChildPage("ChildTwo");
        ProxyPageTest.assertEquals((int)0, (int)ProxyPage.retrievalCount);
        this.proxy.hasChildPage("SomeMissingChild");
        ProxyPageTest.assertEquals((int)1, (int)ProxyPage.retrievalCount);
    }
}

