/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wiki;

import fitnesse.wiki.PageCrawler;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPagePath;
import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import util.StringUtil;

public class WikiPagePath
implements Comparable<Object>,
Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    private LinkedList<String> names = new LinkedList();
    private Mode mode = Mode.RELATIVE;

    public WikiPagePath() {
    }

    public WikiPagePath(String[] names) {
        for (int i = 0; i < names.length; ++i) {
            this.addNameToEnd(names[i]);
        }
    }

    public WikiPagePath clone() {
        WikiPagePath clone = new WikiPagePath();
        clone.names = (LinkedList)this.names.clone();
        clone.mode = this.mode;
        return clone;
    }

    public WikiPagePath copy() {
        return this.clone();
    }

    public WikiPagePath(WikiPage page) {
        PageCrawler crawler = page.getPageCrawler();
        while (!crawler.isRoot(page)) {
            this.names.addFirst(page.getName());
            page = page.getParent();
        }
    }

    public WikiPagePath(WikiPagePath path) {
        this.mode = path.mode;
        WikiPagePath p = path;
        while (!p.isEmpty()) {
            this.addNameToEnd(p.getFirst());
            p = p.getRest();
        }
    }

    private WikiPagePath(List<String> names) {
        this.names = new LinkedList<String>(names);
    }

    public String getFirst() {
        return this.isEmpty() ? null : (String)this.names.get(0);
    }

    public WikiPagePath addNameToEnd(String name) {
        this.names.add(name);
        return this;
    }

    public WikiPagePath addNameToFront(String name) {
        this.names.addFirst(name);
        return this;
    }

    public WikiPagePath getRest() {
        int size = this.names.size();
        return size <= 1 ? new WikiPagePath() : new WikiPagePath(this.names.subList(1, size));
    }

    public boolean isEmpty() {
        return this.names.size() == 0;
    }

    public String last() {
        return this.names.size() == 0 ? null : (String)this.names.get(this.names.size() - 1);
    }

    public List<String> getNames() {
        return this.names;
    }

    public String toString() {
        String prefix = "";
        if (this.mode == Mode.ABSOLUTE) {
            prefix = ".";
        } else if (this.mode == Mode.SUB_PAGE) {
            prefix = ">";
        } else if (this.mode == Mode.BACKWARD_SEARCH) {
            prefix = "<";
        }
        return prefix + StringUtil.join((List)this.names, (String)".");
    }

    public void removeNameFromEnd() {
        if (this.names.size() > 0) {
            this.names.removeLast();
        }
    }

    public WikiPagePath append(WikiPagePath childPath) {
        WikiPagePath newPath = new WikiPagePath(this);
        WikiPagePath p = childPath;
        while (!p.isEmpty()) {
            newPath.addNameToEnd(p.getFirst());
            p = p.getRest();
        }
        return newPath;
    }

    public boolean isAbsolute() {
        return this.mode == Mode.ABSOLUTE;
    }

    public void makeAbsolute() {
        this.mode = Mode.ABSOLUTE;
    }

    public int hashCode() {
        return StringUtil.join((List)this.names, (String)"").hashCode();
    }

    public WikiPagePath relativePath() {
        if (this.isAbsolute()) {
            WikiPagePath relativePath = new WikiPagePath(this);
            relativePath.setPathMode(Mode.RELATIVE);
            return relativePath;
        }
        return this;
    }

    @Override
    public int compareTo(Object o) {
        if (o instanceof WikiPagePath) {
            WikiPagePath p = (WikiPagePath)o;
            String compressedName = StringUtil.join((List)this.names, (String)"");
            String compressedArgumentName = StringUtil.join((List)p.names, (String)"");
            return compressedName.compareTo(compressedArgumentName);
        }
        return 1;
    }

    public boolean equals(Object o) {
        if (o instanceof WikiPagePath) {
            WikiPagePath that = (WikiPagePath)o;
            return this.mode == that.mode && this.names.equals(that.names);
        }
        return false;
    }

    public WikiPagePath parentPath() {
        WikiPagePath parentPath = new WikiPagePath(this);
        parentPath.removeNameFromEnd();
        return parentPath;
    }

    public boolean startsWith(WikiPagePath that) {
        if (that.names.size() > this.names.size()) {
            return false;
        }
        Iterator thisIterator = this.names.iterator();
        for (String name : that.names) {
            Object thisNext = thisIterator.next();
            if (thisNext.equals(name)) continue;
            return false;
        }
        return true;
    }

    public WikiPagePath withNameAdded(String name) {
        WikiPagePath path = new WikiPagePath(this);
        path.addNameToEnd(name);
        return path;
    }

    public WikiPagePath subtractFromFront(WikiPagePath operand) {
        WikiPagePath difference = new WikiPagePath(this);
        if (difference.startsWith(operand)) {
            String name;
            difference.setPathMode(Mode.RELATIVE);
            Iterator i$ = operand.getNames().iterator();
            while (i$.hasNext() && (name = (String)i$.next()).equals(difference.getFirst())) {
                difference.names.removeFirst();
            }
        }
        return difference;
    }

    public void setPathMode(Mode mode) {
        this.mode = mode;
    }

    public boolean isRelativePath() {
        return this.mode == Mode.RELATIVE;
    }

    public boolean isSubPagePath() {
        return this.mode == Mode.SUB_PAGE;
    }

    public boolean isBackwardSearchPath() {
        return this.mode == Mode.BACKWARD_SEARCH;
    }
}

