/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wikitext.test;

import fitnesse.html.HtmlElement;
import fitnesse.wiki.WikiPage;
import fitnesse.wikitext.test.ParserTestHelper;
import fitnesse.wikitext.test.TestRoot;
import org.junit.Assert;
import org.junit.Test;

public class ContentsTest {
    @Test
    public void scansContents() {
        ParserTestHelper.assertScansTokenType((String)"!contents", (String)"Contents", (boolean)true);
        ParserTestHelper.assertScansTokenType((String)" !contents", (String)"Contents", (boolean)false);
        ParserTestHelper.assertScansTokenType((String)"!note !contents", (String)"Contents", (boolean)true);
        ParserTestHelper.assertScansTokenType((String)"| !contents|\n", (String)"Contents", (boolean)true);
    }

    @Test
    public void parsesContents() throws Exception {
        ParserTestHelper.assertParses((String)"!contents -f -g", (String)"SymbolList[Contents[Text, Text]]");
        ParserTestHelper.assertParses((String)"!contents hi", (String)"SymbolList[Text, Whitespace, Text]");
        ParserTestHelper.assertParses((String)"!contents ]", (String)"SymbolList[Text, Whitespace, CloseBracket]");
    }

    @Test
    public void translatesContents() throws Exception {
        WikiPage pageOne = this.makePages();
        ParserTestHelper.assertTranslatesTo((WikiPage)pageOne, (String)"!contents", (String)this.contentsWithPages("PageThree", "PageTwo", ""));
    }

    @Test
    public void translatesContentsInInclude() throws Exception {
        WikiPage pageOne = this.makePages();
        this.assertContains(ParserTestHelper.translateTo((WikiPage)pageOne, (String)"!include >PageTwo"), this.contentsWithPages("PageThree", "PageTwo", ""));
    }

    @Test
    public void translatesRecursiveContents() throws Exception {
        WikiPage pageOne = this.makePages();
        ParserTestHelper.assertTranslatesTo((WikiPage)pageOne, (String)"!contents -R", (String)this.contentsWithPages("PageThree", "PageTwo", this.nestedContents("\t\t\t\t", "2", "<a href=\"PageOne.PageTwo.PageTwoChild\">PageTwoChild</a>", this.nestedContents("\t\t\t\t\t\t\t\t", "3", "<a href=\"PageOne.PageTwo.PageTwoChild.PageTwoGrandChild\">PageTwoGrandChild</a>", ""))));
    }

    @Test
    public void translatesRecursiveContentsToLevel() throws Exception {
        WikiPage pageOne = this.makePages();
        ParserTestHelper.assertTranslatesTo((WikiPage)pageOne, (String)"!contents -R2", (String)this.contentsWithPages("PageThree", "PageTwo", this.nestedContents("\t\t\t\t", "2", "<a href=\"PageOne.PageTwo.PageTwoChild\">PageTwoChild ...</a>", "")));
    }

    @Test
    public void translatesContentsWithInvalidRecursionLimit() throws Exception {
        WikiPage pageOne = this.makePages();
        ParserTestHelper.assertTranslatesTo((WikiPage)pageOne, (String)"!contents -Rx", (String)this.contentsWithPages("PageThree", "PageTwo", ""));
    }

    private WikiPage makePages() throws Exception {
        TestRoot root = new TestRoot();
        WikiPage pageOne = root.makePage("PageOne");
        WikiPage pageTwo = root.makePage(pageOne, "PageTwo", "!contents");
        WikiPage pageTwoChild = root.makePage(pageTwo, "PageTwoChild");
        root.makePage(pageTwoChild, "PageTwoGrandChild");
        root.makePage(pageOne, "PageThree");
        return pageOne;
    }

    private String contentsWithPages(String name1, String name2, String nested) {
        return "<div class=\"toc1\">" + HtmlElement.endl + "\t<div class=\"contents\">" + HtmlElement.endl + "\t\t<b>Contents:</b>" + HtmlElement.endl + "\t\t<ul>" + HtmlElement.endl + "\t\t\t<li>" + HtmlElement.endl + "\t\t\t\t<a href=\"PageOne.PageThree\">" + name1 + "</a>" + HtmlElement.endl + "\t\t\t</li>" + HtmlElement.endl + "\t\t\t<li>" + HtmlElement.endl + "\t\t\t\t<a href=\"PageOne.PageTwo\">" + name2 + "</a>" + HtmlElement.endl + nested + "\t\t\t</li>" + HtmlElement.endl + "\t\t</ul>" + HtmlElement.endl + "\t</div>" + HtmlElement.endl + "</div>" + HtmlElement.endl;
    }

    private String nestedContents(String indent, String level, String pageReference, String nested) {
        return indent + "<div class=\"toc" + level + "\">" + HtmlElement.endl + indent + "\t<div class=\"nested-contents\">" + HtmlElement.endl + indent + "\t\t<ul>" + HtmlElement.endl + indent + "\t\t\t<li>" + HtmlElement.endl + indent + "\t\t\t\t" + pageReference + HtmlElement.endl + nested + indent + "\t\t\t</li>" + HtmlElement.endl + indent + "\t\t</ul>" + HtmlElement.endl + indent + "\t</div>" + HtmlElement.endl + indent + "</div>" + HtmlElement.endl;
    }

    private void assertContains(String result, String substring) {
        Assert.assertTrue((String)result, (boolean)result.contains(substring));
    }
}

