/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wikitext.test;

import fitnesse.wikitext.test.ParserTestHelper;
import org.junit.Test;

public class StyleTest {
    @Test
    public void scansParenthesisStyle() throws Exception {
        ParserTestHelper.assertScansTokenType((String)"!style_x(my text)", (String)"Style", (boolean)true);
        ParserTestHelper.assertScansTokenType((String)"!style_style(my text)", (String)"Style", (boolean)true);
        ParserTestHelper.assertScansTokenType((String)"!style(Hi)", (String)"Style", (boolean)false);
        ParserTestHelper.assertScansTokenType((String)"!style_(Hi)", (String)"Style", (boolean)false);
        ParserTestHelper.assertScansTokenType((String)"!style_myStyle(hi))", (String)"Style", (boolean)true);
    }

    @Test
    public void scansBraceStyle() throws Exception {
        ParserTestHelper.assertScansTokenType((String)"!style_x{my text}", (String)"Style", (boolean)true);
        ParserTestHelper.assertScansTokenType((String)"!style_style{my text}", (String)"Style", (boolean)true);
        ParserTestHelper.assertScansTokenType((String)"!style{Hi}", (String)"Style", (boolean)false);
        ParserTestHelper.assertScansTokenType((String)"!style_{Hi}", (String)"Style", (boolean)false);
        ParserTestHelper.assertScansTokenType((String)"!style_myStyle{hi}}", (String)"Style", (boolean)true);
    }

    @Test
    public void scansBracketStyle() throws Exception {
        ParserTestHelper.assertScansTokenType((String)"!style_x[my text]", (String)"Style", (boolean)true);
        ParserTestHelper.assertScansTokenType((String)"!style_style[my text]", (String)"Style", (boolean)true);
        ParserTestHelper.assertScansTokenType((String)"!style[Hi]", (String)"Style", (boolean)false);
        ParserTestHelper.assertScansTokenType((String)"!style_[Hi]", (String)"Style", (boolean)false);
        ParserTestHelper.assertScansTokenType((String)"!style_myStyle[hi]]", (String)"Style", (boolean)true);
    }

    @Test
    public void translatesStyle() {
        ParserTestHelper.assertTranslatesTo((String)"!style_myStyle(wow zap)", (String)"<span class=\"myStyle\">wow zap</span>");
        ParserTestHelper.assertTranslatesTo((String)"!style_myStyle[wow zap]", (String)"<span class=\"myStyle\">wow zap</span>");
        ParserTestHelper.assertTranslatesTo((String)"!style_myStyle[)]", (String)"<span class=\"myStyle\">)</span>");
        ParserTestHelper.assertTranslatesTo((String)"!style_myStyle{wow zap}", (String)"<span class=\"myStyle\">wow zap</span>");
    }

    @Test
    public void ignoresMismatchedStyle() {
        ParserTestHelper.assertTranslatesTo((String)"!style_myStyle[stuff)", (String)"!style_myStyle[stuff)");
    }

    @Test
    public void translatesNestedStyle() {
        ParserTestHelper.assertTranslatesTo((String)"!style_myStyle(!style_otherStyle(stuff))", (String)"<span class=\"myStyle\"><span class=\"otherStyle\">stuff</span></span>");
    }

    @Test
    public void translatesOverlappedStyle() {
        ParserTestHelper.assertTranslatesTo((String)"!style_red(!style_blue{a)}", (String)"!style_red(<span class=\"blue\">a)</span>");
    }
}

