/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wikitext.test;

import fitnesse.wikitext.parser.SymbolMatch;
import fitnesse.wikitext.parser.SymbolMatcher;
import fitnesse.wikitext.parser.SymbolProvider;
import fitnesse.wikitext.parser.SymbolType;
import org.junit.Assert;
import org.junit.Test;

public class SymbolProviderTest {
    private final SymbolMatch testMatch = new SymbolMatch(SymbolType.OpenBrace, "hi");

    @Test
    public void findsMatch() {
        SymbolProvider testProvider = new SymbolProvider(new SymbolType[]{SymbolType.OpenBrace});
        this.assertMatches(testProvider, this.testMatch, '{');
    }

    @Test
    public void findsNoMatch() {
        SymbolProvider testProvider = new SymbolProvider(new SymbolType[]{SymbolType.OpenBrace});
        this.assertMatches(testProvider, SymbolMatch.noMatch, '}');
    }

    @Test
    public void findsMatchFromParent() {
        SymbolProvider parentProvider = new SymbolProvider(new SymbolType[]{SymbolType.CloseBrace});
        SymbolProvider testProvider = new SymbolProvider(parentProvider);
        parentProvider.add(SymbolType.OpenBrace);
        this.assertMatches(testProvider, this.testMatch, '{');
    }

    private void assertMatches(SymbolProvider testProvider, SymbolMatch expected, char startCharacter) {
        SymbolMatch result = testProvider.findMatch(Character.valueOf(startCharacter), (SymbolMatcher)new /* Unavailable Anonymous Inner Class!! */);
        Assert.assertSame((Object)expected, (Object)result);
    }

    static /* synthetic */ SymbolMatch access$000(SymbolProviderTest x0) {
        return x0.testMatch;
    }
}

