/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wikitext.test;

import fitnesse.wikitext.parser.ParseSpecification;
import fitnesse.wikitext.parser.SourcePage;
import fitnesse.wikitext.parser.SymbolMatch;
import fitnesse.wikitext.parser.SymbolType;
import fitnesse.wikitext.parser.TextMaker;
import fitnesse.wikitext.parser.VariableSource;
import fitnesse.wikitext.parser.WikiWord;
import fitnesse.wikitext.test.TestSourcePage;
import fitnesse.wikitext.test.TestVariableSource;
import org.junit.Assert;
import org.junit.Test;

public class TextMakerTest {
    private VariableSource source = new TestVariableSource("x", "y");
    private SourcePage sourcePage = new TestSourcePage();

    @Test
    public void makesText() {
        this.assertText("hi");
    }

    @Test
    public void makesTextFromWikiWordWithUnderscore() {
        this.assertText("HiMom_Dad");
    }

    private void assertText(String input) {
        SymbolMatch match = this.makeMatch(input);
        Assert.assertTrue((boolean)match.getSymbol().isType(SymbolType.Text));
        Assert.assertEquals((Object)input, (Object)match.getSymbol().getContent());
        Assert.assertEquals((long)input.length(), (long)match.getMatchLength());
    }

    @Test
    public void makesWikiWord() {
        this.assertWikiWord("HiMom", "HiMom");
    }

    @Test
    public void makesWikiWordWithTrailingText() {
        this.assertWikiWord("HiMom's", "HiMom");
    }

    @Test
    public void makesWikiWordWithIncludedDots() {
        this.assertWikiWord("HiMom.HiDad", "HiMom.HiDad");
    }

    @Test
    public void makesWikiWordWithTrailingDots() {
        this.assertWikiWord("HiMom..HiDad", "HiMom");
    }

    private void assertWikiWord(String input, String wikiWord) {
        SymbolMatch match = this.makeMatch(input);
        Assert.assertTrue((boolean)match.getSymbol().isType((SymbolType)WikiWord.symbolType));
        Assert.assertEquals((Object)wikiWord, (Object)match.getSymbol().getContent());
        Assert.assertEquals((long)wikiWord.length(), (long)match.getMatchLength());
    }

    @Test
    public void makesEMail() {
        SymbolMatch match = this.makeMatch("bob@bl.org");
        Assert.assertTrue((boolean)match.getSymbol().isType(SymbolType.EMail));
        Assert.assertEquals((Object)"bob@bl.org", (Object)match.getSymbol().getContent());
        Assert.assertEquals((long)10L, (long)match.getMatchLength());
    }

    private SymbolMatch makeMatch(String text) {
        return new TextMaker(this.source, this.sourcePage).make(new ParseSpecification(), text);
    }
}

