/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wikitext.test;

import fitnesse.wiki.InMemoryPage;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.ProxyPage;
import fitnesse.wiki.WikiPage;
import fitnesse.wikitext.parser.SourcePage;
import fitnesse.wikitext.parser.WikiSourcePage;
import fitnesse.wikitext.test.TestRoot;
import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Test;

public class WikiSourcePageTest {
    @Test
    public void getsChildren() {
        TestRoot root = new TestRoot();
        WikiPage page = root.makePage("PageOne");
        root.makePage(page, "PageTwo");
        root.makePage(page, "PageThree");
        WikiSourcePage source = new WikiSourcePage(page);
        ArrayList<String> names = new ArrayList<String>();
        for (SourcePage child : source.getChildren()) {
            names.add(child.getName());
        }
        Assert.assertEquals((long)2L, (long)names.size());
        Assert.assertTrue((boolean)names.contains("PageTwo"));
        Assert.assertTrue((boolean)names.contains("PageThree"));
    }

    @Test
    public void getsUrlForPage() {
        WikiPage test = new TestRoot().makePage("MyPage");
        Assert.assertEquals((Object)"WikiPath", (Object)new WikiSourcePage(test).makeUrl("WikiPath"));
    }

    @Test
    public void getsUrlForProxyPage() {
        WikiPage root = InMemoryPage.makeRoot((String)"RooT");
        ProxyPage virtualPage = new ProxyPage("VirtualPage", root, "host", 9999, PathParser.parse((String)"RealPage.VirtualPage"));
        Assert.assertEquals((Object)"http://host:9999/RealPage.WikiPath", (Object)new WikiSourcePage((WikiPage)virtualPage).makeUrl("WikiPath"));
    }
}

