/*
 * Decompiled with CFR 0.152.
 */
package org.junit.experimental.max;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.junit.experimental.max.CouldNotReadCoreException;
import org.junit.experimental.max.MaxHistory;
import org.junit.runner.Description;
import org.junit.runner.notification.RunListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class MaxHistory
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Map<String, Long> fDurations = new HashMap();
    private final Map<String, Long> fFailureTimestamps = new HashMap();
    private final File fHistoryStore;

    public static MaxHistory forFolder(File file) {
        if (file.exists()) {
            try {
                return MaxHistory.readHistory((File)file);
            }
            catch (CouldNotReadCoreException e) {
                e.printStackTrace();
                file.delete();
            }
        }
        return new MaxHistory(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    private static MaxHistory readHistory(File storedResults) throws CouldNotReadCoreException {
        try {
            FileInputStream file = new FileInputStream(storedResults);
            try {
                MaxHistory maxHistory;
                ObjectInputStream stream = new ObjectInputStream(file);
                try {
                    maxHistory = (MaxHistory)stream.readObject();
                }
                catch (Throwable throwable) {
                    stream.close();
                    throw throwable;
                }
                stream.close();
                return maxHistory;
            }
            finally {
                file.close();
            }
        }
        catch (Exception e) {
            throw new CouldNotReadCoreException((Throwable)e);
        }
    }

    private MaxHistory(File storedResults) {
        this.fHistoryStore = storedResults;
    }

    private void save() throws IOException {
        ObjectOutputStream stream = new ObjectOutputStream(new FileOutputStream(this.fHistoryStore));
        stream.writeObject(this);
        stream.close();
    }

    Long getFailureTimestamp(Description key) {
        return (Long)this.fFailureTimestamps.get(key.toString());
    }

    void putTestFailureTimestamp(Description key, long end) {
        this.fFailureTimestamps.put(key.toString(), end);
    }

    boolean isNewTest(Description key) {
        return !this.fDurations.containsKey(key.toString());
    }

    Long getTestDuration(Description key) {
        return (Long)this.fDurations.get(key.toString());
    }

    void putTestDuration(Description description, long duration) {
        this.fDurations.put(description.toString(), duration);
    }

    public RunListener listener() {
        return new RememberingListener(this, null);
    }

    public Comparator<Description> testComparator() {
        return new TestComparator(this, null);
    }

    static /* synthetic */ void access$000(MaxHistory x0) throws IOException {
        x0.save();
    }
}

