/*
 * Decompiled with CFR 0.152.
 */
package org.junit.rules;

import java.util.concurrent.TimeUnit;
import org.junit.internal.AssumptionViolatedException;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;

public class Stopwatch
extends TestWatcher {
    private long fStartNanos;
    private long fEndNanos;

    public long runtime(TimeUnit unit) {
        return unit.convert(this.currentNanoTime() - this.fStartNanos, TimeUnit.NANOSECONDS);
    }

    protected void succeeded(long nanos, Description description) {
    }

    protected void failed(long nanos, Throwable e, Description description) {
    }

    protected void skipped(long nanos, AssumptionViolatedException e, Description description) {
    }

    protected void finished(long nanos, Description description) {
    }

    public static long toMicros(long nanos) {
        return TimeUnit.NANOSECONDS.toMicros(nanos);
    }

    public static long toMillis(long nanos) {
        return TimeUnit.NANOSECONDS.toMillis(nanos);
    }

    public static long toSeconds(long nanos) {
        return TimeUnit.NANOSECONDS.toSeconds(nanos);
    }

    private long getNanos() {
        return this.fEndNanos - this.fStartNanos;
    }

    private void starting() {
        this.fStartNanos = this.currentNanoTime();
    }

    private void stopping() {
        this.fEndNanos = this.currentNanoTime();
    }

    private long currentNanoTime() {
        return System.nanoTime();
    }

    protected final void succeeded(Description description) {
        this.stopping();
        this.succeeded(this.getNanos(), description);
    }

    protected final void failed(Throwable e, Description description) {
        this.stopping();
        this.failed(this.getNanos(), e, description);
    }

    protected final void skipped(AssumptionViolatedException e, Description description) {
        this.stopping();
        this.skipped(this.getNanos(), e, description);
    }

    protected final void starting(Description description) {
        this.starting();
    }

    protected final void finished(Description description) {
        this.finished(this.getNanos(), description);
    }
}

