/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.maven.plugin.enforcer;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import org.apache.commons.io.IOUtils;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rule.api.EnforcerRuleHelper;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scijava.maven.plugin.enforcer.EnforcerRuleHelperMock;
import org.scijava.maven.plugin.enforcer.NoSubpackageDependenceRule;

public class NoSubpackageDependenceRuleIntegrationTest {
    private static final URL FITNESSE_TARGET_FOLDER = NoSubpackageDependenceRuleIntegrationTest.getResource("fitnesse-target");
    private static final URL FITNESSE_EXPECTED_OUTPUT = NoSubpackageDependenceRuleIntegrationTest.getResource("fitnesse-expected-output-subpackage-dependence.txt");
    private static final URL JUNIT_TARGET_FOLDER = NoSubpackageDependenceRuleIntegrationTest.getResource("junit-target");
    private static final URL JUNIT_EXPECTED_OUTPUT = NoSubpackageDependenceRuleIntegrationTest.getResource("junit-expected-output-subpackage-dependence.txt");
    private NoSubpackageDependenceRule rule;
    private EnforcerRuleHelperMock helper;

    @Before
    public void setUp() throws Exception {
        this.rule = new NoSubpackageDependenceRule();
        this.helper = new EnforcerRuleHelperMock();
    }

    @Test
    public void fitnesseIntegrationTest() throws Exception {
        this.assertPackageCycles(FITNESSE_TARGET_FOLDER, FITNESSE_EXPECTED_OUTPUT);
    }

    @Test
    public void junitIntegrationTest() throws Exception {
        this.assertPackageCycles(JUNIT_TARGET_FOLDER, JUNIT_EXPECTED_OUTPUT);
    }

    private void assertPackageCycles(URL targetFolder, URL expectedOutput) throws URISyntaxException, IOException {
        this.helper.setTestClassesDir(new File("non-existent"));
        this.helper.setClassesDir(new File(targetFolder.toURI()));
        try {
            this.rule.execute((EnforcerRuleHelper)this.helper);
            Assert.fail((String)"expected EnforcerRuleException");
        }
        catch (EnforcerRuleException e) {
            Assert.assertEquals((Object)this.getExpectedOutput(expectedOutput), (Object)e.getMessage());
        }
    }

    private String getExpectedOutput(URL expectedOutput) throws IOException {
        return IOUtils.toString((InputStream)expectedOutput.openStream()).replaceAll("\r", "");
    }

    private static URL getResource(String path) {
        return Thread.currentThread().getContextClassLoader().getResource(path);
    }
}

