/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.maven.plugin.enforcer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import jdepend.framework.JavaPackage;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.scijava.maven.plugin.enforcer.PackageCycleCollector;

public class PackageCycleCollectorPerformanceTest {
    private static final int PACKAGE_MATRIX_SIZE = 20;
    private List<JavaPackage> allPackages;

    @Before
    public void setUp() {
        this.allPackages = new ArrayList<JavaPackage>();
    }

    @Test
    public void collectCycles_PerformanceTest() throws Exception {
        this.initializePackages();
        List cycles = new PackageCycleCollector().collectCycles(this.allPackages);
        MatcherAssert.assertThat((Object)cycles, (Matcher)Matchers.is((Matcher)Matchers.empty()));
    }

    private void initializePackages() {
        JavaPackage rootPackage = this.createPackage("root");
        Set<JavaPackage> lastPackageLayer = Collections.singleton(rootPackage);
        for (int row = 0; row < 20; ++row) {
            lastPackageLayer = this.createNextPackageLayer(lastPackageLayer, row);
        }
    }

    private Set<JavaPackage> createNextPackageLayer(Set<JavaPackage> lastPackageLayer, int row) {
        HashSet<JavaPackage> nextPackageLayer = new HashSet<JavaPackage>();
        for (int column = 0; column < 20; ++column) {
            JavaPackage layerPackage = this.createPackage("layer." + row + "." + column);
            nextPackageLayer.add(layerPackage);
            for (JavaPackage javaPackage : lastPackageLayer) {
                javaPackage.dependsUpon(new JavaPackage[]{layerPackage});
            }
        }
        return nextPackageLayer;
    }

    private JavaPackage createPackage(String packageName) {
        JavaPackage javaPackage = new JavaPackage(packageName);
        this.allPackages.add(javaPackage);
        return javaPackage;
    }
}

