/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import util.Clock;
import util.DateAlteringClock;
import util.SystemClock;

public class DateAlteringClockTest {
    private SimpleDateFormat ymdDateFormat = new SimpleDateFormat("yyyy-MM-dd");

    @After
    public void restoreDefaultClock() {
        Clock.restoreDefaultClock();
    }

    @Test
    public void currentClockTimeInMillisShouldBeRebasedToConstructorArg() throws Exception {
        Date startOfTheDecade = this.ymdDateFormat.parse("2010-01-01");
        new DateAlteringClock(startOfTheDecade);
        Assert.assertThat((Object)this.ymdDateFormat.format(new Date(Clock.currentTimeInMillis())), (Matcher)CoreMatchers.is((Object)"2010-01-01"));
    }

    @Test
    public void currentClockTimeInMillisShouldTickOnFromZero() throws Exception {
        Date endOfTheDecade = this.ymdDateFormat.parse("2010-12-31");
        new DateAlteringClock(endOfTheDecade);
        long before = 0L;
        long after = 0L;
        while (after == before) {
            after = Clock.currentTimeInMillis();
            if (before != 0L) continue;
            before = after;
        }
        Assert.assertTrue((Clock.currentTimeInMillis() - endOfTheDecade.getTime() < 1000L ? 1 : 0) != 0);
    }

    @Test
    public void shouldBeAbleToFreezeClockTime() throws Exception {
        SystemClock systemClock = new SystemClock();
        long before = 0L;
        long after = 0L;
        new DateAlteringClock(systemClock.currentClockDate()).freeze();
        long frozenTime = Clock.currentTimeInMillis();
        while (after == before) {
            after = systemClock.currentClockTimeInMillis();
            if (before != 0L) continue;
            before = after;
        }
        Assert.assertThat((Object)Clock.currentTimeInMillis(), (Matcher)CoreMatchers.is((Object)frozenTime));
    }

    @Test
    public void shouldBeAbleToAdvanceClockTimeOnEachQuery() throws Exception {
        Date startOfTheCentury = this.ymdDateFormat.parse("2000-01-01");
        new DateAlteringClock(startOfTheCentury).advanceMillisOnEachQuery();
        Assert.assertThat((Object)Clock.currentTimeInMillis(), (Matcher)CoreMatchers.is((Object)(startOfTheCentury.getTime() + 1L)));
        Assert.assertThat((Object)Clock.currentTimeInMillis(), (Matcher)CoreMatchers.is((Object)(startOfTheCentury.getTime() + 2L)));
        Assert.assertThat((Object)Clock.currentTimeInMillis(), (Matcher)CoreMatchers.is((Object)(startOfTheCentury.getTime() + 3L)));
    }
}

