/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.struct;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.scijava.struct.Member;
import org.scijava.struct.MemberInstance;
import org.scijava.struct.StructInstance;

public interface Struct
extends Iterable<Member<?>> {
    public List<Member<?>> members();

    @Override
    default public Iterator<Member<?>> iterator() {
        return this.members().iterator();
    }

    default public <C> StructInstance<C> createInstance(final C object) {
        final LinkedHashMap memberMap = new LinkedHashMap();
        for (Member<?> member : this.members()) {
            memberMap.put(member.key(), member.createInstance(object));
        }
        return new StructInstance<C>(){

            @Override
            public List<MemberInstance<?>> members() {
                return memberMap.values().stream().collect(Collectors.toList());
            }

            @Override
            public Struct struct() {
                return Struct.this;
            }

            @Override
            public C object() {
                return object;
            }

            @Override
            public MemberInstance<?> member(String key) {
                return (MemberInstance)memberMap.get(key);
            }
        };
    }
}

