/**
 * 
 */
package org.sqlproc.engine;

/**
 * General runtime exception class for the SQL Processor engine.
 * 
 * This exception can be raised in the process of a META SQL query or a statement execution. It's not produced in JDBC
 * or ORM layer, but in the SQL Processor engine itself.
 * 
 * @author <a href="mailto:Vladimir.Hudec@gmail.com">Vladimir Hudec</a>
 */
public class SqlRuntimeException extends RuntimeException {

    /**
     * Creates a new instance of the exception.
     */
    public SqlRuntimeException() {
        super();
    }

    /**
     * Creates a new instance of the exception.
     * 
     * @param message
     *            the error message
     */
    public SqlRuntimeException(String message) {
        super(message);
    }

    /**
     * Creates a new instance of the exception.
     * 
     * @param cause
     *            the error cause
     */
    public SqlRuntimeException(Throwable cause) {
        super(cause);
    }

    /**
     * Creates a new instance of the exception.
     * 
     * @param message
     *            the error message
     * @param cause
     *            the error cause
     */
    public SqlRuntimeException(String message, Throwable cause) {
        super(message, cause);
    }

}
