package org.sqlproc.engine.impl.type;

import java.math.BigDecimal;

import org.hibernate.Hibernate;
import org.hibernate.type.Type;

/**
 * The SQL META Types for BIGDECIMAL.
 * 
 * @author <a href="mailto:Vladimir.Hudec@gmail.com">Vladimir Hudec</a>
 */
public class SqlBigDecimalType extends SqlGenericType {

    /**
     * {@inheritDoc}
     */
    @Override
    public Type getHibernateType() {
        return Hibernate.BIG_DECIMAL;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public Class<?>[] getClassTypes() {
        return new Class[] { BigDecimal.class };
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public String[] getMetaTypes() {
        return new String[] { "BIGDEC", "BIGDECIMAL" };
    }
}
