package org.sqlproc.engine.impl.type;

import java.math.BigInteger;

import org.hibernate.Hibernate;
import org.hibernate.type.Type;

/**
 * The SQL META Types for BIGINTEGER.
 * 
 * @author <a href="mailto:Vladimir.Hudec@gmail.com">Vladimir Hudec</a>
 */
public class SqlBigIntegerType extends SqlGenericType {

    /**
     * {@inheritDoc}
     */
    @Override
    public Type getHibernateType() {
        return Hibernate.BIG_INTEGER;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public Class<?>[] getClassTypes() {
        return new Class[] { BigInteger.class };
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public String[] getMetaTypes() {
        return new String[] { "BIGINT", "BIGINTEGER" };
    }
}
