/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.engine.impl;

import java.util.List;
import java.util.Map;
import org.sqlproc.engine.SqlOrder;
import org.sqlproc.engine.impl.SqlMetaStatement;
import org.sqlproc.engine.impl.type.SqlMetaType;

public class SqlProcessContext {
    SqlMetaStatement.Type sqlStatementType;
    Object dynamicInputValues;
    Object staticInputValues;
    List<SqlOrder> order;
    boolean inSqlSetOrInsert;
    private static final ThreadLocal<Map<String, Object>> currentFeatures = new ThreadLocal();
    private static final ThreadLocal<Map<Class<?>, SqlMetaType>> currentClassToTypeMap = new ThreadLocal();

    SqlProcessContext(SqlMetaStatement.Type sqlStatementType, Object dynamicInputValues, Object staticInputValues, List<SqlOrder> order, Map<String, Object> features, Map<Class<?>, SqlMetaType> classToTypeMap) {
        this.sqlStatementType = sqlStatementType;
        this.dynamicInputValues = dynamicInputValues;
        this.staticInputValues = staticInputValues;
        this.order = order;
        SqlProcessContext.set(features);
        SqlProcessContext.setClassToTypeMap(classToTypeMap);
    }

    static String getFeature(String name) {
        Object o = SqlProcessContext.getFeatures().get(name);
        return o != null && o instanceof String ? (String)o : null;
    }

    static String[] getFeatures(String name) {
        Object o = SqlProcessContext.getFeatures().get(name);
        if (o != null && o instanceof String[]) {
            return (String[])o;
        }
        if (o != null && o instanceof String) {
            return new String[]{(String)o};
        }
        return null;
    }

    static boolean isFeature(String name) {
        Object o = SqlProcessContext.getFeatures().get(name);
        return o != null && o instanceof Boolean && (Boolean)o != false;
    }

    static Integer getFeatureAsInt(String name) {
        Object o = SqlProcessContext.getFeatures().get(name);
        if (o == null) {
            o = SqlProcessContext.getFeatures().get("DEFAULT_" + name);
        }
        if (o == null || !(o instanceof String)) {
            return null;
        }
        try {
            return Integer.parseInt((String)o);
        }
        catch (NumberFormatException nfe) {
            return null;
        }
    }

    int getOrderIndex(int orderId) {
        if (this.order == null || this.order.isEmpty()) {
            return -1;
        }
        for (int i = 0; i < this.order.size(); ++i) {
            SqlOrder sqlOrder = this.order.get(i);
            if (sqlOrder.getOrderId() != orderId) continue;
            return i;
        }
        return -1;
    }

    SqlOrder.Order getOrder(int orderIndex) {
        if (orderIndex < 0 || orderIndex >= this.order.size()) {
            return SqlOrder.Order.NONE;
        }
        return this.order.get(orderIndex).getOrderDirrection();
    }

    static Map<String, Object> getFeatures() {
        Map<String, Object> features = currentFeatures.get();
        if (features == null) {
            throw new RuntimeException("There are no features attached to current thread " + Thread.currentThread().getName());
        }
        return features;
    }

    static void set(Map<String, Object> features) {
        if (currentFeatures.get() != null) {
            return;
        }
        if (features == null) {
            throw new IllegalArgumentException("Argument features can not be null");
        }
        currentFeatures.set(features);
    }

    public static Map<Class<?>, SqlMetaType> getClassToTypeMap() {
        Map<Class<?>, SqlMetaType> classToTypeMap = currentClassToTypeMap.get();
        if (classToTypeMap == null) {
            throw new RuntimeException("There is no map between a Java class type and an internal type attached to current thread " + Thread.currentThread().getName());
        }
        return classToTypeMap;
    }

    static void setClassToTypeMap(Map<Class<?>, SqlMetaType> classToTypeMap) {
        if (currentClassToTypeMap.get() != null) {
            return;
        }
        if (currentClassToTypeMap == null) {
            throw new IllegalArgumentException("Argument classToTypeMap can not be null");
        }
        currentClassToTypeMap.set(classToTypeMap);
    }
}

