/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.engine.impl;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.MethodUtils;
import org.sqlproc.engine.impl.SqlProcessContext;
import org.sqlproc.engine.impl.SqlType;
import org.sqlproc.engine.impl.type.SqlMetaType;

public class SqlUtils {
    static final String SUPPVAL_NOTNULL = "notnull";
    static final String SUPPVAL_ANY = "any";
    static final String SUPPVAL_NULL = "null";
    static final String SUPPVAL_SEQUENCE = "seq";
    static final String SUPPVAL_ID = "id";
    static final String SUPPVAL_GTYPE = "gtype";
    static final String SUPPVAL_TYPE = "type";

    public static Object getEnumToValue(Object obj) {
        if (obj == null) {
            return null;
        }
        for (String methodName : SqlProcessContext.getFeatures("METHODS_ENUM_IN")) {
            try {
                return MethodUtils.invokeMethod((Object)obj, (String)methodName, null);
            }
            catch (NoSuchMethodException e) {
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public static Object getValueToEnum(Class<?> objClass, Object val) {
        if (val == null) {
            return null;
        }
        for (String methodName : SqlProcessContext.getFeatures("METHODS_ENUM_OUT")) {
            try {
                return MethodUtils.invokeStaticMethod(objClass, (String)methodName, (Object)val);
            }
            catch (NoSuchMethodException e) {
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public static boolean isEmpty(Object obj, SqlType sqlType, boolean inSqlSetOrInsert) throws IllegalArgumentException {
        String value;
        String string = value = sqlType != null && sqlType.getValue() != null ? sqlType.getValue().toLowerCase() : null;
        if (SUPPVAL_NOTNULL.equalsIgnoreCase(value) && obj == null) {
            throw new IllegalArgumentException(SUPPVAL_NOTNULL);
        }
        if (inSqlSetOrInsert && obj == null) {
            return true;
        }
        if (SUPPVAL_ANY.equalsIgnoreCase(value)) {
            return true;
        }
        if (SUPPVAL_NULL.equalsIgnoreCase(value)) {
            return obj == null;
        }
        if (obj == null) {
            return false;
        }
        return !(obj instanceof Collection ? ((Collection)obj).isEmpty() : obj.toString().length() <= 0);
    }

    public static boolean isTrue(Object obj, SqlType sqlType) {
        if (sqlType == null || sqlType.getValue() == null) {
            if (obj != null) {
                if (obj instanceof Boolean) {
                    return (Boolean)obj;
                }
                if (obj instanceof String) {
                    String str = ((String)obj).trim();
                    return str.length() > 0 && !str.equalsIgnoreCase("false");
                }
                if (obj instanceof Number) {
                    return ((Number)obj).longValue() > 0L;
                }
                if (obj.getClass().isEnum()) {
                    return true;
                }
                return true;
            }
            return false;
        }
        if (obj == null) {
            return sqlType.getValue().toLowerCase().equalsIgnoreCase(SUPPVAL_NULL);
        }
        if (obj.getClass().isEnum()) {
            if (obj.toString().equals(sqlType.getValue())) {
                return true;
            }
            if (sqlType.getMetaType() == SqlMetaType.ENUM_STRING) {
                return sqlType.getValue().equals(SqlUtils.getEnumToValue(obj));
            }
            if (sqlType.getMetaType() == SqlMetaType.ENUM_INT) {
                return sqlType.getValue().equals(SqlUtils.getEnumToValue(obj).toString());
            }
            return false;
        }
        return obj.toString().equals(sqlType.getValue());
    }

    public static Byte[] toBytes(byte[] barr) {
        if (barr == null) {
            return null;
        }
        Byte[] res = new Byte[barr.length];
        for (int i = 0; i < barr.length; ++i) {
            res[i] = new Byte(barr[i]);
        }
        return res;
    }

    public static byte[] toBytes(Byte[] barr) {
        if (barr == null) {
            return null;
        }
        byte[] res = new byte[barr.length];
        for (int i = 0; i < barr.length; ++i) {
            res[i] = barr[i] != null ? barr[i] : (byte)0;
        }
        return res;
    }

    public static String getFeature(Map<String, Object> features, String name) {
        Object o = features.get(name);
        return o != null && o instanceof String ? (String)o : null;
    }

    public static Boolean isFeature(Map<String, Object> features, String name, Boolean defaultValue) {
        Object o = features.get(name);
        if (o == null || !(o instanceof Boolean)) {
            return defaultValue;
        }
        return (Boolean)o;
    }

    public static boolean isEmpty(StringBuilder sb) {
        if (sb == null) {
            return true;
        }
        String s = sb.toString().trim();
        return s.length() == 0;
    }

    public static boolean[] changedIdentities(Object[] resultValue, Object[] previousResultValue) {
        boolean[] changedIdentities = new boolean[resultValue.length];
        if (previousResultValue == null) {
            for (int i = 0; i < resultValue.length; ++i) {
                changedIdentities[i] = true;
            }
            return changedIdentities;
        }
        for (int i = 0; i < resultValue.length; ++i) {
            Object newIdentity = resultValue[i];
            Object previousIdentity = previousResultValue[i];
            boolean result = false;
            result = previousIdentity != null && newIdentity == null ? true : (previousIdentity == null && newIdentity != null ? true : (previousIdentity == null && newIdentity == null ? false : !previousIdentity.equals(newIdentity)));
            changedIdentities[i] = result;
        }
        return changedIdentities;
    }

    public static boolean changedIdentity(boolean[] changedIdentities, Integer identityIndex) {
        if (changedIdentities == null || identityIndex == null) {
            return true;
        }
        return changedIdentities[identityIndex];
    }

    public static boolean changedIdentity(boolean[] changedIdentities, List<Integer> identityIndexes) {
        if (changedIdentities == null || identityIndexes == null) {
            return true;
        }
        for (Integer identityIndex : identityIndexes) {
            if (!changedIdentities[identityIndex]) continue;
            return true;
        }
        return false;
    }
}

