/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.engine.impl.type;

import java.lang.reflect.Method;
import java.sql.Timestamp;
import java.util.Date;
import org.hibernate.Hibernate;
import org.hibernate.Query;
import org.hibernate.type.Type;
import org.sqlproc.engine.SqlRuntimeException;
import org.sqlproc.engine.impl.BeanUtils;
import org.sqlproc.engine.impl.type.SqlGenericType;

public class SqlTimestampType
extends SqlGenericType {
    @Override
    public Type getHibernateType() {
        return Hibernate.TIMESTAMP;
    }

    @Override
    public Class<?>[] getClassTypes() {
        return new Class[]{Timestamp.class};
    }

    @Override
    public String[] getMetaTypes() {
        return new String[]{"TIMESTAMP", "STAMP"};
    }

    @Override
    public void setResult(Object resultInstance, String attributeName, Object resultValue, boolean ingoreError) throws SqlRuntimeException {
        Method m;
        if (this.logger.isTraceEnabled()) {
            this.logger.trace(">>> setResult " + this.getMetaTypes()[0] + ": resultInstance=" + resultInstance + ", attributeName=" + attributeName + ", resultValue=" + resultValue);
        }
        if ((m = BeanUtils.getSetter(resultInstance, attributeName, Timestamp.class, Date.class)) != null) {
            BeanUtils.simpleInvokeMethod(m, resultInstance, resultValue);
        } else if (ingoreError) {
            this.logger.error("There's no getter for " + attributeName + " in " + resultInstance + ", META type is " + this.getMetaTypes()[0]);
        } else {
            throw new SqlRuntimeException("There's no setter for " + attributeName + " in " + resultInstance + ", META type is " + this.getMetaTypes()[0]);
        }
    }

    @Override
    public void setParameter(Query query, String paramName, Object inputValue, Class<?> inputType, boolean ingoreError) throws SqlRuntimeException {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace(">>> setParameter " + this.getMetaTypes()[0] + ": paramName=" + paramName + ", inputValue=" + inputValue + ", inputType=" + inputType);
        }
        if (inputValue == null) {
            query.setParameter(paramName, inputValue, (Type)Hibernate.TIMESTAMP);
        } else if (inputValue instanceof Timestamp) {
            query.setTimestamp(paramName, (Date)((Timestamp)inputValue));
        } else if (inputValue instanceof Date) {
            query.setTimestamp(paramName, (Date)inputValue);
        } else if (ingoreError) {
            this.logger.error("Incorrect timestamp " + inputValue + " for " + paramName);
        } else {
            throw new SqlRuntimeException("Incorrect timestamp " + inputValue + " for " + paramName);
        }
    }
}

