/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.engine.impl;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sqlproc.engine.SqlQuery;
import org.sqlproc.engine.SqlRuntimeException;
import org.sqlproc.engine.SqlSession;
import org.sqlproc.engine.impl.SqlProcessContext;
import org.sqlproc.engine.impl.SqlType;
import org.sqlproc.engine.type.IdentitySetter;

class SqlInputValue
implements IdentitySetter {
    final Logger logger = LoggerFactory.getLogger(this.getClass());
    private Type valueType;
    private Case caseConversion;
    private Object inputValue;
    Class<?> inputValueType;
    private String likeChar;
    private int minLikeLength;
    private SqlType type;
    private String sequence;
    private String identitySelect;
    private Object identity;

    SqlInputValue(Type valueType, Object inputValue, Class<?> inputValueType, Case caseConversion, SqlType type) {
        this.valueType = valueType;
        this.inputValue = inputValue;
        this.inputValueType = inputValueType;
        this.caseConversion = caseConversion;
        this.type = type;
    }

    SqlInputValue(Type valueType, Object inputValue, Class<?> inputValueType, String sequenceOrIdentitySelect, SqlType type) {
        this.valueType = valueType;
        this.inputValue = inputValue;
        this.inputValueType = inputValueType;
        if (valueType == Type.SEQUENCE_BASED) {
            this.sequence = sequenceOrIdentitySelect;
        } else {
            this.identitySelect = sequenceOrIdentitySelect;
        }
        this.type = type;
    }

    void setQueryParam(SqlSession session, SqlQuery query, String paramName) throws SqlRuntimeException {
        if (this.sequence != null) {
            SqlQuery seqQuery = session.createSqlQuery(this.sequence);
            SqlProcessContext.getTypeFactory().getDefaultType().addScalar(seqQuery, "1", this.inputValueType);
            this.identity = seqQuery.uniqueResult();
            this.type.setParameter(query, paramName, this.identity, this.inputValueType);
        } else if (this.identitySelect != null) {
            SqlProcessContext.getTypeFactory().getIdentityType().setParameter(query, paramName, this, this.inputValueType, SqlProcessContext.isFeature("IGNORE_INPROPER_IN"));
        } else {
            Object o = this.inputValue;
            if (this.inputValue instanceof String) {
                if (this.caseConversion == Case.NONE) {
                    o = this.processLike(this.inputValue);
                } else if (this.caseConversion == Case.LOWER) {
                    o = this.inputValue != null ? this.processLike(this.inputValue).toLowerCase() : (String)null;
                } else if (this.caseConversion == Case.UPPER) {
                    o = this.inputValue != null ? this.processLike(this.inputValue).toUpperCase() : (String)null;
                }
            }
            this.type.setParameter(query, paramName, o, this.inputValueType);
        }
    }

    void setIdentityResult(String paramName) throws SqlRuntimeException {
        this.type.setResult(this.inputValue, paramName, this.identity);
    }

    @Override
    public void setIdentity(Object identity) {
        this.identity = identity;
    }

    @Override
    public String getIdentitySelect() {
        return this.identitySelect;
    }

    void setLike(String likeChar, Integer minLikeLength) {
        this.likeChar = likeChar;
        this.minLikeLength = minLikeLength == null ? 1 : minLikeLength;
    }

    private String processLike(Object val) {
        String param = (String)val;
        if (this.likeChar != null && param != null) {
            param = param.trim();
            int length = param.length();
            boolean startsWith = param.startsWith(this.likeChar);
            boolean endsWith = param.endsWith(this.likeChar);
            if (startsWith && endsWith) {
                return param;
            }
            if (startsWith) {
                if (length >= this.minLikeLength + 1) {
                    return param + this.likeChar;
                }
                return param;
            }
            if (endsWith) {
                if (length >= this.minLikeLength + 1) {
                    return this.likeChar + param;
                }
                return param;
            }
            if (length >= this.minLikeLength) {
                return this.likeChar + param + this.likeChar;
            }
            return param;
        }
        return param;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("SqlInputValue:");
        sb.append(" caseConversion=").append((Object)this.caseConversion);
        sb.append(" value='").append(this.inputValue).append("'");
        return sb.toString();
    }

    static enum Case {
        NONE,
        UPPER,
        LOWER;

    }

    static enum Type {
        PROVIDED,
        SEQUENCE_BASED,
        IDENTITY_SELECT;

    }
}

