/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.engine;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.sqlproc.engine.SqlCrudEngine;
import org.sqlproc.engine.SqlEngineFactory;
import org.sqlproc.engine.SqlEngineLoader;
import org.sqlproc.engine.SqlFilesLoader;
import org.sqlproc.engine.SqlMonitorFactory;
import org.sqlproc.engine.SqlProcedureEngine;
import org.sqlproc.engine.SqlProcessorLoader;
import org.sqlproc.engine.SqlPropertiesLoader;
import org.sqlproc.engine.SqlQueryEngine;
import org.sqlproc.engine.plugin.SqlPluginFactory;
import org.sqlproc.engine.type.SqlInternalType;
import org.sqlproc.engine.type.SqlTypeFactory;

public class SqlSimpleFactory
implements SqlEngineFactory {
    private static final String LINESEP = System.getProperty("line.separator");
    protected static final String DEFAULT_META_PROPS_NAME = "queries.properties";
    @Deprecated
    private List<String> metaPropsNames = new ArrayList<String>();
    private List<String> metaFilesNames = new ArrayList<String>();
    @Deprecated
    private Properties metaProps;
    private StringBuilder metaStatements;
    private SqlTypeFactory typeFactory;
    protected SqlPluginFactory pluginFactory;
    private String filter;
    private SqlMonitorFactory monitorFactory;
    private List<SqlInternalType> customTypes;
    private String[] onlyStatements;
    private boolean jdbc;
    @Deprecated
    private SqlEngineLoader loader;
    private SqlProcessorLoader processorLoader;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void init() {
        if (this.loader == null && this.processorLoader == null) {
            SqlSimpleFactory sqlSimpleFactory = this;
            synchronized (sqlSimpleFactory) {
                if (this.loader == null && this.processorLoader == null) {
                    if (this.metaStatements != null || this.metaFilesNames != null && !this.metaFilesNames.isEmpty()) {
                        if (this.metaStatements == null) {
                            this.metaStatements = SqlFilesLoader.getStatements(this.getClass(), this.metaFilesNames.toArray(new String[0]));
                        }
                        if (this.jdbc) {
                            this.metaStatements.append(LINESEP).append("JDBC(BOPT)=true;");
                        }
                        this.processorLoader = new SqlProcessorLoader(this.metaStatements, this.typeFactory, this.pluginFactory, this.filter, this.monitorFactory, this.customTypes, this.onlyStatements);
                    } else {
                        Properties metaProperties = this.metaProps;
                        if (metaProperties == null) {
                            SqlPropertiesLoader loader = this.metaPropsNames != null && !this.metaPropsNames.isEmpty() ? new SqlPropertiesLoader(this.metaPropsNames, this.getClass()) : new SqlPropertiesLoader(DEFAULT_META_PROPS_NAME, this.getClass());
                            metaProperties = loader.getProperties();
                        }
                        if (this.jdbc) {
                            metaProperties.setProperty("SET_JDBC", "true");
                        }
                        this.loader = new SqlEngineLoader(metaProperties, this.typeFactory, this.pluginFactory, this.filter, this.monitorFactory, this.customTypes, this.onlyStatements);
                        this.metaProps = metaProperties;
                    }
                }
            }
        }
    }

    @Override
    public SqlQueryEngine getQueryEngine(String name) {
        if (this.getLoader() == null) {
            this.init();
        }
        return this.getLoader().getQueryEngine(name);
    }

    @Override
    public SqlCrudEngine getCrudEngine(String name) {
        if (this.getLoader() == null) {
            this.init();
        }
        return this.getLoader().getCrudEngine(name);
    }

    @Override
    public SqlProcedureEngine getProcedureEngine(String name) {
        if (this.getLoader() == null) {
            this.init();
        }
        return this.getLoader().getProcedureEngine(name);
    }

    public List<String> getMetaPropsNames() {
        return this.metaPropsNames;
    }

    public void setMetaPropsNames(List<String> propsNames) {
        this.metaPropsNames = propsNames;
    }

    public void setMetaPropsNames(String ... propsNames) {
        this.metaPropsNames = new ArrayList<String>();
        Collections.addAll(this.metaPropsNames, propsNames);
    }

    public List<String> getMetaFilesNames() {
        return this.metaFilesNames;
    }

    public void setMetaFilesNames(List<String> metaFilesNames) {
        this.metaFilesNames = metaFilesNames;
    }

    public void setMetaFilesNames(String ... metaFilesNames) {
        this.metaFilesNames = new ArrayList<String>();
        Collections.addAll(this.metaFilesNames, metaFilesNames);
    }

    public Properties getMetaProps() {
        return this.metaProps;
    }

    public void setMetaProps(Properties props) {
        this.metaProps = props;
    }

    public StringBuilder getMetaStatements() {
        return this.metaStatements;
    }

    public void setMetaStatements(StringBuilder metaStatements) {
        this.metaStatements = metaStatements;
    }

    public SqlTypeFactory getTypeFactory() {
        return this.typeFactory;
    }

    public void setTypeFactory(SqlTypeFactory typeFactory) {
        this.typeFactory = typeFactory;
    }

    public SqlPluginFactory getPluginFactory() {
        return this.pluginFactory;
    }

    public void setPluginFactory(SqlPluginFactory pluginFactory) {
        this.pluginFactory = pluginFactory;
    }

    public String getFilter() {
        return this.filter;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public SqlMonitorFactory getMonitorFactory() {
        return this.monitorFactory;
    }

    public void setMonitorFactory(SqlMonitorFactory monitorFactory) {
        this.monitorFactory = monitorFactory;
    }

    public List<SqlInternalType> getCustomTypes() {
        return this.customTypes;
    }

    public void setCustomTypes(List<SqlInternalType> customTypes) {
        this.customTypes = customTypes;
    }

    public void setCustomTypes(SqlInternalType ... customTypes) {
        this.customTypes = new ArrayList<SqlInternalType>();
        Collections.addAll(this.customTypes, customTypes);
    }

    public void addCustomType(SqlInternalType customType) {
        if (this.customTypes == null) {
            this.customTypes = new ArrayList<SqlInternalType>();
        }
        this.customTypes.add(customType);
    }

    public String[] getOnlyStatements() {
        return this.onlyStatements;
    }

    public void setOnlyStatements(String[] selectQueries) {
        this.onlyStatements = selectQueries != null ? Arrays.copyOf(selectQueries, selectQueries.length) : null;
    }

    public boolean isJdbc() {
        return this.jdbc;
    }

    public void setJdbc(boolean jdbc) {
        this.jdbc = jdbc;
    }

    public SqlEngineFactory getLoader() {
        if (this.loader != null) {
            return this.loader;
        }
        return this.processorLoader;
    }
}

