/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.engine.jmx;

import java.util.Collection;
import org.sqlproc.engine.SqlCrudEngine;
import org.sqlproc.engine.SqlEngineException;
import org.sqlproc.engine.SqlEngineFactory;
import org.sqlproc.engine.SqlProcedureEngine;
import org.sqlproc.engine.SqlQueryEngine;
import org.sqlproc.engine.jmx.SqlSimpleFactoryMXBean;

public class SqlSimpleFactoryJmx
implements SqlSimpleFactoryMXBean {
    private SqlEngineFactory sqlEngineFactory;
    public static final String OK = "OK";

    @Override
    public String initQueryEngines(String names) {
        StringBuilder errors = new StringBuilder();
        if ("*".equals(names)) {
            for (String name : this.sqlEngineFactory.getNames()) {
                try {
                    this.sqlEngineFactory.getCheckedQueryEngine(name);
                }
                catch (SqlEngineException ex) {
                    errors.append(ex.getMessage()).append("\n");
                }
            }
        } else {
            for (String name : names.split(",")) {
                try {
                    this.sqlEngineFactory.getCheckedQueryEngine(name);
                }
                catch (SqlEngineException ex) {
                    errors.append(ex.getMessage()).append("\n");
                }
            }
        }
        return errors.length() == 0 ? OK : errors.toString();
    }

    @Override
    public String initCrudEngines(String names) {
        StringBuilder errors = new StringBuilder();
        if ("*".equals(names)) {
            for (String name : this.sqlEngineFactory.getNames()) {
                try {
                    this.sqlEngineFactory.getCheckedCrudEngine(name);
                }
                catch (SqlEngineException ex) {
                    errors.append(ex.getMessage()).append("\n");
                }
            }
        } else {
            for (String name : names.split(",")) {
                try {
                    this.sqlEngineFactory.getCheckedCrudEngine(name);
                }
                catch (SqlEngineException ex) {
                    errors.append(ex.getMessage()).append("\n");
                }
            }
        }
        return errors.length() == 0 ? OK : errors.toString();
    }

    @Override
    public String initProcedureEngines(String names) {
        StringBuilder errors = new StringBuilder();
        if ("*".equals(names)) {
            for (String name : this.sqlEngineFactory.getNames()) {
                try {
                    this.sqlEngineFactory.getCheckedProcedureEngine(name);
                }
                catch (SqlEngineException ex) {
                    errors.append(ex.getMessage()).append("\n");
                }
            }
        } else {
            for (String name : names.split(",")) {
                try {
                    this.sqlEngineFactory.getCheckedProcedureEngine(name);
                }
                catch (SqlEngineException ex) {
                    errors.append(ex.getMessage()).append("\n");
                }
            }
        }
        return errors.length() == 0 ? OK : errors.toString();
    }

    @Override
    public String resetQueryEngines(String names) {
        StringBuilder errors = new StringBuilder();
        for (String name : names.split(",")) {
            try {
                this.sqlEngineFactory.getCheckedStaticQueryEngine(name);
            }
            catch (SqlEngineException ex) {
                errors.append(ex.getMessage()).append("\n");
            }
        }
        return errors.length() == 0 ? OK : errors.toString();
    }

    @Override
    public String resetCrudEngines(String names) {
        StringBuilder errors = new StringBuilder();
        for (String name : names.split(",")) {
            try {
                this.sqlEngineFactory.getCheckedStaticCrudEngine(name);
            }
            catch (SqlEngineException ex) {
                errors.append(ex.getMessage()).append("\n");
            }
        }
        return errors.length() == 0 ? OK : errors.toString();
    }

    @Override
    public String resetProcedureEngines(String names) {
        StringBuilder errors = new StringBuilder();
        for (String name : names.split(",")) {
            try {
                this.sqlEngineFactory.getCheckedStaticProcedureEngine(name);
            }
            catch (SqlEngineException ex) {
                errors.append(ex.getMessage()).append("\n");
            }
        }
        return errors.length() == 0 ? OK : errors.toString();
    }

    @Override
    public String newQueryEngine(String name, String sqlStatement) throws SqlEngineException {
        try {
            this.sqlEngineFactory.getDynamicQueryEngine(name, sqlStatement);
        }
        catch (SqlEngineException ex) {
            return ex.getMessage();
        }
        return OK;
    }

    @Override
    public String newCrudEngine(String name, String sqlStatement) {
        try {
            this.sqlEngineFactory.getDynamicCrudEngine(name, sqlStatement);
        }
        catch (SqlEngineException ex) {
            return ex.getMessage();
        }
        return OK;
    }

    @Override
    public String newProcedureEngine(String name, String sqlStatement) {
        try {
            this.sqlEngineFactory.getDynamicProcedureEngine(name, sqlStatement);
        }
        catch (SqlEngineException ex) {
            return ex.getMessage();
        }
        return OK;
    }

    @Override
    public String getNames() {
        return this.collectionToString(this.sqlEngineFactory.getNames());
    }

    @Override
    public String getDynamicNames() {
        return this.collectionToString(this.sqlEngineFactory.getDynamicNames());
    }

    private String collectionToString(Collection<String> collection) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String name : collection) {
            if (first) {
                first = false;
            } else {
                sb.append(",");
            }
            sb.append(name);
        }
        return sb.toString();
    }

    @Override
    public boolean isLazyInit() {
        return this.sqlEngineFactory.isLazyInit();
    }

    public void setSqlEngineFactory(SqlEngineFactory sqlEngineFactory) {
        this.sqlEngineFactory = sqlEngineFactory;
    }

    @Override
    public String getQueryEngineProcessingCache(String name) {
        StringBuilder errors = new StringBuilder();
        try {
            SqlQueryEngine engine = this.sqlEngineFactory.getCheckedQueryEngine(name);
            return this.collectionToString(engine.getProcessingCache().keySet());
        }
        catch (SqlEngineException ex) {
            errors.append(ex.getMessage()).append("\n");
            return errors.toString();
        }
    }

    @Override
    public String getCrudEngineProcessingCache(String name) {
        StringBuilder errors = new StringBuilder();
        try {
            SqlCrudEngine engine = this.sqlEngineFactory.getCheckedCrudEngine(name);
            return this.collectionToString(engine.getProcessingCache().keySet());
        }
        catch (SqlEngineException ex) {
            errors.append(ex.getMessage()).append("\n");
            return errors.toString();
        }
    }

    @Override
    public String getProcedureEngineProcessingCache(String name) {
        StringBuilder errors = new StringBuilder();
        try {
            SqlProcedureEngine engine = this.sqlEngineFactory.getCheckedProcedureEngine(name);
            return this.collectionToString(engine.getProcessingCache().keySet());
        }
        catch (SqlEngineException ex) {
            errors.append(ex.getMessage()).append("\n");
            return errors.toString();
        }
    }

    @Override
    public String resetQueryEngineProcessingCache(String name, String names) {
        StringBuilder errors = new StringBuilder();
        try {
            SqlQueryEngine engine = this.sqlEngineFactory.getCheckedQueryEngine(name);
            for (String name0 : names.split(",")) {
                engine.getProcessingCache().remove(name0);
            }
        }
        catch (SqlEngineException ex) {
            errors.append(ex.getMessage()).append("\n");
        }
        return errors.length() == 0 ? OK : errors.toString();
    }

    @Override
    public String resetCrudEngineProcessingCache(String name, String names) {
        StringBuilder errors = new StringBuilder();
        try {
            SqlCrudEngine engine = this.sqlEngineFactory.getCheckedCrudEngine(name);
            for (String name0 : names.split(",")) {
                engine.getProcessingCache().remove(name0);
            }
        }
        catch (SqlEngineException ex) {
            errors.append(ex.getMessage()).append("\n");
        }
        return errors.length() == 0 ? OK : errors.toString();
    }

    @Override
    public String resetProcedureEngineProcessingCache(String name, String names) {
        StringBuilder errors = new StringBuilder();
        try {
            SqlProcedureEngine engine = this.sqlEngineFactory.getCheckedProcedureEngine(name);
            for (String name0 : names.split(",")) {
                engine.getProcessingCache().remove(name0);
            }
        }
        catch (SqlEngineException ex) {
            errors.append(ex.getMessage()).append("\n");
        }
        return errors.length() == 0 ? OK : errors.toString();
    }
}

