// $ANTLR 3.5.2 org/sqlproc/engine/impl/SqlProcessor.g 2016-10-30 07:04:12
 
package org.sqlproc.engine.impl;

import java.util.Map;
import java.util.HashMap;
import java.util.Set;
import org.sqlproc.engine.type.SqlTypeFactory;
import org.sqlproc.engine.type.SqlMetaType;


import org.antlr.runtime.*;
import java.util.Stack;
import java.util.List;
import java.util.ArrayList;

@SuppressWarnings("all")
public class SqlProcessorParser extends Parser {
	public static final String[] tokenNames = new String[] {
		"<invalid>", "<EOR>", "<DOWN>", "<UP>", "AND", "AT", "BAND", "BOR", "CARET", 
		"COLON", "COMMA", "DIGIT", "DOT", "EQUALS", "ESC_AT", "ESC_BOR", "ESC_CHAR", 
		"ESC_COLON", "ESC_DOT", "ESC_HASH", "ESC_LBRACE", "ESC_PERCENT", "ESC_RBRACE", 
		"ESC_SEMICOLON", "ESC_SLASH", "ESC_STRING", "HASH", "IDENT", "IDENT_DOT", 
		"LBRACE", "LESS_THAN", "LPAREN", "MAPPING", "MINUS", "ML_COMMENT", "MORE_THAN", 
		"NOT", "NUMBER", "OPTION", "OR", "PERCENT", "PLUS", "QUESTI", "RBRACE", 
		"REST", "RPAREN", "SEMICOLON", "SL_COMMENT", "STATEMENT", "STRING", "WS"
	};
	public static final int EOF=-1;
	public static final int AND=4;
	public static final int AT=5;
	public static final int BAND=6;
	public static final int BOR=7;
	public static final int CARET=8;
	public static final int COLON=9;
	public static final int COMMA=10;
	public static final int DIGIT=11;
	public static final int DOT=12;
	public static final int EQUALS=13;
	public static final int ESC_AT=14;
	public static final int ESC_BOR=15;
	public static final int ESC_CHAR=16;
	public static final int ESC_COLON=17;
	public static final int ESC_DOT=18;
	public static final int ESC_HASH=19;
	public static final int ESC_LBRACE=20;
	public static final int ESC_PERCENT=21;
	public static final int ESC_RBRACE=22;
	public static final int ESC_SEMICOLON=23;
	public static final int ESC_SLASH=24;
	public static final int ESC_STRING=25;
	public static final int HASH=26;
	public static final int IDENT=27;
	public static final int IDENT_DOT=28;
	public static final int LBRACE=29;
	public static final int LESS_THAN=30;
	public static final int LPAREN=31;
	public static final int MAPPING=32;
	public static final int MINUS=33;
	public static final int ML_COMMENT=34;
	public static final int MORE_THAN=35;
	public static final int NOT=36;
	public static final int NUMBER=37;
	public static final int OPTION=38;
	public static final int OR=39;
	public static final int PERCENT=40;
	public static final int PLUS=41;
	public static final int QUESTI=42;
	public static final int RBRACE=43;
	public static final int REST=44;
	public static final int RPAREN=45;
	public static final int SEMICOLON=46;
	public static final int SL_COMMENT=47;
	public static final int STATEMENT=48;
	public static final int STRING=49;
	public static final int WS=50;

	// delegates
	public Parser[] getDelegates() {
		return new Parser[] {};
	}

	// delegators


	public SqlProcessorParser(TokenStream input) {
		this(input, new RecognizerSharedState());
	}
	public SqlProcessorParser(TokenStream input, RecognizerSharedState state) {
		super(input, state);
	}

	@Override public String[] getTokenNames() { return SqlProcessorParser.tokenNames; }
	@Override public String getGrammarFileName() { return "org/sqlproc/engine/impl/SqlProcessor.g"; }


	  private Token getLastToken() {
	    return input.LT(-1);
	  }

	  private Stack artifactName = new Stack();
	  private Stack partialErrors = new Stack();
	  private List<ErrorMsg> errors = new ArrayList<ErrorMsg>();
	  
	  public List<ErrorMsg> getErrors() {
	    return errors;
	  }

	  @Override
	  public void reportError(RecognitionException e) {
	    String msg = super.getErrorMessage(e,tokenNames);
	    if ( artifactName.size()>0 ) {
	      String name = (String)artifactName.peek();
	      partialErrors.push(ParserUtils.create(name,msg,e,tokenNames));
	    }
	    else {
	      errors.add(ParserUtils.create(null,msg,e,tokenNames));
	    }
	  }
	  
	  String getText(Token token) {
	    if (token == null)
	      return null;
	    return token.getText();
	  }
	  
	  void add(StringBuilder text) {
	    int type = getLastToken().getType();
	    if (type == ESC_CHAR) {
	      text.append(getLastToken().getText().substring(1));
	    } 
	    else if (type == WS) {
	      String s = getLastToken().getText();
	      for (int i = 0, l = s.length(); i < l; i++) {
	        char c = s.charAt(i);
	        if (c == '\n' || c == '\r')
	          continue;
	        text.append(c);
	      }
	    } 
	    else {
	      text.append(getLastToken().getText());
	    }
	  }
	  
	  void addText(Object target, StringBuilder text) {
	    ParserUtils.addText(target, text);
	  }
	  
	  void addColumn(Object target, SqlMappingItem col, StringBuilder text) {
	    ParserUtils.addColumn(target, col, text);
	  }
	  
	  SqlMappingItem newColumn(String col) {
	    return ParserUtils.newColumn(col);
	  }
	  
	  void addColumnAttr(SqlMappingItem item, Token col) {
	    ParserUtils.addColumnAttr(item, col.getText());
	  }
	  
	  void addDatabaseColumn(Object target, SqlDatabaseColumn dbcol, StringBuilder text) {
	    ParserUtils.addDatabaseColumn(target, dbcol, text);
	  }
	  
	  SqlDatabaseColumn newDatabaseColumn(Token col) {
	    return ParserUtils.newDatabaseColumn(col.getText());
	  }
	  
	  void addDatabaseTable(Object target, SqlDatabaseTable dbtab, StringBuilder text) {
	    ParserUtils.addDatabaseTable(target, dbtab, text);
	  }
	  
	  SqlDatabaseTable newDatabaseTable(Token col) {
	    return ParserUtils.newDatabaseTable(col.getText());
	  }

	 SqlMetaOperator lastOperator = null;
	  
	  void addIdent(Object target, SqlMetaIdent ident, StringBuilder text) {
	    ParserUtils.addIdent(target, ident, text, lastOperator);
	    lastOperator = null;
	  }
	  
	  SqlMetaIdent newIdent(Token ident, Token modeIdent, Token caseIdent) {
	    return ParserUtils.newIdent(ident.getText(), getText(modeIdent), getText(caseIdent));
	  }

	  void addConstant(Object target, SqlMetaConst cnst, StringBuilder text) {
	    ParserUtils.addConstant(target, cnst, text, lastOperator);
	    lastOperator = null;
	  }
	  
	  SqlMetaConst newConstant(Token cnst, Token caseConversion) {
	    return ParserUtils.newConstant(cnst.getText(), getText(caseConversion));
	  }
	  
	  void addOperator(Object target, SqlMetaOperator metaOper, StringBuilder text) {
	    ParserUtils.addOperator(target, metaOper, text);
	    lastOperator = metaOper;
	  }

	  SqlMetaOperator newIdentOperator(Token ident) {
	    return ParserUtils.newOperator(true, ident.getText());
	  }
	  
	  SqlMetaOperator newConstOperator(Token cnst) {
	    return ParserUtils.newOperator(false, cnst.getText());
	  }
	  
	  void addOperator(SqlMetaLogExpr expr, boolean isAnd) {
	    if (isAnd)
	      expr.addElement(new SqlMetaLogOperator(SqlMetaLogOperator.Type.AND));
	    else
	      expr.addElement(new SqlMetaLogOperator(SqlMetaLogOperator.Type.OR));
	  }

	  void addModifier(SqlTypeFactory typeFactory, SqlMappingItem item, String modifier) {
	    ParserUtils.addModifier(item, typeFactory, modifier);
	  }

	  void addModifier(SqlTypeFactory typeFactory, SqlMappingItem item, String modifier, String attrName) {
	    ParserUtils.addModifier(item, typeFactory, modifier, attrName);
	  }

	  void addModifier(SqlTypeFactory typeFactory, SqlMetaIdent item, String modifier, Token not) {
	    if (not != null)
	      modifier = "not" + modifier;
	    ParserUtils.addModifier(item, typeFactory, modifier);
	  }

	  void addModifier(SqlTypeFactory typeFactory, SqlMetaConst item, String modifier, Token not) {
	    if (not != null)
	      modifier = "not" + modifier;
	    ParserUtils.addModifier(item, typeFactory, modifier);
	  }
	  
	  boolean doSkip(Set<String> onlyStatements, String name) {
	    if (onlyStatements == null || onlyStatements.isEmpty())
	      return false;
	    return !onlyStatements.contains(name);
	  }
	  
	  List<ErrorMsg> getPartialErrors() {
	    if (partialErrors.size()==0)
	      return null;
	    List<ErrorMsg> errorsList = new ArrayList<ErrorMsg>();
	    while ( partialErrors.size()>0 ) {
	      ErrorMsg errorMsg = (ErrorMsg) partialErrors.pop(); 
	      errorsList.add(errorMsg);
	    }
	    return errorsList;
	  }
	  
	  boolean add(SqlProcessor processor, String type, String name, SqlMetaStatement statement, List<String> activeFilters, String... filters) {
	    List<ErrorMsg> errorsList = getPartialErrors();
	    processor.addMetaStatement(type, name, null, statement, errorsList, activeFilters, filters);
	    return errorsList == null;
	  }
	  
	  boolean add(SqlProcessor processor, String type, String name, SqlMappingRule mapping, List<String> activeFilters, String... filters) {
	    List<ErrorMsg> errorsList = getPartialErrors();
	    processor.addMappingRule(type, name, null, mapping, errorsList, activeFilters, filters);
	    return errorsList == null;
	  }
	  
	  boolean add(SqlProcessor processor, String type, String name, String feature, List<String> activeFilters, String... filters) {
	    List<ErrorMsg> errorsList = getPartialErrors();
	    processor.addFeature(type, name, feature, errorsList, activeFilters, filters);
	    return errorsList == null;
	  }
	  
	  SqlMetaIfItem newSqlMetaIfItem() {
	    lastOperator = null;
	    return new SqlMetaIfItem();
	  }
	  
	  SqlMetaStatement newSqlMetaStatement() {
	    lastOperator = null;
	    return new SqlMetaStatement();
	  }



	// $ANTLR start "parse"
	// org/sqlproc/engine/impl/SqlProcessor.g:223:1: parse : parse2[org.sqlproc.engine.jdbc.type.JdbcTypeFactory.getInstance(), new java.util.HashMap<String, Object>(), new java.util.HashSet<String>(), new String[] {}] ;
	public final void parse() throws RecognitionException {
		try {
			// org/sqlproc/engine/impl/SqlProcessor.g:223:7: ( parse2[org.sqlproc.engine.jdbc.type.JdbcTypeFactory.getInstance(), new java.util.HashMap<String, Object>(), new java.util.HashSet<String>(), new String[] {}] )
			// org/sqlproc/engine/impl/SqlProcessor.g:224:9: parse2[org.sqlproc.engine.jdbc.type.JdbcTypeFactory.getInstance(), new java.util.HashMap<String, Object>(), new java.util.HashSet<String>(), new String[] {}]
			{
			pushFollow(FOLLOW_parse2_in_parse52);
			parse2(org.sqlproc.engine.jdbc.type.JdbcTypeFactory.getInstance(), new java.util.HashMap<String, Object>(), new java.util.HashSet<String>(), new String[] {});
			state._fsp--;

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "parse"



	// $ANTLR start "parse2"
	// org/sqlproc/engine/impl/SqlProcessor.g:227:1: parse2[SqlTypeFactory _typeFactory, Map<String, Object> defaultFeatures, Set<String> onlyStatements, String[] filters] returns [SqlProcessor processor] : ( WS )* ( (name= IDENT LPAREN type= STATEMENT ( COMMA filter= IDENT )* RPAREN EQUALS metaStatement= meta[$name.text, _typeFactory, skip] SEMICOLON ( WS )* ) | (name= IDENT LPAREN type= MAPPING ( COMMA filter= IDENT )* RPAREN EQUALS mappingRule= mapping[$name.text, _typeFactory, skip] SEMICOLON ( WS )* ) | (name= IDENT LPAREN type= OPTION ( COMMA filter= IDENT )* RPAREN EQUALS text= option[$name.text] SEMICOLON ( WS )* ) )+ EOF ;
	public final SqlProcessor parse2(SqlTypeFactory _typeFactory, Map<String, Object> defaultFeatures, Set<String> onlyStatements, String[] filters) throws RecognitionException {
		SqlProcessor processor = null;


		Token name=null;
		Token type=null;
		Token filter=null;
		SqlMetaStatement metaStatement =null;
		SqlMappingRule mappingRule =null;
		StringBuilder text =null;

		processor = new SqlProcessor(defaultFeatures, onlyStatements); boolean skip; List<String> activeFilters;
		try {
			// org/sqlproc/engine/impl/SqlProcessor.g:229:9: ( ( WS )* ( (name= IDENT LPAREN type= STATEMENT ( COMMA filter= IDENT )* RPAREN EQUALS metaStatement= meta[$name.text, _typeFactory, skip] SEMICOLON ( WS )* ) | (name= IDENT LPAREN type= MAPPING ( COMMA filter= IDENT )* RPAREN EQUALS mappingRule= mapping[$name.text, _typeFactory, skip] SEMICOLON ( WS )* ) | (name= IDENT LPAREN type= OPTION ( COMMA filter= IDENT )* RPAREN EQUALS text= option[$name.text] SEMICOLON ( WS )* ) )+ EOF )
			// org/sqlproc/engine/impl/SqlProcessor.g:230:9: ( WS )* ( (name= IDENT LPAREN type= STATEMENT ( COMMA filter= IDENT )* RPAREN EQUALS metaStatement= meta[$name.text, _typeFactory, skip] SEMICOLON ( WS )* ) | (name= IDENT LPAREN type= MAPPING ( COMMA filter= IDENT )* RPAREN EQUALS mappingRule= mapping[$name.text, _typeFactory, skip] SEMICOLON ( WS )* ) | (name= IDENT LPAREN type= OPTION ( COMMA filter= IDENT )* RPAREN EQUALS text= option[$name.text] SEMICOLON ( WS )* ) )+ EOF
			{
			// org/sqlproc/engine/impl/SqlProcessor.g:230:9: ( WS )*
			loop1:
			while (true) {
				int alt1=2;
				int LA1_0 = input.LA(1);
				if ( (LA1_0==WS) ) {
					alt1=1;
				}

				switch (alt1) {
				case 1 :
					// org/sqlproc/engine/impl/SqlProcessor.g:230:9: WS
					{
					match(input,WS,FOLLOW_WS_in_parse293); 
					}
					break;

				default :
					break loop1;
				}
			}

			// org/sqlproc/engine/impl/SqlProcessor.g:230:13: ( (name= IDENT LPAREN type= STATEMENT ( COMMA filter= IDENT )* RPAREN EQUALS metaStatement= meta[$name.text, _typeFactory, skip] SEMICOLON ( WS )* ) | (name= IDENT LPAREN type= MAPPING ( COMMA filter= IDENT )* RPAREN EQUALS mappingRule= mapping[$name.text, _typeFactory, skip] SEMICOLON ( WS )* ) | (name= IDENT LPAREN type= OPTION ( COMMA filter= IDENT )* RPAREN EQUALS text= option[$name.text] SEMICOLON ( WS )* ) )+
			int cnt8=0;
			loop8:
			while (true) {
				int alt8=4;
				int LA8_0 = input.LA(1);
				if ( (LA8_0==IDENT) ) {
					int LA8_2 = input.LA(2);
					if ( (LA8_2==LPAREN) ) {
						switch ( input.LA(3) ) {
						case OPTION:
							{
							alt8=3;
							}
							break;
						case STATEMENT:
							{
							alt8=1;
							}
							break;
						case MAPPING:
							{
							alt8=2;
							}
							break;
						}
					}

				}

				switch (alt8) {
				case 1 :
					// org/sqlproc/engine/impl/SqlProcessor.g:231:10: (name= IDENT LPAREN type= STATEMENT ( COMMA filter= IDENT )* RPAREN EQUALS metaStatement= meta[$name.text, _typeFactory, skip] SEMICOLON ( WS )* )
					{
					// org/sqlproc/engine/impl/SqlProcessor.g:231:10: (name= IDENT LPAREN type= STATEMENT ( COMMA filter= IDENT )* RPAREN EQUALS metaStatement= meta[$name.text, _typeFactory, skip] SEMICOLON ( WS )* )
					// org/sqlproc/engine/impl/SqlProcessor.g:231:11: name= IDENT LPAREN type= STATEMENT ( COMMA filter= IDENT )* RPAREN EQUALS metaStatement= meta[$name.text, _typeFactory, skip] SEMICOLON ( WS )*
					{
					name=(Token)match(input,IDENT,FOLLOW_IDENT_in_parse2110); 
					skip=doSkip(onlyStatements,(name!=null?name.getText():null));
					match(input,LPAREN,FOLLOW_LPAREN_in_parse2114); 
					type=(Token)match(input,STATEMENT,FOLLOW_STATEMENT_in_parse2118); 
					activeFilters = new ArrayList<String>();
					// org/sqlproc/engine/impl/SqlProcessor.g:231:129: ( COMMA filter= IDENT )*
					loop2:
					while (true) {
						int alt2=2;
						int LA2_0 = input.LA(1);
						if ( (LA2_0==COMMA) ) {
							alt2=1;
						}

						switch (alt2) {
						case 1 :
							// org/sqlproc/engine/impl/SqlProcessor.g:231:130: COMMA filter= IDENT
							{
							match(input,COMMA,FOLLOW_COMMA_in_parse2123); 
							filter=(Token)match(input,IDENT,FOLLOW_IDENT_in_parse2127); 
							activeFilters.add((filter!=null?filter.getText():null));
							}
							break;

						default :
							break loop2;
						}
					}

					match(input,RPAREN,FOLLOW_RPAREN_in_parse2133); 
					match(input,EQUALS,FOLLOW_EQUALS_in_parse2135); 
					pushFollow(FOLLOW_meta_in_parse2151);
					metaStatement=meta((name!=null?name.getText():null), _typeFactory, skip);
					state._fsp--;

					add(processor, (type!=null?type.getText():null), (name!=null?name.getText():null), metaStatement, activeFilters, filters);
					match(input,SEMICOLON,FOLLOW_SEMICOLON_in_parse2156); 
					// org/sqlproc/engine/impl/SqlProcessor.g:232:154: ( WS )*
					loop3:
					while (true) {
						int alt3=2;
						int LA3_0 = input.LA(1);
						if ( (LA3_0==WS) ) {
							alt3=1;
						}

						switch (alt3) {
						case 1 :
							// org/sqlproc/engine/impl/SqlProcessor.g:232:154: WS
							{
							match(input,WS,FOLLOW_WS_in_parse2158); 
							}
							break;

						default :
							break loop3;
						}
					}

					}

					}
					break;
				case 2 :
					// org/sqlproc/engine/impl/SqlProcessor.g:233:12: (name= IDENT LPAREN type= MAPPING ( COMMA filter= IDENT )* RPAREN EQUALS mappingRule= mapping[$name.text, _typeFactory, skip] SEMICOLON ( WS )* )
					{
					// org/sqlproc/engine/impl/SqlProcessor.g:233:12: (name= IDENT LPAREN type= MAPPING ( COMMA filter= IDENT )* RPAREN EQUALS mappingRule= mapping[$name.text, _typeFactory, skip] SEMICOLON ( WS )* )
					// org/sqlproc/engine/impl/SqlProcessor.g:233:13: name= IDENT LPAREN type= MAPPING ( COMMA filter= IDENT )* RPAREN EQUALS mappingRule= mapping[$name.text, _typeFactory, skip] SEMICOLON ( WS )*
					{
					name=(Token)match(input,IDENT,FOLLOW_IDENT_in_parse2176); 
					skip=doSkip(onlyStatements,(name!=null?name.getText():null));
					match(input,LPAREN,FOLLOW_LPAREN_in_parse2180); 
					type=(Token)match(input,MAPPING,FOLLOW_MAPPING_in_parse2184); 
					activeFilters = new ArrayList<String>();
					// org/sqlproc/engine/impl/SqlProcessor.g:233:129: ( COMMA filter= IDENT )*
					loop4:
					while (true) {
						int alt4=2;
						int LA4_0 = input.LA(1);
						if ( (LA4_0==COMMA) ) {
							alt4=1;
						}

						switch (alt4) {
						case 1 :
							// org/sqlproc/engine/impl/SqlProcessor.g:233:130: COMMA filter= IDENT
							{
							match(input,COMMA,FOLLOW_COMMA_in_parse2189); 
							filter=(Token)match(input,IDENT,FOLLOW_IDENT_in_parse2193); 
							activeFilters.add((filter!=null?filter.getText():null));
							}
							break;

						default :
							break loop4;
						}
					}

					match(input,RPAREN,FOLLOW_RPAREN_in_parse2199); 
					match(input,EQUALS,FOLLOW_EQUALS_in_parse2201); 
					pushFollow(FOLLOW_mapping_in_parse2217);
					mappingRule=mapping((name!=null?name.getText():null), _typeFactory, skip);
					state._fsp--;

					add(processor, (type!=null?type.getText():null), (name!=null?name.getText():null), mappingRule, activeFilters, filters);
					match(input,SEMICOLON,FOLLOW_SEMICOLON_in_parse2222); 
					// org/sqlproc/engine/impl/SqlProcessor.g:234:153: ( WS )*
					loop5:
					while (true) {
						int alt5=2;
						int LA5_0 = input.LA(1);
						if ( (LA5_0==WS) ) {
							alt5=1;
						}

						switch (alt5) {
						case 1 :
							// org/sqlproc/engine/impl/SqlProcessor.g:234:153: WS
							{
							match(input,WS,FOLLOW_WS_in_parse2224); 
							}
							break;

						default :
							break loop5;
						}
					}

					}

					}
					break;
				case 3 :
					// org/sqlproc/engine/impl/SqlProcessor.g:235:12: (name= IDENT LPAREN type= OPTION ( COMMA filter= IDENT )* RPAREN EQUALS text= option[$name.text] SEMICOLON ( WS )* )
					{
					// org/sqlproc/engine/impl/SqlProcessor.g:235:12: (name= IDENT LPAREN type= OPTION ( COMMA filter= IDENT )* RPAREN EQUALS text= option[$name.text] SEMICOLON ( WS )* )
					// org/sqlproc/engine/impl/SqlProcessor.g:235:13: name= IDENT LPAREN type= OPTION ( COMMA filter= IDENT )* RPAREN EQUALS text= option[$name.text] SEMICOLON ( WS )*
					{
					name=(Token)match(input,IDENT,FOLLOW_IDENT_in_parse2242); 
					match(input,LPAREN,FOLLOW_LPAREN_in_parse2244); 
					type=(Token)match(input,OPTION,FOLLOW_OPTION_in_parse2248); 
					activeFilters = new ArrayList<String>();
					// org/sqlproc/engine/impl/SqlProcessor.g:235:86: ( COMMA filter= IDENT )*
					loop6:
					while (true) {
						int alt6=2;
						int LA6_0 = input.LA(1);
						if ( (LA6_0==COMMA) ) {
							alt6=1;
						}

						switch (alt6) {
						case 1 :
							// org/sqlproc/engine/impl/SqlProcessor.g:235:87: COMMA filter= IDENT
							{
							match(input,COMMA,FOLLOW_COMMA_in_parse2253); 
							filter=(Token)match(input,IDENT,FOLLOW_IDENT_in_parse2257); 
							activeFilters.add((filter!=null?filter.getText():null));
							}
							break;

						default :
							break loop6;
						}
					}

					match(input,RPAREN,FOLLOW_RPAREN_in_parse2263); 
					match(input,EQUALS,FOLLOW_EQUALS_in_parse2265); 
					pushFollow(FOLLOW_option_in_parse2281);
					text=option((name!=null?name.getText():null));
					state._fsp--;

					add(processor, (type!=null?type.getText():null), (name!=null?name.getText():null), text.toString(), activeFilters, filters);
					match(input,SEMICOLON,FOLLOW_SEMICOLON_in_parse2286); 
					// org/sqlproc/engine/impl/SqlProcessor.g:236:129: ( WS )*
					loop7:
					while (true) {
						int alt7=2;
						int LA7_0 = input.LA(1);
						if ( (LA7_0==WS) ) {
							alt7=1;
						}

						switch (alt7) {
						case 1 :
							// org/sqlproc/engine/impl/SqlProcessor.g:236:129: WS
							{
							match(input,WS,FOLLOW_WS_in_parse2288); 
							}
							break;

						default :
							break loop7;
						}
					}

					}

					}
					break;

				default :
					if ( cnt8 >= 1 ) break loop8;
					EarlyExitException eee = new EarlyExitException(8, input);
					throw eee;
				}
				cnt8++;
			}

			match(input,EOF,FOLLOW_EOF_in_parse2303); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return processor;
	}
	// $ANTLR end "parse2"


	protected static class meta_scope {
		StringBuilder text;
		boolean hasOutputMapping;
		SqlTypeFactory typeFactory;
		boolean skip;
	}
	protected Stack<meta_scope> meta_stack = new Stack<meta_scope>();


	// $ANTLR start "meta"
	// org/sqlproc/engine/impl/SqlProcessor.g:240:1: meta[String name, SqlTypeFactory _typeFactory, boolean _skip] returns [SqlMetaStatement metaStatement] : sql[metaStatement] ( EOF )? ;
	public final SqlMetaStatement meta(String name, SqlTypeFactory _typeFactory, boolean _skip) throws RecognitionException {
		meta_stack.push(new meta_scope());
		SqlMetaStatement metaStatement = null;


		artifactName.push(name); metaStatement = newSqlMetaStatement(); meta_stack.peek().text = new StringBuilder(); meta_stack.peek().typeFactory =_typeFactory; meta_stack.peek().skip =_skip;
		try {
			// org/sqlproc/engine/impl/SqlProcessor.g:244:2: ( sql[metaStatement] ( EOF )? )
			// org/sqlproc/engine/impl/SqlProcessor.g:244:4: sql[metaStatement] ( EOF )?
			{
			pushFollow(FOLLOW_sql_in_meta335);
			sql(metaStatement);
			state._fsp--;

			// org/sqlproc/engine/impl/SqlProcessor.g:244:23: ( EOF )?
			int alt9=2;
			int LA9_0 = input.LA(1);
			if ( (LA9_0==EOF) ) {
				alt9=1;
			}
			switch (alt9) {
				case 1 :
					// org/sqlproc/engine/impl/SqlProcessor.g:244:23: EOF
					{
					match(input,EOF,FOLLOW_EOF_in_meta338); 
					}
					break;

			}

			}

			metaStatement.setHasOutputMapping(meta_stack.peek().hasOutputMapping); artifactName.pop();
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
			meta_stack.pop();
		}
		return metaStatement;
	}
	// $ANTLR end "meta"



	// $ANTLR start "sql"
	// org/sqlproc/engine/impl/SqlProcessor.g:247:1: sql[SqlMetaStatement metaStatement] : ( sqlFragment[metaStatement] )+ ;
	public final void sql(SqlMetaStatement metaStatement) throws RecognitionException {
		try {
			// org/sqlproc/engine/impl/SqlProcessor.g:248:23: ( ( sqlFragment[metaStatement] )+ )
			// org/sqlproc/engine/impl/SqlProcessor.g:249:2: ( sqlFragment[metaStatement] )+
			{
			// org/sqlproc/engine/impl/SqlProcessor.g:249:2: ( sqlFragment[metaStatement] )+
			int cnt10=0;
			loop10:
			while (true) {
				int alt10=2;
				int LA10_0 = input.LA(1);
				if ( ((LA10_0 >= AND && LA10_0 <= RPAREN)||(LA10_0 >= SL_COMMENT && LA10_0 <= WS)) ) {
					alt10=1;
				}

				switch (alt10) {
				case 1 :
					// org/sqlproc/engine/impl/SqlProcessor.g:249:3: sqlFragment[metaStatement]
					{
					pushFollow(FOLLOW_sqlFragment_in_sql377);
					sqlFragment(metaStatement);
					state._fsp--;

					}
					break;

				default :
					if ( cnt10 >= 1 ) break loop10;
					EarlyExitException eee = new EarlyExitException(10, input);
					throw eee;
				}
				cnt10++;
			}

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "sql"



	// $ANTLR start "sqlFragment"
	// org/sqlproc/engine/impl/SqlProcessor.g:252:1: sqlFragment[SqlMetaStatement metaStatement] : (~ ( COLON | STRING | AT | PERCENT | LBRACE | SEMICOLON ) | COLON ident= identifier | STRING cnst= constant | COLON COLON identOper= identifierOperator | STRING STRING cnstOper= constantOperator | AT col= column | PERCENT ( PERCENT dbtab= dbtable |dbcol= dbcolumn ) | LBRACE metaSql[metaStatement] RBRACE );
	public final void sqlFragment(SqlMetaStatement metaStatement) throws RecognitionException {
		SqlMetaIdent ident =null;
		SqlMetaConst cnst =null;
		SqlMetaOperator identOper =null;
		SqlMetaOperator cnstOper =null;
		SqlMappingItem col =null;
		SqlDatabaseTable dbtab =null;
		SqlDatabaseColumn dbcol =null;

		try {
			// org/sqlproc/engine/impl/SqlProcessor.g:254:2: (~ ( COLON | STRING | AT | PERCENT | LBRACE | SEMICOLON ) | COLON ident= identifier | STRING cnst= constant | COLON COLON identOper= identifierOperator | STRING STRING cnstOper= constantOperator | AT col= column | PERCENT ( PERCENT dbtab= dbtable |dbcol= dbcolumn ) | LBRACE metaSql[metaStatement] RBRACE )
			int alt12=8;
			switch ( input.LA(1) ) {
			case AND:
			case BAND:
			case BOR:
			case CARET:
			case COMMA:
			case DIGIT:
			case DOT:
			case EQUALS:
			case ESC_AT:
			case ESC_BOR:
			case ESC_CHAR:
			case ESC_COLON:
			case ESC_DOT:
			case ESC_HASH:
			case ESC_LBRACE:
			case ESC_PERCENT:
			case ESC_RBRACE:
			case ESC_SEMICOLON:
			case ESC_SLASH:
			case ESC_STRING:
			case HASH:
			case IDENT:
			case IDENT_DOT:
			case LESS_THAN:
			case LPAREN:
			case MAPPING:
			case MINUS:
			case ML_COMMENT:
			case MORE_THAN:
			case NOT:
			case NUMBER:
			case OPTION:
			case OR:
			case PLUS:
			case QUESTI:
			case RBRACE:
			case REST:
			case RPAREN:
			case SL_COMMENT:
			case STATEMENT:
			case WS:
				{
				alt12=1;
				}
				break;
			case COLON:
				{
				int LA12_2 = input.LA(2);
				if ( (LA12_2==COLON) ) {
					alt12=4;
				}
				else if ( (LA12_2==EQUALS||(LA12_2 >= IDENT && LA12_2 <= IDENT_DOT)||LA12_2==LESS_THAN||LA12_2==MINUS||LA12_2==MORE_THAN||LA12_2==NUMBER||LA12_2==PLUS) ) {
					alt12=2;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 12, 2, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case STRING:
				{
				int LA12_3 = input.LA(2);
				if ( (LA12_3==STRING) ) {
					alt12=5;
				}
				else if ( ((LA12_3 >= IDENT && LA12_3 <= IDENT_DOT)||LA12_3==MINUS||LA12_3==PLUS) ) {
					alt12=3;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 12, 3, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case AT:
				{
				alt12=6;
				}
				break;
			case PERCENT:
				{
				alt12=7;
				}
				break;
			case LBRACE:
				{
				alt12=8;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 12, 0, input);
				throw nvae;
			}
			switch (alt12) {
				case 1 :
					// org/sqlproc/engine/impl/SqlProcessor.g:255:2: ~ ( COLON | STRING | AT | PERCENT | LBRACE | SEMICOLON )
					{
					if ( input.LA(1)==AND||(input.LA(1) >= BAND && input.LA(1) <= CARET)||(input.LA(1) >= COMMA && input.LA(1) <= IDENT_DOT)||(input.LA(1) >= LESS_THAN && input.LA(1) <= OR)||(input.LA(1) >= PLUS && input.LA(1) <= RPAREN)||(input.LA(1) >= SL_COMMENT && input.LA(1) <= STATEMENT)||input.LA(1)==WS ) {
						input.consume();
						state.errorRecovery=false;
					}
					else {
						MismatchedSetException mse = new MismatchedSetException(null,input);
						throw mse;
					}
					if(!meta_stack.peek().skip) add(meta_stack.peek().text);
					}
					break;
				case 2 :
					// org/sqlproc/engine/impl/SqlProcessor.g:257:4: COLON ident= identifier
					{
					match(input,COLON,FOLLOW_COLON_in_sqlFragment438); 
					pushFollow(FOLLOW_identifier_in_sqlFragment442);
					ident=identifier();
					state._fsp--;

					if(!meta_stack.peek().skip) addIdent(metaStatement, ident, meta_stack.peek().text);
					}
					break;
				case 3 :
					// org/sqlproc/engine/impl/SqlProcessor.g:259:7: STRING cnst= constant
					{
					match(input,STRING,FOLLOW_STRING_in_sqlFragment455); 
					pushFollow(FOLLOW_constant_in_sqlFragment459);
					cnst=constant();
					state._fsp--;

					if(!meta_stack.peek().skip) addConstant(metaStatement, cnst, meta_stack.peek().text);
					}
					break;
				case 4 :
					// org/sqlproc/engine/impl/SqlProcessor.g:261:4: COLON COLON identOper= identifierOperator
					{
					match(input,COLON,FOLLOW_COLON_in_sqlFragment472); 
					match(input,COLON,FOLLOW_COLON_in_sqlFragment474); 
					pushFollow(FOLLOW_identifierOperator_in_sqlFragment478);
					identOper=identifierOperator();
					state._fsp--;

					if(!meta_stack.peek().skip) addOperator(metaStatement, identOper, meta_stack.peek().text);
					}
					break;
				case 5 :
					// org/sqlproc/engine/impl/SqlProcessor.g:263:4: STRING STRING cnstOper= constantOperator
					{
					match(input,STRING,FOLLOW_STRING_in_sqlFragment488); 
					match(input,STRING,FOLLOW_STRING_in_sqlFragment490); 
					pushFollow(FOLLOW_constantOperator_in_sqlFragment494);
					cnstOper=constantOperator();
					state._fsp--;

					if(!meta_stack.peek().skip) addOperator(metaStatement, cnstOper, meta_stack.peek().text);
					}
					break;
				case 6 :
					// org/sqlproc/engine/impl/SqlProcessor.g:265:7: AT col= column
					{
					match(input,AT,FOLLOW_AT_in_sqlFragment507); 
					pushFollow(FOLLOW_column_in_sqlFragment511);
					col=column();
					state._fsp--;

					if(!meta_stack.peek().skip) addColumn(metaStatement, col, meta_stack.peek().text);meta_stack.peek().hasOutputMapping =true;
					}
					break;
				case 7 :
					// org/sqlproc/engine/impl/SqlProcessor.g:267:5: PERCENT ( PERCENT dbtab= dbtable |dbcol= dbcolumn )
					{
					match(input,PERCENT,FOLLOW_PERCENT_in_sqlFragment525); 
					// org/sqlproc/engine/impl/SqlProcessor.g:267:13: ( PERCENT dbtab= dbtable |dbcol= dbcolumn )
					int alt11=2;
					int LA11_0 = input.LA(1);
					if ( (LA11_0==PERCENT) ) {
						alt11=1;
					}
					else if ( ((LA11_0 >= IDENT && LA11_0 <= IDENT_DOT)) ) {
						alt11=2;
					}

					else {
						NoViableAltException nvae =
							new NoViableAltException("", 11, 0, input);
						throw nvae;
					}

					switch (alt11) {
						case 1 :
							// org/sqlproc/engine/impl/SqlProcessor.g:267:14: PERCENT dbtab= dbtable
							{
							match(input,PERCENT,FOLLOW_PERCENT_in_sqlFragment528); 
							pushFollow(FOLLOW_dbtable_in_sqlFragment532);
							dbtab=dbtable();
							state._fsp--;

							if(!meta_stack.peek().skip) addDatabaseTable(metaStatement, dbtab, meta_stack.peek().text);
							}
							break;
						case 2 :
							// org/sqlproc/engine/impl/SqlProcessor.g:268:16: dbcol= dbcolumn
							{
							pushFollow(FOLLOW_dbcolumn_in_sqlFragment553);
							dbcol=dbcolumn();
							state._fsp--;

							if(!meta_stack.peek().skip) addDatabaseColumn(metaStatement, dbcol, meta_stack.peek().text);
							}
							break;

					}

					}
					break;
				case 8 :
					// org/sqlproc/engine/impl/SqlProcessor.g:269:7: LBRACE metaSql[metaStatement] RBRACE
					{
					match(input,LBRACE,FOLLOW_LBRACE_in_sqlFragment564); 
					pushFollow(FOLLOW_metaSql_in_sqlFragment566);
					metaSql(metaStatement);
					state._fsp--;

					match(input,RBRACE,FOLLOW_RBRACE_in_sqlFragment569); 
					}
					break;

			}
			if(!meta_stack.peek().skip) addText(metaStatement, meta_stack.peek().text);
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "sqlFragment"



	// $ANTLR start "metaSql"
	// org/sqlproc/engine/impl/SqlProcessor.g:272:1: metaSql[SqlMetaStatement metaStatement] : (~ ( QUESTI | BAND | BOR | EQUALS | HASH | RBRACE ) metaIfItem= ifSql[null] ( BOR metaIfItem= ifSql[null] )* | QUESTI metaLogExpr= ifSqlCond BOR metaIfItem= ifSql[null] ( BOR metaIfItem= ifSql[null] )* | BAND metaIfItem= ifSql[null] ( BOR metaIfItem= ifSql[null] )* | BOR metaIfItem= ifSql[null] ( BOR metaIfItem= ifSql[null] )* | EQUALS ( WS )* fragmentType= IDENT metaIfItem= ifSql[null] | HASH orderId= ( NUMBER | IDENT ) ordSql[metaOrd] );
	public final void metaSql(SqlMetaStatement metaStatement) throws RecognitionException {
		Token fragmentType=null;
		Token orderId=null;
		SqlMetaIfItem metaIfItem =null;
		SqlMetaLogExpr metaLogExpr =null;

		SqlMetaAndOr metaAndOr; SqlMetaIf metaIf; SqlMetaOrd metaOrd; SqlMetaSqlFragment sqlFragment; if(!meta_stack.peek().skip) addText(metaStatement, meta_stack.peek().text);
		try {
			// org/sqlproc/engine/impl/SqlProcessor.g:274:2: (~ ( QUESTI | BAND | BOR | EQUALS | HASH | RBRACE ) metaIfItem= ifSql[null] ( BOR metaIfItem= ifSql[null] )* | QUESTI metaLogExpr= ifSqlCond BOR metaIfItem= ifSql[null] ( BOR metaIfItem= ifSql[null] )* | BAND metaIfItem= ifSql[null] ( BOR metaIfItem= ifSql[null] )* | BOR metaIfItem= ifSql[null] ( BOR metaIfItem= ifSql[null] )* | EQUALS ( WS )* fragmentType= IDENT metaIfItem= ifSql[null] | HASH orderId= ( NUMBER | IDENT ) ordSql[metaOrd] )
			int alt18=6;
			switch ( input.LA(1) ) {
			case AND:
			case AT:
			case CARET:
			case COLON:
			case COMMA:
			case DIGIT:
			case DOT:
			case ESC_AT:
			case ESC_BOR:
			case ESC_CHAR:
			case ESC_COLON:
			case ESC_DOT:
			case ESC_HASH:
			case ESC_LBRACE:
			case ESC_PERCENT:
			case ESC_RBRACE:
			case ESC_SEMICOLON:
			case ESC_SLASH:
			case ESC_STRING:
			case IDENT:
			case IDENT_DOT:
			case LBRACE:
			case LESS_THAN:
			case LPAREN:
			case MAPPING:
			case MINUS:
			case ML_COMMENT:
			case MORE_THAN:
			case NOT:
			case NUMBER:
			case OPTION:
			case OR:
			case PERCENT:
			case PLUS:
			case REST:
			case RPAREN:
			case SEMICOLON:
			case SL_COMMENT:
			case STATEMENT:
			case STRING:
			case WS:
				{
				alt18=1;
				}
				break;
			case QUESTI:
				{
				alt18=2;
				}
				break;
			case BAND:
				{
				alt18=3;
				}
				break;
			case BOR:
				{
				alt18=4;
				}
				break;
			case EQUALS:
				{
				alt18=5;
				}
				break;
			case HASH:
				{
				alt18=6;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 18, 0, input);
				throw nvae;
			}
			switch (alt18) {
				case 1 :
					// org/sqlproc/engine/impl/SqlProcessor.g:275:2: ~ ( QUESTI | BAND | BOR | EQUALS | HASH | RBRACE ) metaIfItem= ifSql[null] ( BOR metaIfItem= ifSql[null] )*
					{
					if ( (input.LA(1) >= AND && input.LA(1) <= AT)||(input.LA(1) >= CARET && input.LA(1) <= DOT)||(input.LA(1) >= ESC_AT && input.LA(1) <= ESC_STRING)||(input.LA(1) >= IDENT && input.LA(1) <= PLUS)||(input.LA(1) >= REST && input.LA(1) <= WS) ) {
						input.consume();
						state.errorRecovery=false;
					}
					else {
						MismatchedSetException mse = new MismatchedSetException(null,input);
						throw mse;
					}
					if(!meta_stack.peek().skip) add(meta_stack.peek().text); metaAndOr = new SqlMetaAndOr(SqlMetaAndOr.Type.NO);
					pushFollow(FOLLOW_ifSql_in_metaSql623);
					metaIfItem=ifSql(null);
					state._fsp--;

					if(!meta_stack.peek().skip) metaAndOr.addElement(metaIfItem);
					// org/sqlproc/engine/impl/SqlProcessor.g:277:3: ( BOR metaIfItem= ifSql[null] )*
					loop13:
					while (true) {
						int alt13=2;
						int LA13_0 = input.LA(1);
						if ( (LA13_0==BOR) ) {
							alt13=1;
						}

						switch (alt13) {
						case 1 :
							// org/sqlproc/engine/impl/SqlProcessor.g:277:4: BOR metaIfItem= ifSql[null]
							{
							match(input,BOR,FOLLOW_BOR_in_metaSql632); 
							pushFollow(FOLLOW_ifSql_in_metaSql636);
							metaIfItem=ifSql(null);
							state._fsp--;

							metaAndOr.addElement(metaIfItem);
							}
							break;

						default :
							break loop13;
						}
					}

					metaStatement.addElement(metaAndOr);
					}
					break;
				case 2 :
					// org/sqlproc/engine/impl/SqlProcessor.g:278:4: QUESTI metaLogExpr= ifSqlCond BOR metaIfItem= ifSql[null] ( BOR metaIfItem= ifSql[null] )*
					{
					match(input,QUESTI,FOLLOW_QUESTI_in_metaSql648); 
					metaIf = new SqlMetaIf(); 
					pushFollow(FOLLOW_ifSqlCond_in_metaSql654);
					metaLogExpr=ifSqlCond();
					state._fsp--;

					if(!meta_stack.peek().skip) metaIf.setExpression(metaLogExpr);
					match(input,BOR,FOLLOW_BOR_in_metaSql661); 
					pushFollow(FOLLOW_ifSql_in_metaSql665);
					metaIfItem=ifSql(null);
					state._fsp--;

					if(!meta_stack.peek().skip) metaIf.addElement(metaIfItem);
					// org/sqlproc/engine/impl/SqlProcessor.g:280:3: ( BOR metaIfItem= ifSql[null] )*
					loop14:
					while (true) {
						int alt14=2;
						int LA14_0 = input.LA(1);
						if ( (LA14_0==BOR) ) {
							alt14=1;
						}

						switch (alt14) {
						case 1 :
							// org/sqlproc/engine/impl/SqlProcessor.g:280:4: BOR metaIfItem= ifSql[null]
							{
							match(input,BOR,FOLLOW_BOR_in_metaSql674); 
							pushFollow(FOLLOW_ifSql_in_metaSql678);
							metaIfItem=ifSql(null);
							state._fsp--;

							if(!meta_stack.peek().skip) metaIf.addElement(metaIfItem);
							}
							break;

						default :
							break loop14;
						}
					}

					metaStatement.addElement(metaIf);
					}
					break;
				case 3 :
					// org/sqlproc/engine/impl/SqlProcessor.g:282:4: BAND metaIfItem= ifSql[null] ( BOR metaIfItem= ifSql[null] )*
					{
					match(input,BAND,FOLLOW_BAND_in_metaSql693); 
					metaAndOr = new SqlMetaAndOr(SqlMetaAndOr.Type.AND);
					pushFollow(FOLLOW_ifSql_in_metaSql699);
					metaIfItem=ifSql(null);
					state._fsp--;

					if(!meta_stack.peek().skip) metaAndOr.addElement(metaIfItem);
					// org/sqlproc/engine/impl/SqlProcessor.g:283:3: ( BOR metaIfItem= ifSql[null] )*
					loop15:
					while (true) {
						int alt15=2;
						int LA15_0 = input.LA(1);
						if ( (LA15_0==BOR) ) {
							alt15=1;
						}

						switch (alt15) {
						case 1 :
							// org/sqlproc/engine/impl/SqlProcessor.g:283:4: BOR metaIfItem= ifSql[null]
							{
							match(input,BOR,FOLLOW_BOR_in_metaSql708); 
							pushFollow(FOLLOW_ifSql_in_metaSql712);
							metaIfItem=ifSql(null);
							state._fsp--;

							if(!meta_stack.peek().skip) metaAndOr.addElement(metaIfItem);
							}
							break;

						default :
							break loop15;
						}
					}

					if(!meta_stack.peek().skip) metaStatement.addElement(metaAndOr);
					}
					break;
				case 4 :
					// org/sqlproc/engine/impl/SqlProcessor.g:284:4: BOR metaIfItem= ifSql[null] ( BOR metaIfItem= ifSql[null] )*
					{
					match(input,BOR,FOLLOW_BOR_in_metaSql724); 
					metaAndOr = new SqlMetaAndOr(SqlMetaAndOr.Type.OR);
					pushFollow(FOLLOW_ifSql_in_metaSql730);
					metaIfItem=ifSql(null);
					state._fsp--;

					if(!meta_stack.peek().skip) metaAndOr.addElement(metaIfItem);
					// org/sqlproc/engine/impl/SqlProcessor.g:285:3: ( BOR metaIfItem= ifSql[null] )*
					loop16:
					while (true) {
						int alt16=2;
						int LA16_0 = input.LA(1);
						if ( (LA16_0==BOR) ) {
							alt16=1;
						}

						switch (alt16) {
						case 1 :
							// org/sqlproc/engine/impl/SqlProcessor.g:285:4: BOR metaIfItem= ifSql[null]
							{
							match(input,BOR,FOLLOW_BOR_in_metaSql739); 
							pushFollow(FOLLOW_ifSql_in_metaSql743);
							metaIfItem=ifSql(null);
							state._fsp--;

							if(!meta_stack.peek().skip) metaAndOr.addElement(metaIfItem);
							}
							break;

						default :
							break loop16;
						}
					}

					if(!meta_stack.peek().skip) metaStatement.addElement(metaAndOr);
					}
					break;
				case 5 :
					// org/sqlproc/engine/impl/SqlProcessor.g:286:4: EQUALS ( WS )* fragmentType= IDENT metaIfItem= ifSql[null]
					{
					match(input,EQUALS,FOLLOW_EQUALS_in_metaSql755); 
					// org/sqlproc/engine/impl/SqlProcessor.g:286:11: ( WS )*
					loop17:
					while (true) {
						int alt17=2;
						int LA17_0 = input.LA(1);
						if ( (LA17_0==WS) ) {
							alt17=1;
						}

						switch (alt17) {
						case 1 :
							// org/sqlproc/engine/impl/SqlProcessor.g:286:11: WS
							{
							match(input,WS,FOLLOW_WS_in_metaSql757); 
							}
							break;

						default :
							break loop17;
						}
					}

					fragmentType=(Token)match(input,IDENT,FOLLOW_IDENT_in_metaSql762); 
					sqlFragment = new SqlMetaSqlFragment(fragmentType.getText());
					pushFollow(FOLLOW_ifSql_in_metaSql768);
					metaIfItem=ifSql(null);
					state._fsp--;

					if(!meta_stack.peek().skip) sqlFragment.addElement(metaIfItem);
					if(!meta_stack.peek().skip) metaStatement.addElement(sqlFragment);
					}
					break;
				case 6 :
					// org/sqlproc/engine/impl/SqlProcessor.g:288:4: HASH orderId= ( NUMBER | IDENT ) ordSql[metaOrd]
					{
					match(input,HASH,FOLLOW_HASH_in_metaSql781); 
					orderId=input.LT(1);
					if ( input.LA(1)==IDENT||input.LA(1)==NUMBER ) {
						input.consume();
						state.errorRecovery=false;
					}
					else {
						MismatchedSetException mse = new MismatchedSetException(null,input);
						throw mse;
					}
					metaOrd = new SqlMetaOrd(orderId.getText());
					pushFollow(FOLLOW_ordSql_in_metaSql795);
					ordSql(metaOrd);
					state._fsp--;

					if(!meta_stack.peek().skip) metaStatement.addElement(metaOrd);
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "metaSql"



	// $ANTLR start "ifSql"
	// org/sqlproc/engine/impl/SqlProcessor.g:291:1: ifSql[SqlMetaIfItem metaIfItemIn] returns [SqlMetaIfItem metaIfItem] : ( ifSqlFragment[metaIfItem] )+ ;
	public final SqlMetaIfItem ifSql(SqlMetaIfItem metaIfItemIn) throws RecognitionException {
		SqlMetaIfItem metaIfItem = null;


		metaIfItem = (metaIfItemIn !=null) ? metaIfItemIn : newSqlMetaIfItem();
		try {
			// org/sqlproc/engine/impl/SqlProcessor.g:293:2: ( ( ifSqlFragment[metaIfItem] )+ )
			// org/sqlproc/engine/impl/SqlProcessor.g:294:2: ( ifSqlFragment[metaIfItem] )+
			{
			// org/sqlproc/engine/impl/SqlProcessor.g:294:2: ( ifSqlFragment[metaIfItem] )+
			int cnt19=0;
			loop19:
			while (true) {
				int alt19=2;
				int LA19_0 = input.LA(1);
				if ( ((LA19_0 >= AND && LA19_0 <= BAND)||(LA19_0 >= CARET && LA19_0 <= QUESTI)||(LA19_0 >= REST && LA19_0 <= WS)) ) {
					alt19=1;
				}

				switch (alt19) {
				case 1 :
					// org/sqlproc/engine/impl/SqlProcessor.g:294:3: ifSqlFragment[metaIfItem]
					{
					pushFollow(FOLLOW_ifSqlFragment_in_ifSql822);
					ifSqlFragment(metaIfItem);
					state._fsp--;

					}
					break;

				default :
					if ( cnt19 >= 1 ) break loop19;
					EarlyExitException eee = new EarlyExitException(19, input);
					throw eee;
				}
				cnt19++;
			}

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return metaIfItem;
	}
	// $ANTLR end "ifSql"



	// $ANTLR start "ifSqlFragment"
	// org/sqlproc/engine/impl/SqlProcessor.g:297:1: ifSqlFragment[SqlMetaIfItem metaIfItem] : (~ ( COLON | STRING | AT | PERCENT | LBRACE | BOR | RBRACE ) | COLON ident= identifier | STRING cnst= constant | COLON COLON identOper= identifierOperator | STRING STRING cnstOper= constantOperator | AT col= column | PERCENT ( PERCENT dbtab= dbtable |dbcol= dbcolumn ) | LBRACE ifMetaSql[metaIfItem] RBRACE );
	public final void ifSqlFragment(SqlMetaIfItem metaIfItem) throws RecognitionException {
		SqlMetaIdent ident =null;
		SqlMetaConst cnst =null;
		SqlMetaOperator identOper =null;
		SqlMetaOperator cnstOper =null;
		SqlMappingItem col =null;
		SqlDatabaseTable dbtab =null;
		SqlDatabaseColumn dbcol =null;

		try {
			// org/sqlproc/engine/impl/SqlProcessor.g:299:2: (~ ( COLON | STRING | AT | PERCENT | LBRACE | BOR | RBRACE ) | COLON ident= identifier | STRING cnst= constant | COLON COLON identOper= identifierOperator | STRING STRING cnstOper= constantOperator | AT col= column | PERCENT ( PERCENT dbtab= dbtable |dbcol= dbcolumn ) | LBRACE ifMetaSql[metaIfItem] RBRACE )
			int alt21=8;
			switch ( input.LA(1) ) {
			case AND:
			case BAND:
			case CARET:
			case COMMA:
			case DIGIT:
			case DOT:
			case EQUALS:
			case ESC_AT:
			case ESC_BOR:
			case ESC_CHAR:
			case ESC_COLON:
			case ESC_DOT:
			case ESC_HASH:
			case ESC_LBRACE:
			case ESC_PERCENT:
			case ESC_RBRACE:
			case ESC_SEMICOLON:
			case ESC_SLASH:
			case ESC_STRING:
			case HASH:
			case IDENT:
			case IDENT_DOT:
			case LESS_THAN:
			case LPAREN:
			case MAPPING:
			case MINUS:
			case ML_COMMENT:
			case MORE_THAN:
			case NOT:
			case NUMBER:
			case OPTION:
			case OR:
			case PLUS:
			case QUESTI:
			case REST:
			case RPAREN:
			case SEMICOLON:
			case SL_COMMENT:
			case STATEMENT:
			case WS:
				{
				alt21=1;
				}
				break;
			case COLON:
				{
				int LA21_2 = input.LA(2);
				if ( (LA21_2==COLON) ) {
					alt21=4;
				}
				else if ( (LA21_2==EQUALS||(LA21_2 >= IDENT && LA21_2 <= IDENT_DOT)||LA21_2==LESS_THAN||LA21_2==MINUS||LA21_2==MORE_THAN||LA21_2==NUMBER||LA21_2==PLUS) ) {
					alt21=2;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 21, 2, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case STRING:
				{
				int LA21_3 = input.LA(2);
				if ( (LA21_3==STRING) ) {
					alt21=5;
				}
				else if ( ((LA21_3 >= IDENT && LA21_3 <= IDENT_DOT)||LA21_3==MINUS||LA21_3==PLUS) ) {
					alt21=3;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 21, 3, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case AT:
				{
				alt21=6;
				}
				break;
			case PERCENT:
				{
				alt21=7;
				}
				break;
			case LBRACE:
				{
				alt21=8;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 21, 0, input);
				throw nvae;
			}
			switch (alt21) {
				case 1 :
					// org/sqlproc/engine/impl/SqlProcessor.g:300:2: ~ ( COLON | STRING | AT | PERCENT | LBRACE | BOR | RBRACE )
					{
					if ( input.LA(1)==AND||input.LA(1)==BAND||input.LA(1)==CARET||(input.LA(1) >= COMMA && input.LA(1) <= IDENT_DOT)||(input.LA(1) >= LESS_THAN && input.LA(1) <= OR)||(input.LA(1) >= PLUS && input.LA(1) <= QUESTI)||(input.LA(1) >= REST && input.LA(1) <= STATEMENT)||input.LA(1)==WS ) {
						input.consume();
						state.errorRecovery=false;
					}
					else {
						MismatchedSetException mse = new MismatchedSetException(null,input);
						throw mse;
					}
					if(!meta_stack.peek().skip) add(meta_stack.peek().text);
					}
					break;
				case 2 :
					// org/sqlproc/engine/impl/SqlProcessor.g:302:4: COLON ident= identifier
					{
					match(input,COLON,FOLLOW_COLON_in_ifSqlFragment880); 
					pushFollow(FOLLOW_identifier_in_ifSqlFragment884);
					ident=identifier();
					state._fsp--;

					if(!meta_stack.peek().skip) addIdent(metaIfItem, ident, meta_stack.peek().text);
					}
					break;
				case 3 :
					// org/sqlproc/engine/impl/SqlProcessor.g:304:4: STRING cnst= constant
					{
					match(input,STRING,FOLLOW_STRING_in_ifSqlFragment894); 
					pushFollow(FOLLOW_constant_in_ifSqlFragment898);
					cnst=constant();
					state._fsp--;

					if(!meta_stack.peek().skip) addConstant(metaIfItem, cnst, meta_stack.peek().text);
					}
					break;
				case 4 :
					// org/sqlproc/engine/impl/SqlProcessor.g:306:4: COLON COLON identOper= identifierOperator
					{
					match(input,COLON,FOLLOW_COLON_in_ifSqlFragment908); 
					match(input,COLON,FOLLOW_COLON_in_ifSqlFragment910); 
					pushFollow(FOLLOW_identifierOperator_in_ifSqlFragment914);
					identOper=identifierOperator();
					state._fsp--;

					if(!meta_stack.peek().skip) addOperator(metaIfItem, identOper, meta_stack.peek().text);
					}
					break;
				case 5 :
					// org/sqlproc/engine/impl/SqlProcessor.g:308:4: STRING STRING cnstOper= constantOperator
					{
					match(input,STRING,FOLLOW_STRING_in_ifSqlFragment924); 
					match(input,STRING,FOLLOW_STRING_in_ifSqlFragment926); 
					pushFollow(FOLLOW_constantOperator_in_ifSqlFragment930);
					cnstOper=constantOperator();
					state._fsp--;

					if(!meta_stack.peek().skip) addOperator(metaIfItem, cnstOper, meta_stack.peek().text);
					}
					break;
				case 6 :
					// org/sqlproc/engine/impl/SqlProcessor.g:310:7: AT col= column
					{
					match(input,AT,FOLLOW_AT_in_ifSqlFragment943); 
					pushFollow(FOLLOW_column_in_ifSqlFragment947);
					col=column();
					state._fsp--;

					if(!meta_stack.peek().skip) addColumn(metaIfItem, col, meta_stack.peek().text);meta_stack.peek().hasOutputMapping =true;
					}
					break;
				case 7 :
					// org/sqlproc/engine/impl/SqlProcessor.g:312:4: PERCENT ( PERCENT dbtab= dbtable |dbcol= dbcolumn )
					{
					match(input,PERCENT,FOLLOW_PERCENT_in_ifSqlFragment960); 
					// org/sqlproc/engine/impl/SqlProcessor.g:312:12: ( PERCENT dbtab= dbtable |dbcol= dbcolumn )
					int alt20=2;
					int LA20_0 = input.LA(1);
					if ( (LA20_0==PERCENT) ) {
						alt20=1;
					}
					else if ( ((LA20_0 >= IDENT && LA20_0 <= IDENT_DOT)) ) {
						alt20=2;
					}

					else {
						NoViableAltException nvae =
							new NoViableAltException("", 20, 0, input);
						throw nvae;
					}

					switch (alt20) {
						case 1 :
							// org/sqlproc/engine/impl/SqlProcessor.g:312:13: PERCENT dbtab= dbtable
							{
							match(input,PERCENT,FOLLOW_PERCENT_in_ifSqlFragment963); 
							pushFollow(FOLLOW_dbtable_in_ifSqlFragment967);
							dbtab=dbtable();
							state._fsp--;

							if(!meta_stack.peek().skip) addDatabaseTable(metaIfItem, dbtab, meta_stack.peek().text);
							}
							break;
						case 2 :
							// org/sqlproc/engine/impl/SqlProcessor.g:313:16: dbcol= dbcolumn
							{
							pushFollow(FOLLOW_dbcolumn_in_ifSqlFragment988);
							dbcol=dbcolumn();
							state._fsp--;

							if(!meta_stack.peek().skip) addDatabaseColumn(metaIfItem, dbcol, meta_stack.peek().text);
							}
							break;

					}

					}
					break;
				case 8 :
					// org/sqlproc/engine/impl/SqlProcessor.g:314:4: LBRACE ifMetaSql[metaIfItem] RBRACE
					{
					match(input,LBRACE,FOLLOW_LBRACE_in_ifSqlFragment996); 
					pushFollow(FOLLOW_ifMetaSql_in_ifSqlFragment998);
					ifMetaSql(metaIfItem);
					state._fsp--;

					match(input,RBRACE,FOLLOW_RBRACE_in_ifSqlFragment1001); 
					}
					break;

			}
			if(!meta_stack.peek().skip) addText(metaIfItem, meta_stack.peek().text);
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "ifSqlFragment"



	// $ANTLR start "ifMetaSql"
	// org/sqlproc/engine/impl/SqlProcessor.g:318:1: ifMetaSql[SqlMetaIfItem metaIfItem] : (~ ( QUESTI | BAND | BOR | LBRACE | RBRACE ) metaIfItem2= ifSql[null] ( BOR metaIfItem2= ifSql[null] )* | QUESTI metaLogExpr= ifSqlCond BOR metaIfItem2= ifSql[null] ( BOR metaIfItem2= ifSql[null] )* | BAND metaIfItem2= ifSql[null] ( BOR metaIfItem2= ifSql[null] )* | BOR metaIfItem2= ifSql[null] ( BOR metaIfItem2= ifSql[null] )* );
	public final void ifMetaSql(SqlMetaIfItem metaIfItem) throws RecognitionException {
		SqlMetaIfItem metaIfItem2 =null;
		SqlMetaLogExpr metaLogExpr =null;

		SqlMetaAndOr metaAndOr; SqlMetaIf metaIf; if(!meta_stack.peek().skip) addText(metaIfItem, meta_stack.peek().text);
		try {
			// org/sqlproc/engine/impl/SqlProcessor.g:320:2: (~ ( QUESTI | BAND | BOR | LBRACE | RBRACE ) metaIfItem2= ifSql[null] ( BOR metaIfItem2= ifSql[null] )* | QUESTI metaLogExpr= ifSqlCond BOR metaIfItem2= ifSql[null] ( BOR metaIfItem2= ifSql[null] )* | BAND metaIfItem2= ifSql[null] ( BOR metaIfItem2= ifSql[null] )* | BOR metaIfItem2= ifSql[null] ( BOR metaIfItem2= ifSql[null] )* )
			int alt26=4;
			switch ( input.LA(1) ) {
			case AND:
			case AT:
			case CARET:
			case COLON:
			case COMMA:
			case DIGIT:
			case DOT:
			case EQUALS:
			case ESC_AT:
			case ESC_BOR:
			case ESC_CHAR:
			case ESC_COLON:
			case ESC_DOT:
			case ESC_HASH:
			case ESC_LBRACE:
			case ESC_PERCENT:
			case ESC_RBRACE:
			case ESC_SEMICOLON:
			case ESC_SLASH:
			case ESC_STRING:
			case HASH:
			case IDENT:
			case IDENT_DOT:
			case LESS_THAN:
			case LPAREN:
			case MAPPING:
			case MINUS:
			case ML_COMMENT:
			case MORE_THAN:
			case NOT:
			case NUMBER:
			case OPTION:
			case OR:
			case PERCENT:
			case PLUS:
			case REST:
			case RPAREN:
			case SEMICOLON:
			case SL_COMMENT:
			case STATEMENT:
			case STRING:
			case WS:
				{
				alt26=1;
				}
				break;
			case QUESTI:
				{
				alt26=2;
				}
				break;
			case BAND:
				{
				alt26=3;
				}
				break;
			case BOR:
				{
				alt26=4;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 26, 0, input);
				throw nvae;
			}
			switch (alt26) {
				case 1 :
					// org/sqlproc/engine/impl/SqlProcessor.g:321:2: ~ ( QUESTI | BAND | BOR | LBRACE | RBRACE ) metaIfItem2= ifSql[null] ( BOR metaIfItem2= ifSql[null] )*
					{
					if ( (input.LA(1) >= AND && input.LA(1) <= AT)||(input.LA(1) >= CARET && input.LA(1) <= IDENT_DOT)||(input.LA(1) >= LESS_THAN && input.LA(1) <= PLUS)||(input.LA(1) >= REST && input.LA(1) <= WS) ) {
						input.consume();
						state.errorRecovery=false;
					}
					else {
						MismatchedSetException mse = new MismatchedSetException(null,input);
						throw mse;
					}
					if(!meta_stack.peek().skip) add(meta_stack.peek().text); metaAndOr = new SqlMetaAndOr(SqlMetaAndOr.Type.NO);
					pushFollow(FOLLOW_ifSql_in_ifMetaSql1061);
					metaIfItem2=ifSql(null);
					state._fsp--;

					if(!meta_stack.peek().skip) metaAndOr.addElement(metaIfItem2);
					// org/sqlproc/engine/impl/SqlProcessor.g:323:3: ( BOR metaIfItem2= ifSql[null] )*
					loop22:
					while (true) {
						int alt22=2;
						int LA22_0 = input.LA(1);
						if ( (LA22_0==BOR) ) {
							alt22=1;
						}

						switch (alt22) {
						case 1 :
							// org/sqlproc/engine/impl/SqlProcessor.g:323:4: BOR metaIfItem2= ifSql[null]
							{
							match(input,BOR,FOLLOW_BOR_in_ifMetaSql1070); 
							pushFollow(FOLLOW_ifSql_in_ifMetaSql1074);
							metaIfItem2=ifSql(null);
							state._fsp--;

							if(!meta_stack.peek().skip) metaAndOr.addElement(metaIfItem2);
							}
							break;

						default :
							break loop22;
						}
					}

					if(!meta_stack.peek().skip) metaIfItem.addElement(metaAndOr);
					}
					break;
				case 2 :
					// org/sqlproc/engine/impl/SqlProcessor.g:324:4: QUESTI metaLogExpr= ifSqlCond BOR metaIfItem2= ifSql[null] ( BOR metaIfItem2= ifSql[null] )*
					{
					match(input,QUESTI,FOLLOW_QUESTI_in_ifMetaSql1086); 
					metaIf = new SqlMetaIf(); 
					pushFollow(FOLLOW_ifSqlCond_in_ifMetaSql1092);
					metaLogExpr=ifSqlCond();
					state._fsp--;

					if(!meta_stack.peek().skip) metaIf.setExpression(metaLogExpr);
					match(input,BOR,FOLLOW_BOR_in_ifMetaSql1099); 
					pushFollow(FOLLOW_ifSql_in_ifMetaSql1103);
					metaIfItem2=ifSql(null);
					state._fsp--;

					if(!meta_stack.peek().skip) metaIf.addElement(metaIfItem2);
					// org/sqlproc/engine/impl/SqlProcessor.g:326:3: ( BOR metaIfItem2= ifSql[null] )*
					loop23:
					while (true) {
						int alt23=2;
						int LA23_0 = input.LA(1);
						if ( (LA23_0==BOR) ) {
							alt23=1;
						}

						switch (alt23) {
						case 1 :
							// org/sqlproc/engine/impl/SqlProcessor.g:326:4: BOR metaIfItem2= ifSql[null]
							{
							match(input,BOR,FOLLOW_BOR_in_ifMetaSql1112); 
							pushFollow(FOLLOW_ifSql_in_ifMetaSql1116);
							metaIfItem2=ifSql(null);
							state._fsp--;

							if(!meta_stack.peek().skip) metaIf.addElement(metaIfItem2);
							}
							break;

						default :
							break loop23;
						}
					}

					if(!meta_stack.peek().skip) metaIfItem.addElement(metaIf);
					}
					break;
				case 3 :
					// org/sqlproc/engine/impl/SqlProcessor.g:328:4: BAND metaIfItem2= ifSql[null] ( BOR metaIfItem2= ifSql[null] )*
					{
					match(input,BAND,FOLLOW_BAND_in_ifMetaSql1131); 
					metaAndOr = new SqlMetaAndOr(SqlMetaAndOr.Type.AND);
					pushFollow(FOLLOW_ifSql_in_ifMetaSql1137);
					metaIfItem2=ifSql(null);
					state._fsp--;

					if(!meta_stack.peek().skip) metaAndOr.addElement(metaIfItem2);
					// org/sqlproc/engine/impl/SqlProcessor.g:329:3: ( BOR metaIfItem2= ifSql[null] )*
					loop24:
					while (true) {
						int alt24=2;
						int LA24_0 = input.LA(1);
						if ( (LA24_0==BOR) ) {
							alt24=1;
						}

						switch (alt24) {
						case 1 :
							// org/sqlproc/engine/impl/SqlProcessor.g:329:4: BOR metaIfItem2= ifSql[null]
							{
							match(input,BOR,FOLLOW_BOR_in_ifMetaSql1146); 
							pushFollow(FOLLOW_ifSql_in_ifMetaSql1150);
							metaIfItem2=ifSql(null);
							state._fsp--;

							if(!meta_stack.peek().skip) metaAndOr.addElement(metaIfItem2);
							}
							break;

						default :
							break loop24;
						}
					}

					if(!meta_stack.peek().skip) metaIfItem.addElement(metaAndOr);
					}
					break;
				case 4 :
					// org/sqlproc/engine/impl/SqlProcessor.g:330:4: BOR metaIfItem2= ifSql[null] ( BOR metaIfItem2= ifSql[null] )*
					{
					match(input,BOR,FOLLOW_BOR_in_ifMetaSql1162); 
					metaAndOr = new SqlMetaAndOr(SqlMetaAndOr.Type.OR);
					pushFollow(FOLLOW_ifSql_in_ifMetaSql1168);
					metaIfItem2=ifSql(null);
					state._fsp--;

					if(!meta_stack.peek().skip) metaAndOr.addElement(metaIfItem2);
					// org/sqlproc/engine/impl/SqlProcessor.g:331:3: ( BOR metaIfItem2= ifSql[null] )*
					loop25:
					while (true) {
						int alt25=2;
						int LA25_0 = input.LA(1);
						if ( (LA25_0==BOR) ) {
							alt25=1;
						}

						switch (alt25) {
						case 1 :
							// org/sqlproc/engine/impl/SqlProcessor.g:331:4: BOR metaIfItem2= ifSql[null]
							{
							match(input,BOR,FOLLOW_BOR_in_ifMetaSql1177); 
							pushFollow(FOLLOW_ifSql_in_ifMetaSql1181);
							metaIfItem2=ifSql(null);
							state._fsp--;

							if(!meta_stack.peek().skip) metaAndOr.addElement(metaIfItem2);
							}
							break;

						default :
							break loop25;
						}
					}

					if(!meta_stack.peek().skip) metaIfItem.addElement(metaAndOr);
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "ifMetaSql"



	// $ANTLR start "ifSqlCond"
	// org/sqlproc/engine/impl/SqlProcessor.g:334:1: ifSqlCond returns [SqlMetaLogExpr metaLogExpr] : ( WS )* ifSqlBool[metaLogExpr] ( WS )* ( ( AND | OR ) ( WS )* ifSqlBool[metaLogExpr] ( WS )* )* ;
	public final SqlMetaLogExpr ifSqlCond() throws RecognitionException {
		SqlMetaLogExpr metaLogExpr = null;


		metaLogExpr = new SqlMetaLogExpr();
		try {
			// org/sqlproc/engine/impl/SqlProcessor.g:336:2: ( ( WS )* ifSqlBool[metaLogExpr] ( WS )* ( ( AND | OR ) ( WS )* ifSqlBool[metaLogExpr] ( WS )* )* )
			// org/sqlproc/engine/impl/SqlProcessor.g:337:2: ( WS )* ifSqlBool[metaLogExpr] ( WS )* ( ( AND | OR ) ( WS )* ifSqlBool[metaLogExpr] ( WS )* )*
			{
			// org/sqlproc/engine/impl/SqlProcessor.g:337:2: ( WS )*
			loop27:
			while (true) {
				int alt27=2;
				int LA27_0 = input.LA(1);
				if ( (LA27_0==WS) ) {
					alt27=1;
				}

				switch (alt27) {
				case 1 :
					// org/sqlproc/engine/impl/SqlProcessor.g:337:2: WS
					{
					match(input,WS,FOLLOW_WS_in_ifSqlCond1208); 
					}
					break;

				default :
					break loop27;
				}
			}

			pushFollow(FOLLOW_ifSqlBool_in_ifSqlCond1211);
			ifSqlBool(metaLogExpr);
			state._fsp--;

			// org/sqlproc/engine/impl/SqlProcessor.g:337:29: ( WS )*
			loop28:
			while (true) {
				int alt28=2;
				int LA28_0 = input.LA(1);
				if ( (LA28_0==WS) ) {
					alt28=1;
				}

				switch (alt28) {
				case 1 :
					// org/sqlproc/engine/impl/SqlProcessor.g:337:29: WS
					{
					match(input,WS,FOLLOW_WS_in_ifSqlCond1214); 
					}
					break;

				default :
					break loop28;
				}
			}

			// org/sqlproc/engine/impl/SqlProcessor.g:337:33: ( ( AND | OR ) ( WS )* ifSqlBool[metaLogExpr] ( WS )* )*
			loop32:
			while (true) {
				int alt32=2;
				int LA32_0 = input.LA(1);
				if ( (LA32_0==AND||LA32_0==OR) ) {
					alt32=1;
				}

				switch (alt32) {
				case 1 :
					// org/sqlproc/engine/impl/SqlProcessor.g:337:34: ( AND | OR ) ( WS )* ifSqlBool[metaLogExpr] ( WS )*
					{
					// org/sqlproc/engine/impl/SqlProcessor.g:337:34: ( AND | OR )
					int alt29=2;
					int LA29_0 = input.LA(1);
					if ( (LA29_0==AND) ) {
						alt29=1;
					}
					else if ( (LA29_0==OR) ) {
						alt29=2;
					}

					else {
						NoViableAltException nvae =
							new NoViableAltException("", 29, 0, input);
						throw nvae;
					}

					switch (alt29) {
						case 1 :
							// org/sqlproc/engine/impl/SqlProcessor.g:337:35: AND
							{
							match(input,AND,FOLLOW_AND_in_ifSqlCond1219); 
							if(!meta_stack.peek().skip) addOperator(metaLogExpr,true);
							}
							break;
						case 2 :
							// org/sqlproc/engine/impl/SqlProcessor.g:337:91: OR
							{
							match(input,OR,FOLLOW_OR_in_ifSqlCond1225); 
							if(!meta_stack.peek().skip) addOperator(metaLogExpr,false);
							}
							break;

					}

					// org/sqlproc/engine/impl/SqlProcessor.g:337:146: ( WS )*
					loop30:
					while (true) {
						int alt30=2;
						int LA30_0 = input.LA(1);
						if ( (LA30_0==WS) ) {
							alt30=1;
						}

						switch (alt30) {
						case 1 :
							// org/sqlproc/engine/impl/SqlProcessor.g:337:146: WS
							{
							match(input,WS,FOLLOW_WS_in_ifSqlCond1230); 
							}
							break;

						default :
							break loop30;
						}
					}

					pushFollow(FOLLOW_ifSqlBool_in_ifSqlCond1235);
					ifSqlBool(metaLogExpr);
					state._fsp--;

					// org/sqlproc/engine/impl/SqlProcessor.g:338:26: ( WS )*
					loop31:
					while (true) {
						int alt31=2;
						int LA31_0 = input.LA(1);
						if ( (LA31_0==WS) ) {
							alt31=1;
						}

						switch (alt31) {
						case 1 :
							// org/sqlproc/engine/impl/SqlProcessor.g:338:26: WS
							{
							match(input,WS,FOLLOW_WS_in_ifSqlCond1238); 
							}
							break;

						default :
							break loop31;
						}
					}

					}
					break;

				default :
					break loop32;
				}
			}

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return metaLogExpr;
	}
	// $ANTLR end "ifSqlCond"



	// $ANTLR start "ifSqlBool"
	// org/sqlproc/engine/impl/SqlProcessor.g:341:1: ifSqlBool[SqlMetaLogExpr metaLogExpr] : ( (not= NOT )? COLON ident= identifier | (not= NOT )? STRING cnst= constant | (not= NOT )? LPAREN newMetaLogExpr= ifSqlCond RPAREN );
	public final void ifSqlBool(SqlMetaLogExpr metaLogExpr) throws RecognitionException {
		Token not=null;
		SqlMetaIdent ident =null;
		SqlMetaConst cnst =null;
		SqlMetaLogExpr newMetaLogExpr =null;

		try {
			// org/sqlproc/engine/impl/SqlProcessor.g:342:2: ( (not= NOT )? COLON ident= identifier | (not= NOT )? STRING cnst= constant | (not= NOT )? LPAREN newMetaLogExpr= ifSqlCond RPAREN )
			int alt36=3;
			switch ( input.LA(1) ) {
			case NOT:
				{
				switch ( input.LA(2) ) {
				case COLON:
					{
					alt36=1;
					}
					break;
				case STRING:
					{
					alt36=2;
					}
					break;
				case LPAREN:
					{
					alt36=3;
					}
					break;
				default:
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 36, 1, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}
				}
				break;
			case COLON:
				{
				alt36=1;
				}
				break;
			case STRING:
				{
				alt36=2;
				}
				break;
			case LPAREN:
				{
				alt36=3;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 36, 0, input);
				throw nvae;
			}
			switch (alt36) {
				case 1 :
					// org/sqlproc/engine/impl/SqlProcessor.g:343:2: (not= NOT )? COLON ident= identifier
					{
					// org/sqlproc/engine/impl/SqlProcessor.g:343:5: (not= NOT )?
					int alt33=2;
					int LA33_0 = input.LA(1);
					if ( (LA33_0==NOT) ) {
						alt33=1;
					}
					switch (alt33) {
						case 1 :
							// org/sqlproc/engine/impl/SqlProcessor.g:343:5: not= NOT
							{
							not=(Token)match(input,NOT,FOLLOW_NOT_in_ifSqlBool1258); 
							}
							break;

					}

					match(input,COLON,FOLLOW_COLON_in_ifSqlBool1261); 
					pushFollow(FOLLOW_identifier_in_ifSqlBool1265);
					ident=identifier();
					state._fsp--;

					if(!meta_stack.peek().skip) {ident.setNot(not!=null); addIdent(metaLogExpr, ident, meta_stack.peek().text);}
					}
					break;
				case 2 :
					// org/sqlproc/engine/impl/SqlProcessor.g:344:4: (not= NOT )? STRING cnst= constant
					{
					// org/sqlproc/engine/impl/SqlProcessor.g:344:7: (not= NOT )?
					int alt34=2;
					int LA34_0 = input.LA(1);
					if ( (LA34_0==NOT) ) {
						alt34=1;
					}
					switch (alt34) {
						case 1 :
							// org/sqlproc/engine/impl/SqlProcessor.g:344:7: not= NOT
							{
							not=(Token)match(input,NOT,FOLLOW_NOT_in_ifSqlBool1274); 
							}
							break;

					}

					match(input,STRING,FOLLOW_STRING_in_ifSqlBool1277); 
					pushFollow(FOLLOW_constant_in_ifSqlBool1281);
					cnst=constant();
					state._fsp--;

					if(!meta_stack.peek().skip) {cnst.setNot(not!=null); addConstant(metaLogExpr, cnst, meta_stack.peek().text);}
					}
					break;
				case 3 :
					// org/sqlproc/engine/impl/SqlProcessor.g:345:4: (not= NOT )? LPAREN newMetaLogExpr= ifSqlCond RPAREN
					{
					// org/sqlproc/engine/impl/SqlProcessor.g:345:7: (not= NOT )?
					int alt35=2;
					int LA35_0 = input.LA(1);
					if ( (LA35_0==NOT) ) {
						alt35=1;
					}
					switch (alt35) {
						case 1 :
							// org/sqlproc/engine/impl/SqlProcessor.g:345:7: not= NOT
							{
							not=(Token)match(input,NOT,FOLLOW_NOT_in_ifSqlBool1290); 
							}
							break;

					}

					match(input,LPAREN,FOLLOW_LPAREN_in_ifSqlBool1293); 
					pushFollow(FOLLOW_ifSqlCond_in_ifSqlBool1297);
					newMetaLogExpr=ifSqlCond();
					state._fsp--;

					match(input,RPAREN,FOLLOW_RPAREN_in_ifSqlBool1299); 
					if(!meta_stack.peek().skip) metaLogExpr.addElement(newMetaLogExpr);
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "ifSqlBool"



	// $ANTLR start "ordSql"
	// org/sqlproc/engine/impl/SqlProcessor.g:348:1: ordSql[SqlMetaOrd ord] : ( ordSqlFragment[ord] )+ ;
	public final void ordSql(SqlMetaOrd ord) throws RecognitionException {
		try {
			// org/sqlproc/engine/impl/SqlProcessor.g:350:3: ( ( ordSqlFragment[ord] )+ )
			// org/sqlproc/engine/impl/SqlProcessor.g:351:3: ( ordSqlFragment[ord] )+
			{
			// org/sqlproc/engine/impl/SqlProcessor.g:351:3: ( ordSqlFragment[ord] )+
			int cnt37=0;
			loop37:
			while (true) {
				int alt37=2;
				int LA37_0 = input.LA(1);
				if ( ((LA37_0 >= AND && LA37_0 <= QUESTI)||(LA37_0 >= REST && LA37_0 <= WS)) ) {
					alt37=1;
				}

				switch (alt37) {
				case 1 :
					// org/sqlproc/engine/impl/SqlProcessor.g:351:4: ordSqlFragment[ord]
					{
					pushFollow(FOLLOW_ordSqlFragment_in_ordSql1324);
					ordSqlFragment(ord);
					state._fsp--;

					}
					break;

				default :
					if ( cnt37 >= 1 ) break loop37;
					EarlyExitException eee = new EarlyExitException(37, input);
					throw eee;
				}
				cnt37++;
			}

			}

			if(!meta_stack.peek().skip) addText(ord, meta_stack.peek().text);
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "ordSql"



	// $ANTLR start "ordSqlFragment"
	// org/sqlproc/engine/impl/SqlProcessor.g:354:1: ordSqlFragment[SqlMetaOrd ord] : (~ ( COLON | STRING | PERCENT | RBRACE ) | COLON ident= identifier | STRING cnst= constant | PERCENT dbcol= dbcolumn );
	public final void ordSqlFragment(SqlMetaOrd ord) throws RecognitionException {
		SqlMetaIdent ident =null;
		SqlMetaConst cnst =null;
		SqlDatabaseColumn dbcol =null;

		try {
			// org/sqlproc/engine/impl/SqlProcessor.g:356:3: (~ ( COLON | STRING | PERCENT | RBRACE ) | COLON ident= identifier | STRING cnst= constant | PERCENT dbcol= dbcolumn )
			int alt38=4;
			switch ( input.LA(1) ) {
			case AND:
			case AT:
			case BAND:
			case BOR:
			case CARET:
			case COMMA:
			case DIGIT:
			case DOT:
			case EQUALS:
			case ESC_AT:
			case ESC_BOR:
			case ESC_CHAR:
			case ESC_COLON:
			case ESC_DOT:
			case ESC_HASH:
			case ESC_LBRACE:
			case ESC_PERCENT:
			case ESC_RBRACE:
			case ESC_SEMICOLON:
			case ESC_SLASH:
			case ESC_STRING:
			case HASH:
			case IDENT:
			case IDENT_DOT:
			case LBRACE:
			case LESS_THAN:
			case LPAREN:
			case MAPPING:
			case MINUS:
			case ML_COMMENT:
			case MORE_THAN:
			case NOT:
			case NUMBER:
			case OPTION:
			case OR:
			case PLUS:
			case QUESTI:
			case REST:
			case RPAREN:
			case SEMICOLON:
			case SL_COMMENT:
			case STATEMENT:
			case WS:
				{
				alt38=1;
				}
				break;
			case COLON:
				{
				alt38=2;
				}
				break;
			case STRING:
				{
				alt38=3;
				}
				break;
			case PERCENT:
				{
				alt38=4;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 38, 0, input);
				throw nvae;
			}
			switch (alt38) {
				case 1 :
					// org/sqlproc/engine/impl/SqlProcessor.g:357:2: ~ ( COLON | STRING | PERCENT | RBRACE )
					{
					if ( (input.LA(1) >= AND && input.LA(1) <= CARET)||(input.LA(1) >= COMMA && input.LA(1) <= OR)||(input.LA(1) >= PLUS && input.LA(1) <= QUESTI)||(input.LA(1) >= REST && input.LA(1) <= STATEMENT)||input.LA(1)==WS ) {
						input.consume();
						state.errorRecovery=false;
					}
					else {
						MismatchedSetException mse = new MismatchedSetException(null,input);
						throw mse;
					}
					if(!meta_stack.peek().skip) add(meta_stack.peek().text);
					}
					break;
				case 2 :
					// org/sqlproc/engine/impl/SqlProcessor.g:359:4: COLON ident= identifier
					{
					match(input,COLON,FOLLOW_COLON_in_ordSqlFragment1375); 
					pushFollow(FOLLOW_identifier_in_ordSqlFragment1379);
					ident=identifier();
					state._fsp--;

					if(!meta_stack.peek().skip) addIdent(ord, ident, meta_stack.peek().text);
					}
					break;
				case 3 :
					// org/sqlproc/engine/impl/SqlProcessor.g:361:4: STRING cnst= constant
					{
					match(input,STRING,FOLLOW_STRING_in_ordSqlFragment1389); 
					pushFollow(FOLLOW_constant_in_ordSqlFragment1393);
					cnst=constant();
					state._fsp--;

					if(!meta_stack.peek().skip) addConstant(ord, cnst, meta_stack.peek().text);
					}
					break;
				case 4 :
					// org/sqlproc/engine/impl/SqlProcessor.g:363:4: PERCENT dbcol= dbcolumn
					{
					match(input,PERCENT,FOLLOW_PERCENT_in_ordSqlFragment1402); 
					pushFollow(FOLLOW_dbcolumn_in_ordSqlFragment1406);
					dbcol=dbcolumn();
					state._fsp--;

					if(!meta_stack.peek().skip) addDatabaseColumn(ord, dbcol, meta_stack.peek().text);
					}
					break;

			}
			if(!meta_stack.peek().skip) addText(ord, meta_stack.peek().text);
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "ordSqlFragment"



	// $ANTLR start "column"
	// org/sqlproc/engine/impl/SqlProcessor.g:379:1: column returns [SqlMappingItem result] : (name= IDENT_DOT |name= IDENT |name= NUMBER ) ( options {greedy=true; } : LPAREN (value= IDENT |value= NUMBER ) ( options {greedy=true; } : COMMA (value= IDENT |value= NUMBER ) )* RPAREN )? ( options {greedy=true; } : (name= IDENT_DOT |name= IDENT |name= NUMBER ) ( options {greedy=true; } : LPAREN (value= IDENT |value= NUMBER ) ( options {greedy=true; } : COMMA (value= IDENT |value= NUMBER ) )* RPAREN )? )* ;
	public final SqlMappingItem column() throws RecognitionException {
		SqlMappingItem result = null;


		Token name=null;
		Token value=null;

		result = null; String sname; Map<String, List<String>> modifiers = new HashMap<String, List<String>>(); 
		try {
			// org/sqlproc/engine/impl/SqlProcessor.g:382:2: ( (name= IDENT_DOT |name= IDENT |name= NUMBER ) ( options {greedy=true; } : LPAREN (value= IDENT |value= NUMBER ) ( options {greedy=true; } : COMMA (value= IDENT |value= NUMBER ) )* RPAREN )? ( options {greedy=true; } : (name= IDENT_DOT |name= IDENT |name= NUMBER ) ( options {greedy=true; } : LPAREN (value= IDENT |value= NUMBER ) ( options {greedy=true; } : COMMA (value= IDENT |value= NUMBER ) )* RPAREN )? )* )
			// org/sqlproc/engine/impl/SqlProcessor.g:383:2: (name= IDENT_DOT |name= IDENT |name= NUMBER ) ( options {greedy=true; } : LPAREN (value= IDENT |value= NUMBER ) ( options {greedy=true; } : COMMA (value= IDENT |value= NUMBER ) )* RPAREN )? ( options {greedy=true; } : (name= IDENT_DOT |name= IDENT |name= NUMBER ) ( options {greedy=true; } : LPAREN (value= IDENT |value= NUMBER ) ( options {greedy=true; } : COMMA (value= IDENT |value= NUMBER ) )* RPAREN )? )*
			{
			// org/sqlproc/engine/impl/SqlProcessor.g:383:2: (name= IDENT_DOT |name= IDENT |name= NUMBER )
			int alt39=3;
			switch ( input.LA(1) ) {
			case IDENT_DOT:
				{
				alt39=1;
				}
				break;
			case IDENT:
				{
				alt39=2;
				}
				break;
			case NUMBER:
				{
				alt39=3;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 39, 0, input);
				throw nvae;
			}
			switch (alt39) {
				case 1 :
					// org/sqlproc/engine/impl/SqlProcessor.g:383:3: name= IDENT_DOT
					{
					name=(Token)match(input,IDENT_DOT,FOLLOW_IDENT_DOT_in_column1443); 
					}
					break;
				case 2 :
					// org/sqlproc/engine/impl/SqlProcessor.g:383:20: name= IDENT
					{
					name=(Token)match(input,IDENT,FOLLOW_IDENT_in_column1449); 
					}
					break;
				case 3 :
					// org/sqlproc/engine/impl/SqlProcessor.g:383:33: name= NUMBER
					{
					name=(Token)match(input,NUMBER,FOLLOW_NUMBER_in_column1455); 
					}
					break;

			}

			sname =  (name!=null?name.getText():null); 
			// org/sqlproc/engine/impl/SqlProcessor.g:384:2: ( options {greedy=true; } : LPAREN (value= IDENT |value= NUMBER ) ( options {greedy=true; } : COMMA (value= IDENT |value= NUMBER ) )* RPAREN )?
			int alt43=2;
			alt43 = dfa43.predict(input);
			switch (alt43) {
				case 1 :
					// org/sqlproc/engine/impl/SqlProcessor.g:384:28: LPAREN (value= IDENT |value= NUMBER ) ( options {greedy=true; } : COMMA (value= IDENT |value= NUMBER ) )* RPAREN
					{
					match(input,LPAREN,FOLLOW_LPAREN_in_column1471); 
					// org/sqlproc/engine/impl/SqlProcessor.g:384:35: (value= IDENT |value= NUMBER )
					int alt40=2;
					int LA40_0 = input.LA(1);
					if ( (LA40_0==IDENT) ) {
						alt40=1;
					}
					else if ( (LA40_0==NUMBER) ) {
						alt40=2;
					}

					else {
						NoViableAltException nvae =
							new NoViableAltException("", 40, 0, input);
						throw nvae;
					}

					switch (alt40) {
						case 1 :
							// org/sqlproc/engine/impl/SqlProcessor.g:384:36: value= IDENT
							{
							value=(Token)match(input,IDENT,FOLLOW_IDENT_in_column1476); 
							}
							break;
						case 2 :
							// org/sqlproc/engine/impl/SqlProcessor.g:384:50: value= NUMBER
							{
							value=(Token)match(input,NUMBER,FOLLOW_NUMBER_in_column1482); 
							}
							break;

					}

					 modifiers.put(sname, new ArrayList<String>()); modifiers.get(sname).add((value!=null?value.getText():null)); 
					// org/sqlproc/engine/impl/SqlProcessor.g:385:3: ( options {greedy=true; } : COMMA (value= IDENT |value= NUMBER ) )*
					loop42:
					while (true) {
						int alt42=2;
						int LA42_0 = input.LA(1);
						if ( (LA42_0==COMMA) ) {
							alt42=1;
						}

						switch (alt42) {
						case 1 :
							// org/sqlproc/engine/impl/SqlProcessor.g:385:29: COMMA (value= IDENT |value= NUMBER )
							{
							match(input,COMMA,FOLLOW_COMMA_in_column1499); 
							// org/sqlproc/engine/impl/SqlProcessor.g:385:35: (value= IDENT |value= NUMBER )
							int alt41=2;
							int LA41_0 = input.LA(1);
							if ( (LA41_0==IDENT) ) {
								alt41=1;
							}
							else if ( (LA41_0==NUMBER) ) {
								alt41=2;
							}

							else {
								NoViableAltException nvae =
									new NoViableAltException("", 41, 0, input);
								throw nvae;
							}

							switch (alt41) {
								case 1 :
									// org/sqlproc/engine/impl/SqlProcessor.g:385:36: value= IDENT
									{
									value=(Token)match(input,IDENT,FOLLOW_IDENT_in_column1504); 
									}
									break;
								case 2 :
									// org/sqlproc/engine/impl/SqlProcessor.g:385:50: value= NUMBER
									{
									value=(Token)match(input,NUMBER,FOLLOW_NUMBER_in_column1510); 
									}
									break;

							}

							 modifiers.get(sname).add((value!=null?value.getText():null)); 
							}
							break;

						default :
							break loop42;
						}
					}

					match(input,RPAREN,FOLLOW_RPAREN_in_column1520); 
					}
					break;

			}

			// org/sqlproc/engine/impl/SqlProcessor.g:388:2: ( options {greedy=true; } : (name= IDENT_DOT |name= IDENT |name= NUMBER ) ( options {greedy=true; } : LPAREN (value= IDENT |value= NUMBER ) ( options {greedy=true; } : COMMA (value= IDENT |value= NUMBER ) )* RPAREN )? )*
			loop49:
			while (true) {
				int alt49=2;
				switch ( input.LA(1) ) {
				case IDENT_DOT:
					{
					alt49=1;
					}
					break;
				case IDENT:
					{
					alt49=1;
					}
					break;
				case NUMBER:
					{
					alt49=1;
					}
					break;
				}
				switch (alt49) {
				case 1 :
					// org/sqlproc/engine/impl/SqlProcessor.g:389:4: (name= IDENT_DOT |name= IDENT |name= NUMBER ) ( options {greedy=true; } : LPAREN (value= IDENT |value= NUMBER ) ( options {greedy=true; } : COMMA (value= IDENT |value= NUMBER ) )* RPAREN )?
					{
					// org/sqlproc/engine/impl/SqlProcessor.g:389:4: (name= IDENT_DOT |name= IDENT |name= NUMBER )
					int alt44=3;
					switch ( input.LA(1) ) {
					case IDENT_DOT:
						{
						alt44=1;
						}
						break;
					case IDENT:
						{
						alt44=2;
						}
						break;
					case NUMBER:
						{
						alt44=3;
						}
						break;
					default:
						NoViableAltException nvae =
							new NoViableAltException("", 44, 0, input);
						throw nvae;
					}
					switch (alt44) {
						case 1 :
							// org/sqlproc/engine/impl/SqlProcessor.g:389:5: name= IDENT_DOT
							{
							name=(Token)match(input,IDENT_DOT,FOLLOW_IDENT_DOT_in_column1544); 
							}
							break;
						case 2 :
							// org/sqlproc/engine/impl/SqlProcessor.g:389:22: name= IDENT
							{
							name=(Token)match(input,IDENT,FOLLOW_IDENT_in_column1550); 
							}
							break;
						case 3 :
							// org/sqlproc/engine/impl/SqlProcessor.g:389:35: name= NUMBER
							{
							name=(Token)match(input,NUMBER,FOLLOW_NUMBER_in_column1556); 
							}
							break;

					}

					sname = sname + "." + (name!=null?name.getText():null); 
					// org/sqlproc/engine/impl/SqlProcessor.g:390:3: ( options {greedy=true; } : LPAREN (value= IDENT |value= NUMBER ) ( options {greedy=true; } : COMMA (value= IDENT |value= NUMBER ) )* RPAREN )?
					int alt48=2;
					alt48 = dfa48.predict(input);
					switch (alt48) {
						case 1 :
							// org/sqlproc/engine/impl/SqlProcessor.g:390:29: LPAREN (value= IDENT |value= NUMBER ) ( options {greedy=true; } : COMMA (value= IDENT |value= NUMBER ) )* RPAREN
							{
							match(input,LPAREN,FOLLOW_LPAREN_in_column1573); 
							// org/sqlproc/engine/impl/SqlProcessor.g:390:36: (value= IDENT |value= NUMBER )
							int alt45=2;
							int LA45_0 = input.LA(1);
							if ( (LA45_0==IDENT) ) {
								alt45=1;
							}
							else if ( (LA45_0==NUMBER) ) {
								alt45=2;
							}

							else {
								NoViableAltException nvae =
									new NoViableAltException("", 45, 0, input);
								throw nvae;
							}

							switch (alt45) {
								case 1 :
									// org/sqlproc/engine/impl/SqlProcessor.g:390:37: value= IDENT
									{
									value=(Token)match(input,IDENT,FOLLOW_IDENT_in_column1578); 
									}
									break;
								case 2 :
									// org/sqlproc/engine/impl/SqlProcessor.g:390:51: value= NUMBER
									{
									value=(Token)match(input,NUMBER,FOLLOW_NUMBER_in_column1584); 
									}
									break;

							}

							 modifiers.put(sname, new ArrayList<String>()); modifiers.get(sname).add((value!=null?value.getText():null)); 
							// org/sqlproc/engine/impl/SqlProcessor.g:391:4: ( options {greedy=true; } : COMMA (value= IDENT |value= NUMBER ) )*
							loop47:
							while (true) {
								int alt47=2;
								int LA47_0 = input.LA(1);
								if ( (LA47_0==COMMA) ) {
									alt47=1;
								}

								switch (alt47) {
								case 1 :
									// org/sqlproc/engine/impl/SqlProcessor.g:391:30: COMMA (value= IDENT |value= NUMBER )
									{
									match(input,COMMA,FOLLOW_COMMA_in_column1602); 
									// org/sqlproc/engine/impl/SqlProcessor.g:391:36: (value= IDENT |value= NUMBER )
									int alt46=2;
									int LA46_0 = input.LA(1);
									if ( (LA46_0==IDENT) ) {
										alt46=1;
									}
									else if ( (LA46_0==NUMBER) ) {
										alt46=2;
									}

									else {
										NoViableAltException nvae =
											new NoViableAltException("", 46, 0, input);
										throw nvae;
									}

									switch (alt46) {
										case 1 :
											// org/sqlproc/engine/impl/SqlProcessor.g:391:37: value= IDENT
											{
											value=(Token)match(input,IDENT,FOLLOW_IDENT_in_column1607); 
											}
											break;
										case 2 :
											// org/sqlproc/engine/impl/SqlProcessor.g:391:51: value= NUMBER
											{
											value=(Token)match(input,NUMBER,FOLLOW_NUMBER_in_column1613); 
											}
											break;

									}

									 modifiers.get(sname).add((value!=null?value.getText():null)); 
									}
									break;

								default :
									break loop47;
								}
							}

							match(input,RPAREN,FOLLOW_RPAREN_in_column1624); 
							}
							break;

					}

					}
					break;

				default :
					break loop49;
				}
			}

			}

			if(!meta_stack.peek().skip) result = newColumn(sname); if(!meta_stack.peek().skip) for (String n : modifiers.keySet()) for (String m : modifiers.get(n)) addModifier(meta_stack.peek().typeFactory, result, m, n); 
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return result;
	}
	// $ANTLR end "column"



	// $ANTLR start "constant"
	// org/sqlproc/engine/impl/SqlProcessor.g:397:1: constant returns [SqlMetaConst result] : (caseCnst= PLUS |caseCnst= MINUS )? (cnst= IDENT_DOT |cnst= IDENT ) ( options {greedy=true; } : LPAREN (not= NOT )? (value= IDENT |value= NUMBER ) ( options {greedy=true; } : COMMA (not= NOT )? (value= IDENT |value= NUMBER ) )* RPAREN )? ;
	public final SqlMetaConst constant() throws RecognitionException {
		SqlMetaConst result = null;


		Token caseCnst=null;
		Token cnst=null;
		Token not=null;
		Token value=null;

		result = null;
		try {
			// org/sqlproc/engine/impl/SqlProcessor.g:399:2: ( (caseCnst= PLUS |caseCnst= MINUS )? (cnst= IDENT_DOT |cnst= IDENT ) ( options {greedy=true; } : LPAREN (not= NOT )? (value= IDENT |value= NUMBER ) ( options {greedy=true; } : COMMA (not= NOT )? (value= IDENT |value= NUMBER ) )* RPAREN )? )
			// org/sqlproc/engine/impl/SqlProcessor.g:400:2: (caseCnst= PLUS |caseCnst= MINUS )? (cnst= IDENT_DOT |cnst= IDENT ) ( options {greedy=true; } : LPAREN (not= NOT )? (value= IDENT |value= NUMBER ) ( options {greedy=true; } : COMMA (not= NOT )? (value= IDENT |value= NUMBER ) )* RPAREN )?
			{
			// org/sqlproc/engine/impl/SqlProcessor.g:400:2: (caseCnst= PLUS |caseCnst= MINUS )?
			int alt50=3;
			int LA50_0 = input.LA(1);
			if ( (LA50_0==PLUS) ) {
				alt50=1;
			}
			else if ( (LA50_0==MINUS) ) {
				alt50=2;
			}
			switch (alt50) {
				case 1 :
					// org/sqlproc/engine/impl/SqlProcessor.g:400:3: caseCnst= PLUS
					{
					caseCnst=(Token)match(input,PLUS,FOLLOW_PLUS_in_constant1658); 
					}
					break;
				case 2 :
					// org/sqlproc/engine/impl/SqlProcessor.g:400:19: caseCnst= MINUS
					{
					caseCnst=(Token)match(input,MINUS,FOLLOW_MINUS_in_constant1664); 
					}
					break;

			}

			// org/sqlproc/engine/impl/SqlProcessor.g:400:36: (cnst= IDENT_DOT |cnst= IDENT )
			int alt51=2;
			int LA51_0 = input.LA(1);
			if ( (LA51_0==IDENT_DOT) ) {
				alt51=1;
			}
			else if ( (LA51_0==IDENT) ) {
				alt51=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 51, 0, input);
				throw nvae;
			}

			switch (alt51) {
				case 1 :
					// org/sqlproc/engine/impl/SqlProcessor.g:400:37: cnst= IDENT_DOT
					{
					cnst=(Token)match(input,IDENT_DOT,FOLLOW_IDENT_DOT_in_constant1671); 
					}
					break;
				case 2 :
					// org/sqlproc/engine/impl/SqlProcessor.g:400:54: cnst= IDENT
					{
					cnst=(Token)match(input,IDENT,FOLLOW_IDENT_in_constant1677); 
					}
					break;

			}

			if(!meta_stack.peek().skip) result = newConstant(cnst, caseCnst);
			// org/sqlproc/engine/impl/SqlProcessor.g:401:2: ( options {greedy=true; } : LPAREN (not= NOT )? (value= IDENT |value= NUMBER ) ( options {greedy=true; } : COMMA (not= NOT )? (value= IDENT |value= NUMBER ) )* RPAREN )?
			int alt57=2;
			alt57 = dfa57.predict(input);
			switch (alt57) {
				case 1 :
					// org/sqlproc/engine/impl/SqlProcessor.g:401:28: LPAREN (not= NOT )? (value= IDENT |value= NUMBER ) ( options {greedy=true; } : COMMA (not= NOT )? (value= IDENT |value= NUMBER ) )* RPAREN
					{
					match(input,LPAREN,FOLLOW_LPAREN_in_constant1693); 
					// org/sqlproc/engine/impl/SqlProcessor.g:401:38: (not= NOT )?
					int alt52=2;
					int LA52_0 = input.LA(1);
					if ( (LA52_0==NOT) ) {
						alt52=1;
					}
					switch (alt52) {
						case 1 :
							// org/sqlproc/engine/impl/SqlProcessor.g:401:38: not= NOT
							{
							not=(Token)match(input,NOT,FOLLOW_NOT_in_constant1697); 
							}
							break;

					}

					// org/sqlproc/engine/impl/SqlProcessor.g:401:44: (value= IDENT |value= NUMBER )
					int alt53=2;
					int LA53_0 = input.LA(1);
					if ( (LA53_0==IDENT) ) {
						alt53=1;
					}
					else if ( (LA53_0==NUMBER) ) {
						alt53=2;
					}

					else {
						NoViableAltException nvae =
							new NoViableAltException("", 53, 0, input);
						throw nvae;
					}

					switch (alt53) {
						case 1 :
							// org/sqlproc/engine/impl/SqlProcessor.g:401:45: value= IDENT
							{
							value=(Token)match(input,IDENT,FOLLOW_IDENT_in_constant1703); 
							}
							break;
						case 2 :
							// org/sqlproc/engine/impl/SqlProcessor.g:401:59: value= NUMBER
							{
							value=(Token)match(input,NUMBER,FOLLOW_NUMBER_in_constant1709); 
							}
							break;

					}

					 if(!meta_stack.peek().skip) addModifier(meta_stack.peek().typeFactory, result, (value!=null?value.getText():null), not); 
					// org/sqlproc/engine/impl/SqlProcessor.g:402:3: ( options {greedy=true; } : COMMA (not= NOT )? (value= IDENT |value= NUMBER ) )*
					loop56:
					while (true) {
						int alt56=2;
						int LA56_0 = input.LA(1);
						if ( (LA56_0==COMMA) ) {
							alt56=1;
						}

						switch (alt56) {
						case 1 :
							// org/sqlproc/engine/impl/SqlProcessor.g:402:29: COMMA (not= NOT )? (value= IDENT |value= NUMBER )
							{
							match(input,COMMA,FOLLOW_COMMA_in_constant1726); 
							// org/sqlproc/engine/impl/SqlProcessor.g:402:38: (not= NOT )?
							int alt54=2;
							int LA54_0 = input.LA(1);
							if ( (LA54_0==NOT) ) {
								alt54=1;
							}
							switch (alt54) {
								case 1 :
									// org/sqlproc/engine/impl/SqlProcessor.g:402:38: not= NOT
									{
									not=(Token)match(input,NOT,FOLLOW_NOT_in_constant1730); 
									}
									break;

							}

							// org/sqlproc/engine/impl/SqlProcessor.g:402:44: (value= IDENT |value= NUMBER )
							int alt55=2;
							int LA55_0 = input.LA(1);
							if ( (LA55_0==IDENT) ) {
								alt55=1;
							}
							else if ( (LA55_0==NUMBER) ) {
								alt55=2;
							}

							else {
								NoViableAltException nvae =
									new NoViableAltException("", 55, 0, input);
								throw nvae;
							}

							switch (alt55) {
								case 1 :
									// org/sqlproc/engine/impl/SqlProcessor.g:402:45: value= IDENT
									{
									value=(Token)match(input,IDENT,FOLLOW_IDENT_in_constant1736); 
									}
									break;
								case 2 :
									// org/sqlproc/engine/impl/SqlProcessor.g:402:59: value= NUMBER
									{
									value=(Token)match(input,NUMBER,FOLLOW_NUMBER_in_constant1742); 
									}
									break;

							}

							 if(!meta_stack.peek().skip) addModifier(meta_stack.peek().typeFactory, result, (value!=null?value.getText():null), not); 
							}
							break;

						default :
							break loop56;
						}
					}

					match(input,RPAREN,FOLLOW_RPAREN_in_constant1752); 
					}
					break;

			}

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return result;
	}
	// $ANTLR end "constant"



	// $ANTLR start "identifier"
	// org/sqlproc/engine/impl/SqlProcessor.g:407:1: identifier returns [SqlMetaIdent result] : (modeIdent= EQUALS |modeIdent= LESS_THAN |modeIdent= MORE_THAN )? (caseIdent= PLUS |caseIdent= MINUS )? (ident= IDENT_DOT |ident= IDENT |ident= NUMBER ) ( options {greedy=true; } : LPAREN (not= NOT )? (value= IDENT |value= NUMBER ) ( options {greedy=true; } : COMMA (not= NOT )? (value= IDENT |value= NUMBER ) )* RPAREN )? ;
	public final SqlMetaIdent identifier() throws RecognitionException {
		SqlMetaIdent result = null;


		Token modeIdent=null;
		Token caseIdent=null;
		Token ident=null;
		Token not=null;
		Token value=null;

		result = null;
		try {
			// org/sqlproc/engine/impl/SqlProcessor.g:409:2: ( (modeIdent= EQUALS |modeIdent= LESS_THAN |modeIdent= MORE_THAN )? (caseIdent= PLUS |caseIdent= MINUS )? (ident= IDENT_DOT |ident= IDENT |ident= NUMBER ) ( options {greedy=true; } : LPAREN (not= NOT )? (value= IDENT |value= NUMBER ) ( options {greedy=true; } : COMMA (not= NOT )? (value= IDENT |value= NUMBER ) )* RPAREN )? )
			// org/sqlproc/engine/impl/SqlProcessor.g:410:2: (modeIdent= EQUALS |modeIdent= LESS_THAN |modeIdent= MORE_THAN )? (caseIdent= PLUS |caseIdent= MINUS )? (ident= IDENT_DOT |ident= IDENT |ident= NUMBER ) ( options {greedy=true; } : LPAREN (not= NOT )? (value= IDENT |value= NUMBER ) ( options {greedy=true; } : COMMA (not= NOT )? (value= IDENT |value= NUMBER ) )* RPAREN )?
			{
			// org/sqlproc/engine/impl/SqlProcessor.g:410:2: (modeIdent= EQUALS |modeIdent= LESS_THAN |modeIdent= MORE_THAN )?
			int alt58=4;
			switch ( input.LA(1) ) {
				case EQUALS:
					{
					alt58=1;
					}
					break;
				case LESS_THAN:
					{
					alt58=2;
					}
					break;
				case MORE_THAN:
					{
					alt58=3;
					}
					break;
			}
			switch (alt58) {
				case 1 :
					// org/sqlproc/engine/impl/SqlProcessor.g:410:3: modeIdent= EQUALS
					{
					modeIdent=(Token)match(input,EQUALS,FOLLOW_EQUALS_in_identifier1781); 
					}
					break;
				case 2 :
					// org/sqlproc/engine/impl/SqlProcessor.g:410:22: modeIdent= LESS_THAN
					{
					modeIdent=(Token)match(input,LESS_THAN,FOLLOW_LESS_THAN_in_identifier1787); 
					}
					break;
				case 3 :
					// org/sqlproc/engine/impl/SqlProcessor.g:410:44: modeIdent= MORE_THAN
					{
					modeIdent=(Token)match(input,MORE_THAN,FOLLOW_MORE_THAN_in_identifier1793); 
					}
					break;

			}

			// org/sqlproc/engine/impl/SqlProcessor.g:410:66: (caseIdent= PLUS |caseIdent= MINUS )?
			int alt59=3;
			int LA59_0 = input.LA(1);
			if ( (LA59_0==PLUS) ) {
				alt59=1;
			}
			else if ( (LA59_0==MINUS) ) {
				alt59=2;
			}
			switch (alt59) {
				case 1 :
					// org/sqlproc/engine/impl/SqlProcessor.g:410:67: caseIdent= PLUS
					{
					caseIdent=(Token)match(input,PLUS,FOLLOW_PLUS_in_identifier1800); 
					}
					break;
				case 2 :
					// org/sqlproc/engine/impl/SqlProcessor.g:410:84: caseIdent= MINUS
					{
					caseIdent=(Token)match(input,MINUS,FOLLOW_MINUS_in_identifier1806); 
					}
					break;

			}

			// org/sqlproc/engine/impl/SqlProcessor.g:410:102: (ident= IDENT_DOT |ident= IDENT |ident= NUMBER )
			int alt60=3;
			switch ( input.LA(1) ) {
			case IDENT_DOT:
				{
				alt60=1;
				}
				break;
			case IDENT:
				{
				alt60=2;
				}
				break;
			case NUMBER:
				{
				alt60=3;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 60, 0, input);
				throw nvae;
			}
			switch (alt60) {
				case 1 :
					// org/sqlproc/engine/impl/SqlProcessor.g:410:103: ident= IDENT_DOT
					{
					ident=(Token)match(input,IDENT_DOT,FOLLOW_IDENT_DOT_in_identifier1813); 
					}
					break;
				case 2 :
					// org/sqlproc/engine/impl/SqlProcessor.g:410:121: ident= IDENT
					{
					ident=(Token)match(input,IDENT,FOLLOW_IDENT_in_identifier1819); 
					}
					break;
				case 3 :
					// org/sqlproc/engine/impl/SqlProcessor.g:410:135: ident= NUMBER
					{
					ident=(Token)match(input,NUMBER,FOLLOW_NUMBER_in_identifier1825); 
					}
					break;

			}

			if(!meta_stack.peek().skip) result = newIdent(ident, modeIdent, caseIdent);
			// org/sqlproc/engine/impl/SqlProcessor.g:411:2: ( options {greedy=true; } : LPAREN (not= NOT )? (value= IDENT |value= NUMBER ) ( options {greedy=true; } : COMMA (not= NOT )? (value= IDENT |value= NUMBER ) )* RPAREN )?
			int alt66=2;
			alt66 = dfa66.predict(input);
			switch (alt66) {
				case 1 :
					// org/sqlproc/engine/impl/SqlProcessor.g:411:28: LPAREN (not= NOT )? (value= IDENT |value= NUMBER ) ( options {greedy=true; } : COMMA (not= NOT )? (value= IDENT |value= NUMBER ) )* RPAREN
					{
					match(input,LPAREN,FOLLOW_LPAREN_in_identifier1841); 
					// org/sqlproc/engine/impl/SqlProcessor.g:411:38: (not= NOT )?
					int alt61=2;
					int LA61_0 = input.LA(1);
					if ( (LA61_0==NOT) ) {
						alt61=1;
					}
					switch (alt61) {
						case 1 :
							// org/sqlproc/engine/impl/SqlProcessor.g:411:38: not= NOT
							{
							not=(Token)match(input,NOT,FOLLOW_NOT_in_identifier1845); 
							}
							break;

					}

					// org/sqlproc/engine/impl/SqlProcessor.g:411:44: (value= IDENT |value= NUMBER )
					int alt62=2;
					int LA62_0 = input.LA(1);
					if ( (LA62_0==IDENT) ) {
						alt62=1;
					}
					else if ( (LA62_0==NUMBER) ) {
						alt62=2;
					}

					else {
						NoViableAltException nvae =
							new NoViableAltException("", 62, 0, input);
						throw nvae;
					}

					switch (alt62) {
						case 1 :
							// org/sqlproc/engine/impl/SqlProcessor.g:411:45: value= IDENT
							{
							value=(Token)match(input,IDENT,FOLLOW_IDENT_in_identifier1851); 
							}
							break;
						case 2 :
							// org/sqlproc/engine/impl/SqlProcessor.g:411:59: value= NUMBER
							{
							value=(Token)match(input,NUMBER,FOLLOW_NUMBER_in_identifier1857); 
							}
							break;

					}

					 if(!meta_stack.peek().skip) addModifier(meta_stack.peek().typeFactory, result, (value!=null?value.getText():null), not); 
					// org/sqlproc/engine/impl/SqlProcessor.g:412:3: ( options {greedy=true; } : COMMA (not= NOT )? (value= IDENT |value= NUMBER ) )*
					loop65:
					while (true) {
						int alt65=2;
						int LA65_0 = input.LA(1);
						if ( (LA65_0==COMMA) ) {
							alt65=1;
						}

						switch (alt65) {
						case 1 :
							// org/sqlproc/engine/impl/SqlProcessor.g:412:29: COMMA (not= NOT )? (value= IDENT |value= NUMBER )
							{
							match(input,COMMA,FOLLOW_COMMA_in_identifier1874); 
							// org/sqlproc/engine/impl/SqlProcessor.g:412:38: (not= NOT )?
							int alt63=2;
							int LA63_0 = input.LA(1);
							if ( (LA63_0==NOT) ) {
								alt63=1;
							}
							switch (alt63) {
								case 1 :
									// org/sqlproc/engine/impl/SqlProcessor.g:412:38: not= NOT
									{
									not=(Token)match(input,NOT,FOLLOW_NOT_in_identifier1878); 
									}
									break;

							}

							// org/sqlproc/engine/impl/SqlProcessor.g:412:44: (value= IDENT |value= NUMBER )
							int alt64=2;
							int LA64_0 = input.LA(1);
							if ( (LA64_0==IDENT) ) {
								alt64=1;
							}
							else if ( (LA64_0==NUMBER) ) {
								alt64=2;
							}

							else {
								NoViableAltException nvae =
									new NoViableAltException("", 64, 0, input);
								throw nvae;
							}

							switch (alt64) {
								case 1 :
									// org/sqlproc/engine/impl/SqlProcessor.g:412:45: value= IDENT
									{
									value=(Token)match(input,IDENT,FOLLOW_IDENT_in_identifier1884); 
									}
									break;
								case 2 :
									// org/sqlproc/engine/impl/SqlProcessor.g:412:59: value= NUMBER
									{
									value=(Token)match(input,NUMBER,FOLLOW_NUMBER_in_identifier1890); 
									}
									break;

							}

							 if(!meta_stack.peek().skip) addModifier(meta_stack.peek().typeFactory, result, (value!=null?value.getText():null), not); 
							}
							break;

						default :
							break loop65;
						}
					}

					match(input,RPAREN,FOLLOW_RPAREN_in_identifier1900); 
					}
					break;

			}

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return result;
	}
	// $ANTLR end "identifier"



	// $ANTLR start "constantOperator"
	// org/sqlproc/engine/impl/SqlProcessor.g:417:1: constantOperator returns [SqlMetaOperator result] : (ident= IDENT |ident= EQUALS ) ;
	public final SqlMetaOperator constantOperator() throws RecognitionException {
		SqlMetaOperator result = null;


		Token ident=null;

		result = null;
		try {
			// org/sqlproc/engine/impl/SqlProcessor.g:419:23: ( (ident= IDENT |ident= EQUALS ) )
			// org/sqlproc/engine/impl/SqlProcessor.g:420:24: (ident= IDENT |ident= EQUALS )
			{
			// org/sqlproc/engine/impl/SqlProcessor.g:420:24: (ident= IDENT |ident= EQUALS )
			int alt67=2;
			int LA67_0 = input.LA(1);
			if ( (LA67_0==IDENT) ) {
				alt67=1;
			}
			else if ( (LA67_0==EQUALS) ) {
				alt67=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 67, 0, input);
				throw nvae;
			}

			switch (alt67) {
				case 1 :
					// org/sqlproc/engine/impl/SqlProcessor.g:420:25: ident= IDENT
					{
					ident=(Token)match(input,IDENT,FOLLOW_IDENT_in_constantOperator1973); 
					}
					break;
				case 2 :
					// org/sqlproc/engine/impl/SqlProcessor.g:420:41: ident= EQUALS
					{
					ident=(Token)match(input,EQUALS,FOLLOW_EQUALS_in_constantOperator1981); 
					}
					break;

			}

			if(!meta_stack.peek().skip) result = newConstOperator(ident);
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return result;
	}
	// $ANTLR end "constantOperator"



	// $ANTLR start "identifierOperator"
	// org/sqlproc/engine/impl/SqlProcessor.g:423:1: identifierOperator returns [SqlMetaOperator result] : (ident= IDENT |ident= EQUALS ) ;
	public final SqlMetaOperator identifierOperator() throws RecognitionException {
		SqlMetaOperator result = null;


		Token ident=null;

		result = null;
		try {
			// org/sqlproc/engine/impl/SqlProcessor.g:425:23: ( (ident= IDENT |ident= EQUALS ) )
			// org/sqlproc/engine/impl/SqlProcessor.g:426:24: (ident= IDENT |ident= EQUALS )
			{
			// org/sqlproc/engine/impl/SqlProcessor.g:426:24: (ident= IDENT |ident= EQUALS )
			int alt68=2;
			int LA68_0 = input.LA(1);
			if ( (LA68_0==IDENT) ) {
				alt68=1;
			}
			else if ( (LA68_0==EQUALS) ) {
				alt68=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 68, 0, input);
				throw nvae;
			}

			switch (alt68) {
				case 1 :
					// org/sqlproc/engine/impl/SqlProcessor.g:426:25: ident= IDENT
					{
					ident=(Token)match(input,IDENT,FOLLOW_IDENT_in_identifierOperator2074); 
					}
					break;
				case 2 :
					// org/sqlproc/engine/impl/SqlProcessor.g:426:41: ident= EQUALS
					{
					ident=(Token)match(input,EQUALS,FOLLOW_EQUALS_in_identifierOperator2082); 
					}
					break;

			}

			if(!meta_stack.peek().skip) result = newIdentOperator(ident);
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return result;
	}
	// $ANTLR end "identifierOperator"



	// $ANTLR start "dbcolumn"
	// org/sqlproc/engine/impl/SqlProcessor.g:429:1: dbcolumn returns [SqlDatabaseColumn result] : (dbcol= IDENT_DOT |dbcol= IDENT ) ;
	public final SqlDatabaseColumn dbcolumn() throws RecognitionException {
		SqlDatabaseColumn result = null;


		Token dbcol=null;

		result = null;
		try {
			// org/sqlproc/engine/impl/SqlProcessor.g:431:2: ( (dbcol= IDENT_DOT |dbcol= IDENT ) )
			// org/sqlproc/engine/impl/SqlProcessor.g:432:2: (dbcol= IDENT_DOT |dbcol= IDENT )
			{
			// org/sqlproc/engine/impl/SqlProcessor.g:432:2: (dbcol= IDENT_DOT |dbcol= IDENT )
			int alt69=2;
			int LA69_0 = input.LA(1);
			if ( (LA69_0==IDENT_DOT) ) {
				alt69=1;
			}
			else if ( (LA69_0==IDENT) ) {
				alt69=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 69, 0, input);
				throw nvae;
			}

			switch (alt69) {
				case 1 :
					// org/sqlproc/engine/impl/SqlProcessor.g:432:3: dbcol= IDENT_DOT
					{
					dbcol=(Token)match(input,IDENT_DOT,FOLLOW_IDENT_DOT_in_dbcolumn2130); 
					}
					break;
				case 2 :
					// org/sqlproc/engine/impl/SqlProcessor.g:432:21: dbcol= IDENT
					{
					dbcol=(Token)match(input,IDENT,FOLLOW_IDENT_in_dbcolumn2136); 
					}
					break;

			}

			if(!meta_stack.peek().skip) result = newDatabaseColumn(dbcol);
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return result;
	}
	// $ANTLR end "dbcolumn"



	// $ANTLR start "dbtable"
	// org/sqlproc/engine/impl/SqlProcessor.g:435:1: dbtable returns [SqlDatabaseTable result] : (dbtab= IDENT_DOT |dbtab= IDENT ) ;
	public final SqlDatabaseTable dbtable() throws RecognitionException {
		SqlDatabaseTable result = null;


		Token dbtab=null;

		result = null;
		try {
			// org/sqlproc/engine/impl/SqlProcessor.g:437:2: ( (dbtab= IDENT_DOT |dbtab= IDENT ) )
			// org/sqlproc/engine/impl/SqlProcessor.g:438:2: (dbtab= IDENT_DOT |dbtab= IDENT )
			{
			// org/sqlproc/engine/impl/SqlProcessor.g:438:2: (dbtab= IDENT_DOT |dbtab= IDENT )
			int alt70=2;
			int LA70_0 = input.LA(1);
			if ( (LA70_0==IDENT_DOT) ) {
				alt70=1;
			}
			else if ( (LA70_0==IDENT) ) {
				alt70=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 70, 0, input);
				throw nvae;
			}

			switch (alt70) {
				case 1 :
					// org/sqlproc/engine/impl/SqlProcessor.g:438:3: dbtab= IDENT_DOT
					{
					dbtab=(Token)match(input,IDENT_DOT,FOLLOW_IDENT_DOT_in_dbtable2163); 
					}
					break;
				case 2 :
					// org/sqlproc/engine/impl/SqlProcessor.g:438:21: dbtab= IDENT
					{
					dbtab=(Token)match(input,IDENT,FOLLOW_IDENT_in_dbtable2169); 
					}
					break;

			}

			if(!meta_stack.peek().skip) result = newDatabaseTable(dbtab);
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return result;
	}
	// $ANTLR end "dbtable"


	protected static class mapping_scope {
		SqlTypeFactory typeFactory;
		boolean skip;
	}
	protected Stack<mapping_scope> mapping_stack = new Stack<mapping_scope>();


	// $ANTLR start "mapping"
	// org/sqlproc/engine/impl/SqlProcessor.g:442:1: mapping[String name, SqlTypeFactory _typeFactory, boolean _skip] returns [SqlMappingRule sqlMapping] : ( ( WS )* sqlMappingItem= mappingItem ( ( WS )+ sqlMappingItem= mappingItem )* ( WS )* ( EOF )? ) ;
	public final SqlMappingRule mapping(String name, SqlTypeFactory _typeFactory, boolean _skip) throws RecognitionException {
		mapping_stack.push(new mapping_scope());
		SqlMappingRule sqlMapping = null;


		SqlMappingItem sqlMappingItem =null;

		artifactName.push(name); sqlMapping = new SqlMappingRule();mapping_stack.peek().typeFactory =_typeFactory; mapping_stack.peek().skip =_skip;
		try {
			// org/sqlproc/engine/impl/SqlProcessor.g:446:3: ( ( ( WS )* sqlMappingItem= mappingItem ( ( WS )+ sqlMappingItem= mappingItem )* ( WS )* ( EOF )? ) )
			// org/sqlproc/engine/impl/SqlProcessor.g:447:3: ( ( WS )* sqlMappingItem= mappingItem ( ( WS )+ sqlMappingItem= mappingItem )* ( WS )* ( EOF )? )
			{
			// org/sqlproc/engine/impl/SqlProcessor.g:447:3: ( ( WS )* sqlMappingItem= mappingItem ( ( WS )+ sqlMappingItem= mappingItem )* ( WS )* ( EOF )? )
			// org/sqlproc/engine/impl/SqlProcessor.g:448:3: ( WS )* sqlMappingItem= mappingItem ( ( WS )+ sqlMappingItem= mappingItem )* ( WS )* ( EOF )?
			{
			// org/sqlproc/engine/impl/SqlProcessor.g:448:3: ( WS )*
			loop71:
			while (true) {
				int alt71=2;
				int LA71_0 = input.LA(1);
				if ( (LA71_0==WS) ) {
					alt71=1;
				}

				switch (alt71) {
				case 1 :
					// org/sqlproc/engine/impl/SqlProcessor.g:448:3: WS
					{
					match(input,WS,FOLLOW_WS_in_mapping2207); 
					}
					break;

				default :
					break loop71;
				}
			}

			pushFollow(FOLLOW_mappingItem_in_mapping2214);
			sqlMappingItem=mappingItem();
			state._fsp--;

			if(!mapping_stack.peek().skip) sqlMapping.addMapping(sqlMappingItem);
			// org/sqlproc/engine/impl/SqlProcessor.g:450:3: ( ( WS )+ sqlMappingItem= mappingItem )*
			loop73:
			while (true) {
				int alt73=2;
				alt73 = dfa73.predict(input);
				switch (alt73) {
				case 1 :
					// org/sqlproc/engine/impl/SqlProcessor.g:450:4: ( WS )+ sqlMappingItem= mappingItem
					{
					// org/sqlproc/engine/impl/SqlProcessor.g:450:4: ( WS )+
					int cnt72=0;
					loop72:
					while (true) {
						int alt72=2;
						int LA72_0 = input.LA(1);
						if ( (LA72_0==WS) ) {
							alt72=1;
						}

						switch (alt72) {
						case 1 :
							// org/sqlproc/engine/impl/SqlProcessor.g:450:4: WS
							{
							match(input,WS,FOLLOW_WS_in_mapping2221); 
							}
							break;

						default :
							if ( cnt72 >= 1 ) break loop72;
							EarlyExitException eee = new EarlyExitException(72, input);
							throw eee;
						}
						cnt72++;
					}

					pushFollow(FOLLOW_mappingItem_in_mapping2226);
					sqlMappingItem=mappingItem();
					state._fsp--;

					if(!mapping_stack.peek().skip) sqlMapping.addMapping(sqlMappingItem);
					}
					break;

				default :
					break loop73;
				}
			}

			// org/sqlproc/engine/impl/SqlProcessor.g:451:3: ( WS )*
			loop74:
			while (true) {
				int alt74=2;
				int LA74_0 = input.LA(1);
				if ( (LA74_0==WS) ) {
					alt74=1;
				}

				switch (alt74) {
				case 1 :
					// org/sqlproc/engine/impl/SqlProcessor.g:451:3: WS
					{
					match(input,WS,FOLLOW_WS_in_mapping2234); 
					}
					break;

				default :
					break loop74;
				}
			}

			// org/sqlproc/engine/impl/SqlProcessor.g:451:8: ( EOF )?
			int alt75=2;
			int LA75_0 = input.LA(1);
			if ( (LA75_0==EOF) ) {
				alt75=1;
			}
			switch (alt75) {
				case 1 :
					// org/sqlproc/engine/impl/SqlProcessor.g:451:8: EOF
					{
					match(input,EOF,FOLLOW_EOF_in_mapping2238); 
					}
					break;

			}

			}

			}

			 artifactName.pop();
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
			mapping_stack.pop();
		}
		return sqlMapping;
	}
	// $ANTLR end "mapping"



	// $ANTLR start "mappingItem"
	// org/sqlproc/engine/impl/SqlProcessor.g:469:1: mappingItem returns [SqlMappingItem result] : (col= IDENT |col= NUMBER ) ( STRING (name= IDENT_DOT |name= IDENT |name= NUMBER ) ( options {greedy=true; } : LPAREN (value= IDENT |value= NUMBER ) ( options {greedy=true; } : COMMA (value= IDENT |value= NUMBER ) )* RPAREN )* ( (name= IDENT_DOT |name= IDENT |name= NUMBER ) ( options {greedy=true; } : LPAREN (value= IDENT |value= NUMBER ) ( options {greedy=true; } : COMMA (value= IDENT |value= NUMBER ) )* RPAREN )* )* )? ;
	public final SqlMappingItem mappingItem() throws RecognitionException {
		SqlMappingItem result = null;


		Token col=null;
		Token name=null;
		Token value=null;

		String sname; Map<String, List<String>> modifiers = new HashMap<String, List<String>>(); 
		try {
			// org/sqlproc/engine/impl/SqlProcessor.g:472:2: ( (col= IDENT |col= NUMBER ) ( STRING (name= IDENT_DOT |name= IDENT |name= NUMBER ) ( options {greedy=true; } : LPAREN (value= IDENT |value= NUMBER ) ( options {greedy=true; } : COMMA (value= IDENT |value= NUMBER ) )* RPAREN )* ( (name= IDENT_DOT |name= IDENT |name= NUMBER ) ( options {greedy=true; } : LPAREN (value= IDENT |value= NUMBER ) ( options {greedy=true; } : COMMA (value= IDENT |value= NUMBER ) )* RPAREN )* )* )? )
			// org/sqlproc/engine/impl/SqlProcessor.g:473:2: (col= IDENT |col= NUMBER ) ( STRING (name= IDENT_DOT |name= IDENT |name= NUMBER ) ( options {greedy=true; } : LPAREN (value= IDENT |value= NUMBER ) ( options {greedy=true; } : COMMA (value= IDENT |value= NUMBER ) )* RPAREN )* ( (name= IDENT_DOT |name= IDENT |name= NUMBER ) ( options {greedy=true; } : LPAREN (value= IDENT |value= NUMBER ) ( options {greedy=true; } : COMMA (value= IDENT |value= NUMBER ) )* RPAREN )* )* )?
			{
			// org/sqlproc/engine/impl/SqlProcessor.g:473:2: (col= IDENT |col= NUMBER )
			int alt76=2;
			int LA76_0 = input.LA(1);
			if ( (LA76_0==IDENT) ) {
				alt76=1;
			}
			else if ( (LA76_0==NUMBER) ) {
				alt76=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 76, 0, input);
				throw nvae;
			}

			switch (alt76) {
				case 1 :
					// org/sqlproc/engine/impl/SqlProcessor.g:473:3: col= IDENT
					{
					col=(Token)match(input,IDENT,FOLLOW_IDENT_in_mappingItem2273); 
					}
					break;
				case 2 :
					// org/sqlproc/engine/impl/SqlProcessor.g:473:15: col= NUMBER
					{
					col=(Token)match(input,NUMBER,FOLLOW_NUMBER_in_mappingItem2279); 
					}
					break;

			}

			if(!mapping_stack.peek().skip) result = newColumn((col!=null?col.getText():null)); 
			// org/sqlproc/engine/impl/SqlProcessor.g:474:5: ( STRING (name= IDENT_DOT |name= IDENT |name= NUMBER ) ( options {greedy=true; } : LPAREN (value= IDENT |value= NUMBER ) ( options {greedy=true; } : COMMA (value= IDENT |value= NUMBER ) )* RPAREN )* ( (name= IDENT_DOT |name= IDENT |name= NUMBER ) ( options {greedy=true; } : LPAREN (value= IDENT |value= NUMBER ) ( options {greedy=true; } : COMMA (value= IDENT |value= NUMBER ) )* RPAREN )* )* )?
			int alt88=2;
			int LA88_0 = input.LA(1);
			if ( (LA88_0==STRING) ) {
				alt88=1;
			}
			switch (alt88) {
				case 1 :
					// org/sqlproc/engine/impl/SqlProcessor.g:474:6: STRING (name= IDENT_DOT |name= IDENT |name= NUMBER ) ( options {greedy=true; } : LPAREN (value= IDENT |value= NUMBER ) ( options {greedy=true; } : COMMA (value= IDENT |value= NUMBER ) )* RPAREN )* ( (name= IDENT_DOT |name= IDENT |name= NUMBER ) ( options {greedy=true; } : LPAREN (value= IDENT |value= NUMBER ) ( options {greedy=true; } : COMMA (value= IDENT |value= NUMBER ) )* RPAREN )* )*
					{
					match(input,STRING,FOLLOW_STRING_in_mappingItem2289); 
					// org/sqlproc/engine/impl/SqlProcessor.g:474:13: (name= IDENT_DOT |name= IDENT |name= NUMBER )
					int alt77=3;
					switch ( input.LA(1) ) {
					case IDENT_DOT:
						{
						alt77=1;
						}
						break;
					case IDENT:
						{
						alt77=2;
						}
						break;
					case NUMBER:
						{
						alt77=3;
						}
						break;
					default:
						NoViableAltException nvae =
							new NoViableAltException("", 77, 0, input);
						throw nvae;
					}
					switch (alt77) {
						case 1 :
							// org/sqlproc/engine/impl/SqlProcessor.g:474:14: name= IDENT_DOT
							{
							name=(Token)match(input,IDENT_DOT,FOLLOW_IDENT_DOT_in_mappingItem2294); 
							}
							break;
						case 2 :
							// org/sqlproc/engine/impl/SqlProcessor.g:474:31: name= IDENT
							{
							name=(Token)match(input,IDENT,FOLLOW_IDENT_in_mappingItem2300); 
							}
							break;
						case 3 :
							// org/sqlproc/engine/impl/SqlProcessor.g:474:44: name= NUMBER
							{
							name=(Token)match(input,NUMBER,FOLLOW_NUMBER_in_mappingItem2306); 
							}
							break;

					}

					 if(!mapping_stack.peek().skip) addColumnAttr(result, name); sname =  (name!=null?name.getText():null); 
					// org/sqlproc/engine/impl/SqlProcessor.g:475:3: ( options {greedy=true; } : LPAREN (value= IDENT |value= NUMBER ) ( options {greedy=true; } : COMMA (value= IDENT |value= NUMBER ) )* RPAREN )*
					loop81:
					while (true) {
						int alt81=2;
						int LA81_0 = input.LA(1);
						if ( (LA81_0==LPAREN) ) {
							alt81=1;
						}

						switch (alt81) {
						case 1 :
							// org/sqlproc/engine/impl/SqlProcessor.g:475:29: LPAREN (value= IDENT |value= NUMBER ) ( options {greedy=true; } : COMMA (value= IDENT |value= NUMBER ) )* RPAREN
							{
							match(input,LPAREN,FOLLOW_LPAREN_in_mappingItem2323); 
							// org/sqlproc/engine/impl/SqlProcessor.g:475:36: (value= IDENT |value= NUMBER )
							int alt78=2;
							int LA78_0 = input.LA(1);
							if ( (LA78_0==IDENT) ) {
								alt78=1;
							}
							else if ( (LA78_0==NUMBER) ) {
								alt78=2;
							}

							else {
								NoViableAltException nvae =
									new NoViableAltException("", 78, 0, input);
								throw nvae;
							}

							switch (alt78) {
								case 1 :
									// org/sqlproc/engine/impl/SqlProcessor.g:475:37: value= IDENT
									{
									value=(Token)match(input,IDENT,FOLLOW_IDENT_in_mappingItem2328); 
									}
									break;
								case 2 :
									// org/sqlproc/engine/impl/SqlProcessor.g:475:51: value= NUMBER
									{
									value=(Token)match(input,NUMBER,FOLLOW_NUMBER_in_mappingItem2334); 
									}
									break;

							}

							 modifiers.put(sname, new ArrayList<String>()); modifiers.get(sname).add((value!=null?value.getText():null)); 
							// org/sqlproc/engine/impl/SqlProcessor.g:476:4: ( options {greedy=true; } : COMMA (value= IDENT |value= NUMBER ) )*
							loop80:
							while (true) {
								int alt80=2;
								int LA80_0 = input.LA(1);
								if ( (LA80_0==COMMA) ) {
									alt80=1;
								}

								switch (alt80) {
								case 1 :
									// org/sqlproc/engine/impl/SqlProcessor.g:476:30: COMMA (value= IDENT |value= NUMBER )
									{
									match(input,COMMA,FOLLOW_COMMA_in_mappingItem2352); 
									// org/sqlproc/engine/impl/SqlProcessor.g:476:36: (value= IDENT |value= NUMBER )
									int alt79=2;
									int LA79_0 = input.LA(1);
									if ( (LA79_0==IDENT) ) {
										alt79=1;
									}
									else if ( (LA79_0==NUMBER) ) {
										alt79=2;
									}

									else {
										NoViableAltException nvae =
											new NoViableAltException("", 79, 0, input);
										throw nvae;
									}

									switch (alt79) {
										case 1 :
											// org/sqlproc/engine/impl/SqlProcessor.g:476:37: value= IDENT
											{
											value=(Token)match(input,IDENT,FOLLOW_IDENT_in_mappingItem2357); 
											}
											break;
										case 2 :
											// org/sqlproc/engine/impl/SqlProcessor.g:476:51: value= NUMBER
											{
											value=(Token)match(input,NUMBER,FOLLOW_NUMBER_in_mappingItem2363); 
											}
											break;

									}

									 modifiers.get(sname).add((value!=null?value.getText():null)); 
									}
									break;

								default :
									break loop80;
								}
							}

							match(input,RPAREN,FOLLOW_RPAREN_in_mappingItem2374); 
							}
							break;

						default :
							break loop81;
						}
					}

					// org/sqlproc/engine/impl/SqlProcessor.g:479:6: ( (name= IDENT_DOT |name= IDENT |name= NUMBER ) ( options {greedy=true; } : LPAREN (value= IDENT |value= NUMBER ) ( options {greedy=true; } : COMMA (value= IDENT |value= NUMBER ) )* RPAREN )* )*
					loop87:
					while (true) {
						int alt87=2;
						int LA87_0 = input.LA(1);
						if ( ((LA87_0 >= IDENT && LA87_0 <= IDENT_DOT)||LA87_0==NUMBER) ) {
							alt87=1;
						}

						switch (alt87) {
						case 1 :
							// org/sqlproc/engine/impl/SqlProcessor.g:479:7: (name= IDENT_DOT |name= IDENT |name= NUMBER ) ( options {greedy=true; } : LPAREN (value= IDENT |value= NUMBER ) ( options {greedy=true; } : COMMA (value= IDENT |value= NUMBER ) )* RPAREN )*
							{
							// org/sqlproc/engine/impl/SqlProcessor.g:479:7: (name= IDENT_DOT |name= IDENT |name= NUMBER )
							int alt82=3;
							switch ( input.LA(1) ) {
							case IDENT_DOT:
								{
								alt82=1;
								}
								break;
							case IDENT:
								{
								alt82=2;
								}
								break;
							case NUMBER:
								{
								alt82=3;
								}
								break;
							default:
								NoViableAltException nvae =
									new NoViableAltException("", 82, 0, input);
								throw nvae;
							}
							switch (alt82) {
								case 1 :
									// org/sqlproc/engine/impl/SqlProcessor.g:479:8: name= IDENT_DOT
									{
									name=(Token)match(input,IDENT_DOT,FOLLOW_IDENT_DOT_in_mappingItem2390); 
									}
									break;
								case 2 :
									// org/sqlproc/engine/impl/SqlProcessor.g:479:25: name= IDENT
									{
									name=(Token)match(input,IDENT,FOLLOW_IDENT_in_mappingItem2396); 
									}
									break;
								case 3 :
									// org/sqlproc/engine/impl/SqlProcessor.g:479:38: name= NUMBER
									{
									name=(Token)match(input,NUMBER,FOLLOW_NUMBER_in_mappingItem2402); 
									}
									break;

							}

							 if(!mapping_stack.peek().skip) addColumnAttr(result, name); sname = sname + "." + (name!=null?name.getText():null); 
							// org/sqlproc/engine/impl/SqlProcessor.g:480:4: ( options {greedy=true; } : LPAREN (value= IDENT |value= NUMBER ) ( options {greedy=true; } : COMMA (value= IDENT |value= NUMBER ) )* RPAREN )*
							loop86:
							while (true) {
								int alt86=2;
								int LA86_0 = input.LA(1);
								if ( (LA86_0==LPAREN) ) {
									alt86=1;
								}

								switch (alt86) {
								case 1 :
									// org/sqlproc/engine/impl/SqlProcessor.g:480:30: LPAREN (value= IDENT |value= NUMBER ) ( options {greedy=true; } : COMMA (value= IDENT |value= NUMBER ) )* RPAREN
									{
									match(input,LPAREN,FOLLOW_LPAREN_in_mappingItem2420); 
									// org/sqlproc/engine/impl/SqlProcessor.g:480:37: (value= IDENT |value= NUMBER )
									int alt83=2;
									int LA83_0 = input.LA(1);
									if ( (LA83_0==IDENT) ) {
										alt83=1;
									}
									else if ( (LA83_0==NUMBER) ) {
										alt83=2;
									}

									else {
										NoViableAltException nvae =
											new NoViableAltException("", 83, 0, input);
										throw nvae;
									}

									switch (alt83) {
										case 1 :
											// org/sqlproc/engine/impl/SqlProcessor.g:480:38: value= IDENT
											{
											value=(Token)match(input,IDENT,FOLLOW_IDENT_in_mappingItem2425); 
											}
											break;
										case 2 :
											// org/sqlproc/engine/impl/SqlProcessor.g:480:52: value= NUMBER
											{
											value=(Token)match(input,NUMBER,FOLLOW_NUMBER_in_mappingItem2431); 
											}
											break;

									}

									 modifiers.put(sname, new ArrayList<String>()); modifiers.get(sname).add((value!=null?value.getText():null)); 
									// org/sqlproc/engine/impl/SqlProcessor.g:481:5: ( options {greedy=true; } : COMMA (value= IDENT |value= NUMBER ) )*
									loop85:
									while (true) {
										int alt85=2;
										int LA85_0 = input.LA(1);
										if ( (LA85_0==COMMA) ) {
											alt85=1;
										}

										switch (alt85) {
										case 1 :
											// org/sqlproc/engine/impl/SqlProcessor.g:481:31: COMMA (value= IDENT |value= NUMBER )
											{
											match(input,COMMA,FOLLOW_COMMA_in_mappingItem2450); 
											// org/sqlproc/engine/impl/SqlProcessor.g:481:37: (value= IDENT |value= NUMBER )
											int alt84=2;
											int LA84_0 = input.LA(1);
											if ( (LA84_0==IDENT) ) {
												alt84=1;
											}
											else if ( (LA84_0==NUMBER) ) {
												alt84=2;
											}

											else {
												NoViableAltException nvae =
													new NoViableAltException("", 84, 0, input);
												throw nvae;
											}

											switch (alt84) {
												case 1 :
													// org/sqlproc/engine/impl/SqlProcessor.g:481:38: value= IDENT
													{
													value=(Token)match(input,IDENT,FOLLOW_IDENT_in_mappingItem2455); 
													}
													break;
												case 2 :
													// org/sqlproc/engine/impl/SqlProcessor.g:481:52: value= NUMBER
													{
													value=(Token)match(input,NUMBER,FOLLOW_NUMBER_in_mappingItem2461); 
													}
													break;

											}

											 modifiers.get(sname).add((value!=null?value.getText():null)); 
											}
											break;

										default :
											break loop85;
										}
									}

									match(input,RPAREN,FOLLOW_RPAREN_in_mappingItem2473); 
									}
									break;

								default :
									break loop86;
								}
							}

							}
							break;

						default :
							break loop87;
						}
					}

					}
					break;

			}

			}

			if(!mapping_stack.peek().skip) for (String n : modifiers.keySet()) for (String m : modifiers.get(n)) addModifier(mapping_stack.peek().typeFactory, result, m, n); 
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return result;
	}
	// $ANTLR end "mappingItem"



	// $ANTLR start "option"
	// org/sqlproc/engine/impl/SqlProcessor.g:488:1: option[String name] returns [StringBuilder text] : (~ ( SEMICOLON ) )+ ;
	public final StringBuilder option(String name) throws RecognitionException {
		StringBuilder text = null;


		artifactName.push(name); text = new StringBuilder();
		try {
			// org/sqlproc/engine/impl/SqlProcessor.g:491:2: ( (~ ( SEMICOLON ) )+ )
			// org/sqlproc/engine/impl/SqlProcessor.g:491:4: (~ ( SEMICOLON ) )+
			{
			// org/sqlproc/engine/impl/SqlProcessor.g:491:4: (~ ( SEMICOLON ) )+
			int cnt89=0;
			loop89:
			while (true) {
				int alt89=2;
				int LA89_0 = input.LA(1);
				if ( ((LA89_0 >= AND && LA89_0 <= RPAREN)||(LA89_0 >= SL_COMMENT && LA89_0 <= WS)) ) {
					alt89=1;
				}

				switch (alt89) {
				case 1 :
					// org/sqlproc/engine/impl/SqlProcessor.g:491:5: ~ ( SEMICOLON )
					{
					if ( (input.LA(1) >= AND && input.LA(1) <= RPAREN)||(input.LA(1) >= SL_COMMENT && input.LA(1) <= WS) ) {
						input.consume();
						state.errorRecovery=false;
					}
					else {
						MismatchedSetException mse = new MismatchedSetException(null,input);
						throw mse;
					}
					add(text);
					}
					break;

				default :
					if ( cnt89 >= 1 ) break loop89;
					EarlyExitException eee = new EarlyExitException(89, input);
					throw eee;
				}
				cnt89++;
			}

			}

			 artifactName.pop();
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return text;
	}
	// $ANTLR end "option"

	// Delegated rules


	protected DFA43 dfa43 = new DFA43(this);
	protected DFA48 dfa48 = new DFA48(this);
	protected DFA57 dfa57 = new DFA57(this);
	protected DFA66 dfa66 = new DFA66(this);
	protected DFA73 dfa73 = new DFA73(this);
	static final String DFA43_eotS =
		"\11\uffff";
	static final String DFA43_eofS =
		"\2\2\1\uffff\3\2\1\uffff\2\2";
	static final String DFA43_minS =
		"\2\4\1\uffff\3\4\1\uffff\2\4";
	static final String DFA43_maxS =
		"\2\62\1\uffff\3\62\1\uffff\2\62";
	static final String DFA43_acceptS =
		"\2\uffff\1\2\3\uffff\1\1\2\uffff";
	static final String DFA43_specialS =
		"\11\uffff}>";
	static final String[] DFA43_transitionS = {
			"\33\2\1\1\23\2",
			"\27\2\1\3\11\2\1\4\15\2",
			"",
			"\6\2\1\5\42\2\1\6\5\2",
			"\6\2\1\5\42\2\1\6\5\2",
			"\27\2\1\7\11\2\1\10\15\2",
			"",
			"\6\2\1\5\42\2\1\6\5\2",
			"\6\2\1\5\42\2\1\6\5\2"
	};

	static final short[] DFA43_eot = DFA.unpackEncodedString(DFA43_eotS);
	static final short[] DFA43_eof = DFA.unpackEncodedString(DFA43_eofS);
	static final char[] DFA43_min = DFA.unpackEncodedStringToUnsignedChars(DFA43_minS);
	static final char[] DFA43_max = DFA.unpackEncodedStringToUnsignedChars(DFA43_maxS);
	static final short[] DFA43_accept = DFA.unpackEncodedString(DFA43_acceptS);
	static final short[] DFA43_special = DFA.unpackEncodedString(DFA43_specialS);
	static final short[][] DFA43_transition;

	static {
		int numStates = DFA43_transitionS.length;
		DFA43_transition = new short[numStates][];
		for (int i=0; i<numStates; i++) {
			DFA43_transition[i] = DFA.unpackEncodedString(DFA43_transitionS[i]);
		}
	}

	protected class DFA43 extends DFA {

		public DFA43(BaseRecognizer recognizer) {
			this.recognizer = recognizer;
			this.decisionNumber = 43;
			this.eot = DFA43_eot;
			this.eof = DFA43_eof;
			this.min = DFA43_min;
			this.max = DFA43_max;
			this.accept = DFA43_accept;
			this.special = DFA43_special;
			this.transition = DFA43_transition;
		}
		@Override
		public String getDescription() {
			return "384:2: ( options {greedy=true; } : LPAREN (value= IDENT |value= NUMBER ) ( options {greedy=true; } : COMMA (value= IDENT |value= NUMBER ) )* RPAREN )?";
		}
	}

	static final String DFA48_eotS =
		"\11\uffff";
	static final String DFA48_eofS =
		"\2\2\1\uffff\3\2\1\uffff\2\2";
	static final String DFA48_minS =
		"\2\4\1\uffff\3\4\1\uffff\2\4";
	static final String DFA48_maxS =
		"\2\62\1\uffff\3\62\1\uffff\2\62";
	static final String DFA48_acceptS =
		"\2\uffff\1\2\3\uffff\1\1\2\uffff";
	static final String DFA48_specialS =
		"\11\uffff}>";
	static final String[] DFA48_transitionS = {
			"\33\2\1\1\23\2",
			"\27\2\1\3\11\2\1\4\15\2",
			"",
			"\6\2\1\5\42\2\1\6\5\2",
			"\6\2\1\5\42\2\1\6\5\2",
			"\27\2\1\7\11\2\1\10\15\2",
			"",
			"\6\2\1\5\42\2\1\6\5\2",
			"\6\2\1\5\42\2\1\6\5\2"
	};

	static final short[] DFA48_eot = DFA.unpackEncodedString(DFA48_eotS);
	static final short[] DFA48_eof = DFA.unpackEncodedString(DFA48_eofS);
	static final char[] DFA48_min = DFA.unpackEncodedStringToUnsignedChars(DFA48_minS);
	static final char[] DFA48_max = DFA.unpackEncodedStringToUnsignedChars(DFA48_maxS);
	static final short[] DFA48_accept = DFA.unpackEncodedString(DFA48_acceptS);
	static final short[] DFA48_special = DFA.unpackEncodedString(DFA48_specialS);
	static final short[][] DFA48_transition;

	static {
		int numStates = DFA48_transitionS.length;
		DFA48_transition = new short[numStates][];
		for (int i=0; i<numStates; i++) {
			DFA48_transition[i] = DFA.unpackEncodedString(DFA48_transitionS[i]);
		}
	}

	protected class DFA48 extends DFA {

		public DFA48(BaseRecognizer recognizer) {
			this.recognizer = recognizer;
			this.decisionNumber = 48;
			this.eot = DFA48_eot;
			this.eof = DFA48_eof;
			this.min = DFA48_min;
			this.max = DFA48_max;
			this.accept = DFA48_accept;
			this.special = DFA48_special;
			this.transition = DFA48_transition;
		}
		@Override
		public String getDescription() {
			return "390:3: ( options {greedy=true; } : LPAREN (value= IDENT |value= NUMBER ) ( options {greedy=true; } : COMMA (value= IDENT |value= NUMBER ) )* RPAREN )?";
		}
	}

	static final String DFA57_eotS =
		"\13\uffff";
	static final String DFA57_eofS =
		"\2\2\1\uffff\4\2\1\uffff\3\2";
	static final String DFA57_minS =
		"\2\4\1\uffff\4\4\1\uffff\3\4";
	static final String DFA57_maxS =
		"\2\62\1\uffff\4\62\1\uffff\3\62";
	static final String DFA57_acceptS =
		"\2\uffff\1\2\4\uffff\1\1\3\uffff";
	static final String DFA57_specialS =
		"\13\uffff}>";
	static final String[] DFA57_transitionS = {
			"\33\2\1\1\23\2",
			"\27\2\1\4\10\2\1\3\1\5\15\2",
			"",
			"\27\2\1\4\11\2\1\5\15\2",
			"\6\2\1\6\42\2\1\7\5\2",
			"\6\2\1\6\42\2\1\7\5\2",
			"\27\2\1\11\10\2\1\10\1\12\15\2",
			"",
			"\27\2\1\11\11\2\1\12\15\2",
			"\6\2\1\6\42\2\1\7\5\2",
			"\6\2\1\6\42\2\1\7\5\2"
	};

	static final short[] DFA57_eot = DFA.unpackEncodedString(DFA57_eotS);
	static final short[] DFA57_eof = DFA.unpackEncodedString(DFA57_eofS);
	static final char[] DFA57_min = DFA.unpackEncodedStringToUnsignedChars(DFA57_minS);
	static final char[] DFA57_max = DFA.unpackEncodedStringToUnsignedChars(DFA57_maxS);
	static final short[] DFA57_accept = DFA.unpackEncodedString(DFA57_acceptS);
	static final short[] DFA57_special = DFA.unpackEncodedString(DFA57_specialS);
	static final short[][] DFA57_transition;

	static {
		int numStates = DFA57_transitionS.length;
		DFA57_transition = new short[numStates][];
		for (int i=0; i<numStates; i++) {
			DFA57_transition[i] = DFA.unpackEncodedString(DFA57_transitionS[i]);
		}
	}

	protected class DFA57 extends DFA {

		public DFA57(BaseRecognizer recognizer) {
			this.recognizer = recognizer;
			this.decisionNumber = 57;
			this.eot = DFA57_eot;
			this.eof = DFA57_eof;
			this.min = DFA57_min;
			this.max = DFA57_max;
			this.accept = DFA57_accept;
			this.special = DFA57_special;
			this.transition = DFA57_transition;
		}
		@Override
		public String getDescription() {
			return "401:2: ( options {greedy=true; } : LPAREN (not= NOT )? (value= IDENT |value= NUMBER ) ( options {greedy=true; } : COMMA (not= NOT )? (value= IDENT |value= NUMBER ) )* RPAREN )?";
		}
	}

	static final String DFA66_eotS =
		"\13\uffff";
	static final String DFA66_eofS =
		"\2\2\1\uffff\4\2\1\uffff\3\2";
	static final String DFA66_minS =
		"\2\4\1\uffff\4\4\1\uffff\3\4";
	static final String DFA66_maxS =
		"\2\62\1\uffff\4\62\1\uffff\3\62";
	static final String DFA66_acceptS =
		"\2\uffff\1\2\4\uffff\1\1\3\uffff";
	static final String DFA66_specialS =
		"\13\uffff}>";
	static final String[] DFA66_transitionS = {
			"\33\2\1\1\23\2",
			"\27\2\1\4\10\2\1\3\1\5\15\2",
			"",
			"\27\2\1\4\11\2\1\5\15\2",
			"\6\2\1\6\42\2\1\7\5\2",
			"\6\2\1\6\42\2\1\7\5\2",
			"\27\2\1\11\10\2\1\10\1\12\15\2",
			"",
			"\27\2\1\11\11\2\1\12\15\2",
			"\6\2\1\6\42\2\1\7\5\2",
			"\6\2\1\6\42\2\1\7\5\2"
	};

	static final short[] DFA66_eot = DFA.unpackEncodedString(DFA66_eotS);
	static final short[] DFA66_eof = DFA.unpackEncodedString(DFA66_eofS);
	static final char[] DFA66_min = DFA.unpackEncodedStringToUnsignedChars(DFA66_minS);
	static final char[] DFA66_max = DFA.unpackEncodedStringToUnsignedChars(DFA66_maxS);
	static final short[] DFA66_accept = DFA.unpackEncodedString(DFA66_acceptS);
	static final short[] DFA66_special = DFA.unpackEncodedString(DFA66_specialS);
	static final short[][] DFA66_transition;

	static {
		int numStates = DFA66_transitionS.length;
		DFA66_transition = new short[numStates][];
		for (int i=0; i<numStates; i++) {
			DFA66_transition[i] = DFA.unpackEncodedString(DFA66_transitionS[i]);
		}
	}

	protected class DFA66 extends DFA {

		public DFA66(BaseRecognizer recognizer) {
			this.recognizer = recognizer;
			this.decisionNumber = 66;
			this.eot = DFA66_eot;
			this.eof = DFA66_eof;
			this.min = DFA66_min;
			this.max = DFA66_max;
			this.accept = DFA66_accept;
			this.special = DFA66_special;
			this.transition = DFA66_transition;
		}
		@Override
		public String getDescription() {
			return "411:2: ( options {greedy=true; } : LPAREN (not= NOT )? (value= IDENT |value= NUMBER ) ( options {greedy=true; } : COMMA (not= NOT )? (value= IDENT |value= NUMBER ) )* RPAREN )?";
		}
	}

	static final String DFA73_eotS =
		"\4\uffff";
	static final String DFA73_eofS =
		"\2\2\2\uffff";
	static final String DFA73_minS =
		"\1\56\1\33\2\uffff";
	static final String DFA73_maxS =
		"\2\62\2\uffff";
	static final String DFA73_acceptS =
		"\2\uffff\1\2\1\1";
	static final String DFA73_specialS =
		"\4\uffff}>";
	static final String[] DFA73_transitionS = {
			"\1\2\3\uffff\1\1",
			"\1\3\11\uffff\1\3\10\uffff\1\2\3\uffff\1\1",
			"",
			""
	};

	static final short[] DFA73_eot = DFA.unpackEncodedString(DFA73_eotS);
	static final short[] DFA73_eof = DFA.unpackEncodedString(DFA73_eofS);
	static final char[] DFA73_min = DFA.unpackEncodedStringToUnsignedChars(DFA73_minS);
	static final char[] DFA73_max = DFA.unpackEncodedStringToUnsignedChars(DFA73_maxS);
	static final short[] DFA73_accept = DFA.unpackEncodedString(DFA73_acceptS);
	static final short[] DFA73_special = DFA.unpackEncodedString(DFA73_specialS);
	static final short[][] DFA73_transition;

	static {
		int numStates = DFA73_transitionS.length;
		DFA73_transition = new short[numStates][];
		for (int i=0; i<numStates; i++) {
			DFA73_transition[i] = DFA.unpackEncodedString(DFA73_transitionS[i]);
		}
	}

	protected class DFA73 extends DFA {

		public DFA73(BaseRecognizer recognizer) {
			this.recognizer = recognizer;
			this.decisionNumber = 73;
			this.eot = DFA73_eot;
			this.eof = DFA73_eof;
			this.min = DFA73_min;
			this.max = DFA73_max;
			this.accept = DFA73_accept;
			this.special = DFA73_special;
			this.transition = DFA73_transition;
		}
		@Override
		public String getDescription() {
			return "()* loopback of 450:3: ( ( WS )+ sqlMappingItem= mappingItem )*";
		}
	}

	public static final BitSet FOLLOW_parse2_in_parse52 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_WS_in_parse293 = new BitSet(new long[]{0x0004000008000000L});
	public static final BitSet FOLLOW_IDENT_in_parse2110 = new BitSet(new long[]{0x0000000080000000L});
	public static final BitSet FOLLOW_LPAREN_in_parse2114 = new BitSet(new long[]{0x0001000000000000L});
	public static final BitSet FOLLOW_STATEMENT_in_parse2118 = new BitSet(new long[]{0x0000200000000400L});
	public static final BitSet FOLLOW_COMMA_in_parse2123 = new BitSet(new long[]{0x0000000008000000L});
	public static final BitSet FOLLOW_IDENT_in_parse2127 = new BitSet(new long[]{0x0000200000000400L});
	public static final BitSet FOLLOW_RPAREN_in_parse2133 = new BitSet(new long[]{0x0000000000002000L});
	public static final BitSet FOLLOW_EQUALS_in_parse2135 = new BitSet(new long[]{0x0007BFFFFFFFFFF0L});
	public static final BitSet FOLLOW_meta_in_parse2151 = new BitSet(new long[]{0x0000400000000000L});
	public static final BitSet FOLLOW_SEMICOLON_in_parse2156 = new BitSet(new long[]{0x0004000008000000L});
	public static final BitSet FOLLOW_WS_in_parse2158 = new BitSet(new long[]{0x0004000008000000L});
	public static final BitSet FOLLOW_IDENT_in_parse2176 = new BitSet(new long[]{0x0000000080000000L});
	public static final BitSet FOLLOW_LPAREN_in_parse2180 = new BitSet(new long[]{0x0000000100000000L});
	public static final BitSet FOLLOW_MAPPING_in_parse2184 = new BitSet(new long[]{0x0000200000000400L});
	public static final BitSet FOLLOW_COMMA_in_parse2189 = new BitSet(new long[]{0x0000000008000000L});
	public static final BitSet FOLLOW_IDENT_in_parse2193 = new BitSet(new long[]{0x0000200000000400L});
	public static final BitSet FOLLOW_RPAREN_in_parse2199 = new BitSet(new long[]{0x0000000000002000L});
	public static final BitSet FOLLOW_EQUALS_in_parse2201 = new BitSet(new long[]{0x0004002008000000L});
	public static final BitSet FOLLOW_mapping_in_parse2217 = new BitSet(new long[]{0x0000400000000000L});
	public static final BitSet FOLLOW_SEMICOLON_in_parse2222 = new BitSet(new long[]{0x0004000008000000L});
	public static final BitSet FOLLOW_WS_in_parse2224 = new BitSet(new long[]{0x0004000008000000L});
	public static final BitSet FOLLOW_IDENT_in_parse2242 = new BitSet(new long[]{0x0000000080000000L});
	public static final BitSet FOLLOW_LPAREN_in_parse2244 = new BitSet(new long[]{0x0000004000000000L});
	public static final BitSet FOLLOW_OPTION_in_parse2248 = new BitSet(new long[]{0x0000200000000400L});
	public static final BitSet FOLLOW_COMMA_in_parse2253 = new BitSet(new long[]{0x0000000008000000L});
	public static final BitSet FOLLOW_IDENT_in_parse2257 = new BitSet(new long[]{0x0000200000000400L});
	public static final BitSet FOLLOW_RPAREN_in_parse2263 = new BitSet(new long[]{0x0000000000002000L});
	public static final BitSet FOLLOW_EQUALS_in_parse2265 = new BitSet(new long[]{0x0007BFFFFFFFFFF0L});
	public static final BitSet FOLLOW_option_in_parse2281 = new BitSet(new long[]{0x0000400000000000L});
	public static final BitSet FOLLOW_SEMICOLON_in_parse2286 = new BitSet(new long[]{0x0004000008000000L});
	public static final BitSet FOLLOW_WS_in_parse2288 = new BitSet(new long[]{0x0004000008000000L});
	public static final BitSet FOLLOW_EOF_in_parse2303 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_sql_in_meta335 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_EOF_in_meta338 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_sqlFragment_in_sql377 = new BitSet(new long[]{0x0007BFFFFFFFFFF2L});
	public static final BitSet FOLLOW_set_in_sqlFragment406 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_COLON_in_sqlFragment438 = new BitSet(new long[]{0x0000022A58002000L});
	public static final BitSet FOLLOW_identifier_in_sqlFragment442 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_STRING_in_sqlFragment455 = new BitSet(new long[]{0x0000020218000000L});
	public static final BitSet FOLLOW_constant_in_sqlFragment459 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_COLON_in_sqlFragment472 = new BitSet(new long[]{0x0000000000000200L});
	public static final BitSet FOLLOW_COLON_in_sqlFragment474 = new BitSet(new long[]{0x0000000008002000L});
	public static final BitSet FOLLOW_identifierOperator_in_sqlFragment478 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_STRING_in_sqlFragment488 = new BitSet(new long[]{0x0002000000000000L});
	public static final BitSet FOLLOW_STRING_in_sqlFragment490 = new BitSet(new long[]{0x0000000008002000L});
	public static final BitSet FOLLOW_constantOperator_in_sqlFragment494 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_AT_in_sqlFragment507 = new BitSet(new long[]{0x0000002018000000L});
	public static final BitSet FOLLOW_column_in_sqlFragment511 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_PERCENT_in_sqlFragment525 = new BitSet(new long[]{0x0000010018000000L});
	public static final BitSet FOLLOW_PERCENT_in_sqlFragment528 = new BitSet(new long[]{0x0000000018000000L});
	public static final BitSet FOLLOW_dbtable_in_sqlFragment532 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_dbcolumn_in_sqlFragment553 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_LBRACE_in_sqlFragment564 = new BitSet(new long[]{0x0007F7FFFFFFFFF0L});
	public static final BitSet FOLLOW_metaSql_in_sqlFragment566 = new BitSet(new long[]{0x0000080000000000L});
	public static final BitSet FOLLOW_RBRACE_in_sqlFragment569 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_set_in_metaSql592 = new BitSet(new long[]{0x0007F7FFFFFFFF70L});
	public static final BitSet FOLLOW_ifSql_in_metaSql623 = new BitSet(new long[]{0x0000000000000082L});
	public static final BitSet FOLLOW_BOR_in_metaSql632 = new BitSet(new long[]{0x0007F7FFFFFFFF70L});
	public static final BitSet FOLLOW_ifSql_in_metaSql636 = new BitSet(new long[]{0x0000000000000082L});
	public static final BitSet FOLLOW_QUESTI_in_metaSql648 = new BitSet(new long[]{0x0006001080000200L});
	public static final BitSet FOLLOW_ifSqlCond_in_metaSql654 = new BitSet(new long[]{0x0000000000000080L});
	public static final BitSet FOLLOW_BOR_in_metaSql661 = new BitSet(new long[]{0x0007F7FFFFFFFF70L});
	public static final BitSet FOLLOW_ifSql_in_metaSql665 = new BitSet(new long[]{0x0000000000000082L});
	public static final BitSet FOLLOW_BOR_in_metaSql674 = new BitSet(new long[]{0x0007F7FFFFFFFF70L});
	public static final BitSet FOLLOW_ifSql_in_metaSql678 = new BitSet(new long[]{0x0000000000000082L});
	public static final BitSet FOLLOW_BAND_in_metaSql693 = new BitSet(new long[]{0x0007F7FFFFFFFF70L});
	public static final BitSet FOLLOW_ifSql_in_metaSql699 = new BitSet(new long[]{0x0000000000000082L});
	public static final BitSet FOLLOW_BOR_in_metaSql708 = new BitSet(new long[]{0x0007F7FFFFFFFF70L});
	public static final BitSet FOLLOW_ifSql_in_metaSql712 = new BitSet(new long[]{0x0000000000000082L});
	public static final BitSet FOLLOW_BOR_in_metaSql724 = new BitSet(new long[]{0x0007F7FFFFFFFF70L});
	public static final BitSet FOLLOW_ifSql_in_metaSql730 = new BitSet(new long[]{0x0000000000000082L});
	public static final BitSet FOLLOW_BOR_in_metaSql739 = new BitSet(new long[]{0x0007F7FFFFFFFF70L});
	public static final BitSet FOLLOW_ifSql_in_metaSql743 = new BitSet(new long[]{0x0000000000000082L});
	public static final BitSet FOLLOW_EQUALS_in_metaSql755 = new BitSet(new long[]{0x0004000008000000L});
	public static final BitSet FOLLOW_WS_in_metaSql757 = new BitSet(new long[]{0x0004000008000000L});
	public static final BitSet FOLLOW_IDENT_in_metaSql762 = new BitSet(new long[]{0x0007F7FFFFFFFF70L});
	public static final BitSet FOLLOW_ifSql_in_metaSql768 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_HASH_in_metaSql781 = new BitSet(new long[]{0x0000002008000000L});
	public static final BitSet FOLLOW_set_in_metaSql785 = new BitSet(new long[]{0x0007F7FFFFFFFFF0L});
	public static final BitSet FOLLOW_ordSql_in_metaSql795 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ifSqlFragment_in_ifSql822 = new BitSet(new long[]{0x0007F7FFFFFFFF72L});
	public static final BitSet FOLLOW_set_in_ifSqlFragment844 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_COLON_in_ifSqlFragment880 = new BitSet(new long[]{0x0000022A58002000L});
	public static final BitSet FOLLOW_identifier_in_ifSqlFragment884 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_STRING_in_ifSqlFragment894 = new BitSet(new long[]{0x0000020218000000L});
	public static final BitSet FOLLOW_constant_in_ifSqlFragment898 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_COLON_in_ifSqlFragment908 = new BitSet(new long[]{0x0000000000000200L});
	public static final BitSet FOLLOW_COLON_in_ifSqlFragment910 = new BitSet(new long[]{0x0000000008002000L});
	public static final BitSet FOLLOW_identifierOperator_in_ifSqlFragment914 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_STRING_in_ifSqlFragment924 = new BitSet(new long[]{0x0002000000000000L});
	public static final BitSet FOLLOW_STRING_in_ifSqlFragment926 = new BitSet(new long[]{0x0000000008002000L});
	public static final BitSet FOLLOW_constantOperator_in_ifSqlFragment930 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_AT_in_ifSqlFragment943 = new BitSet(new long[]{0x0000002018000000L});
	public static final BitSet FOLLOW_column_in_ifSqlFragment947 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_PERCENT_in_ifSqlFragment960 = new BitSet(new long[]{0x0000010018000000L});
	public static final BitSet FOLLOW_PERCENT_in_ifSqlFragment963 = new BitSet(new long[]{0x0000000018000000L});
	public static final BitSet FOLLOW_dbtable_in_ifSqlFragment967 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_dbcolumn_in_ifSqlFragment988 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_LBRACE_in_ifSqlFragment996 = new BitSet(new long[]{0x0007F7FFDFFFFFF0L});
	public static final BitSet FOLLOW_ifMetaSql_in_ifSqlFragment998 = new BitSet(new long[]{0x0000080000000000L});
	public static final BitSet FOLLOW_RBRACE_in_ifSqlFragment1001 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_set_in_ifMetaSql1034 = new BitSet(new long[]{0x0007F7FFFFFFFF70L});
	public static final BitSet FOLLOW_ifSql_in_ifMetaSql1061 = new BitSet(new long[]{0x0000000000000082L});
	public static final BitSet FOLLOW_BOR_in_ifMetaSql1070 = new BitSet(new long[]{0x0007F7FFFFFFFF70L});
	public static final BitSet FOLLOW_ifSql_in_ifMetaSql1074 = new BitSet(new long[]{0x0000000000000082L});
	public static final BitSet FOLLOW_QUESTI_in_ifMetaSql1086 = new BitSet(new long[]{0x0006001080000200L});
	public static final BitSet FOLLOW_ifSqlCond_in_ifMetaSql1092 = new BitSet(new long[]{0x0000000000000080L});
	public static final BitSet FOLLOW_BOR_in_ifMetaSql1099 = new BitSet(new long[]{0x0007F7FFFFFFFF70L});
	public static final BitSet FOLLOW_ifSql_in_ifMetaSql1103 = new BitSet(new long[]{0x0000000000000082L});
	public static final BitSet FOLLOW_BOR_in_ifMetaSql1112 = new BitSet(new long[]{0x0007F7FFFFFFFF70L});
	public static final BitSet FOLLOW_ifSql_in_ifMetaSql1116 = new BitSet(new long[]{0x0000000000000082L});
	public static final BitSet FOLLOW_BAND_in_ifMetaSql1131 = new BitSet(new long[]{0x0007F7FFFFFFFF70L});
	public static final BitSet FOLLOW_ifSql_in_ifMetaSql1137 = new BitSet(new long[]{0x0000000000000082L});
	public static final BitSet FOLLOW_BOR_in_ifMetaSql1146 = new BitSet(new long[]{0x0007F7FFFFFFFF70L});
	public static final BitSet FOLLOW_ifSql_in_ifMetaSql1150 = new BitSet(new long[]{0x0000000000000082L});
	public static final BitSet FOLLOW_BOR_in_ifMetaSql1162 = new BitSet(new long[]{0x0007F7FFFFFFFF70L});
	public static final BitSet FOLLOW_ifSql_in_ifMetaSql1168 = new BitSet(new long[]{0x0000000000000082L});
	public static final BitSet FOLLOW_BOR_in_ifMetaSql1177 = new BitSet(new long[]{0x0007F7FFFFFFFF70L});
	public static final BitSet FOLLOW_ifSql_in_ifMetaSql1181 = new BitSet(new long[]{0x0000000000000082L});
	public static final BitSet FOLLOW_WS_in_ifSqlCond1208 = new BitSet(new long[]{0x0006001080000200L});
	public static final BitSet FOLLOW_ifSqlBool_in_ifSqlCond1211 = new BitSet(new long[]{0x0004008000000012L});
	public static final BitSet FOLLOW_WS_in_ifSqlCond1214 = new BitSet(new long[]{0x0004008000000012L});
	public static final BitSet FOLLOW_AND_in_ifSqlCond1219 = new BitSet(new long[]{0x0006001080000200L});
	public static final BitSet FOLLOW_OR_in_ifSqlCond1225 = new BitSet(new long[]{0x0006001080000200L});
	public static final BitSet FOLLOW_WS_in_ifSqlCond1230 = new BitSet(new long[]{0x0006001080000200L});
	public static final BitSet FOLLOW_ifSqlBool_in_ifSqlCond1235 = new BitSet(new long[]{0x0004008000000012L});
	public static final BitSet FOLLOW_WS_in_ifSqlCond1238 = new BitSet(new long[]{0x0004008000000012L});
	public static final BitSet FOLLOW_NOT_in_ifSqlBool1258 = new BitSet(new long[]{0x0000000000000200L});
	public static final BitSet FOLLOW_COLON_in_ifSqlBool1261 = new BitSet(new long[]{0x0000022A58002000L});
	public static final BitSet FOLLOW_identifier_in_ifSqlBool1265 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_NOT_in_ifSqlBool1274 = new BitSet(new long[]{0x0002000000000000L});
	public static final BitSet FOLLOW_STRING_in_ifSqlBool1277 = new BitSet(new long[]{0x0000020218000000L});
	public static final BitSet FOLLOW_constant_in_ifSqlBool1281 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_NOT_in_ifSqlBool1290 = new BitSet(new long[]{0x0000000080000000L});
	public static final BitSet FOLLOW_LPAREN_in_ifSqlBool1293 = new BitSet(new long[]{0x0006001080000200L});
	public static final BitSet FOLLOW_ifSqlCond_in_ifSqlBool1297 = new BitSet(new long[]{0x0000200000000000L});
	public static final BitSet FOLLOW_RPAREN_in_ifSqlBool1299 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ordSqlFragment_in_ordSql1324 = new BitSet(new long[]{0x0007F7FFFFFFFFF2L});
	public static final BitSet FOLLOW_set_in_ordSqlFragment1351 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_COLON_in_ordSqlFragment1375 = new BitSet(new long[]{0x0000022A58002000L});
	public static final BitSet FOLLOW_identifier_in_ordSqlFragment1379 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_STRING_in_ordSqlFragment1389 = new BitSet(new long[]{0x0000020218000000L});
	public static final BitSet FOLLOW_constant_in_ordSqlFragment1393 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_PERCENT_in_ordSqlFragment1402 = new BitSet(new long[]{0x0000000018000000L});
	public static final BitSet FOLLOW_dbcolumn_in_ordSqlFragment1406 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_IDENT_DOT_in_column1443 = new BitSet(new long[]{0x0000002098000002L});
	public static final BitSet FOLLOW_IDENT_in_column1449 = new BitSet(new long[]{0x0000002098000002L});
	public static final BitSet FOLLOW_NUMBER_in_column1455 = new BitSet(new long[]{0x0000002098000002L});
	public static final BitSet FOLLOW_LPAREN_in_column1471 = new BitSet(new long[]{0x0000002008000000L});
	public static final BitSet FOLLOW_IDENT_in_column1476 = new BitSet(new long[]{0x0000200000000400L});
	public static final BitSet FOLLOW_NUMBER_in_column1482 = new BitSet(new long[]{0x0000200000000400L});
	public static final BitSet FOLLOW_COMMA_in_column1499 = new BitSet(new long[]{0x0000002008000000L});
	public static final BitSet FOLLOW_IDENT_in_column1504 = new BitSet(new long[]{0x0000200000000400L});
	public static final BitSet FOLLOW_NUMBER_in_column1510 = new BitSet(new long[]{0x0000200000000400L});
	public static final BitSet FOLLOW_RPAREN_in_column1520 = new BitSet(new long[]{0x0000002018000002L});
	public static final BitSet FOLLOW_IDENT_DOT_in_column1544 = new BitSet(new long[]{0x0000002098000002L});
	public static final BitSet FOLLOW_IDENT_in_column1550 = new BitSet(new long[]{0x0000002098000002L});
	public static final BitSet FOLLOW_NUMBER_in_column1556 = new BitSet(new long[]{0x0000002098000002L});
	public static final BitSet FOLLOW_LPAREN_in_column1573 = new BitSet(new long[]{0x0000002008000000L});
	public static final BitSet FOLLOW_IDENT_in_column1578 = new BitSet(new long[]{0x0000200000000400L});
	public static final BitSet FOLLOW_NUMBER_in_column1584 = new BitSet(new long[]{0x0000200000000400L});
	public static final BitSet FOLLOW_COMMA_in_column1602 = new BitSet(new long[]{0x0000002008000000L});
	public static final BitSet FOLLOW_IDENT_in_column1607 = new BitSet(new long[]{0x0000200000000400L});
	public static final BitSet FOLLOW_NUMBER_in_column1613 = new BitSet(new long[]{0x0000200000000400L});
	public static final BitSet FOLLOW_RPAREN_in_column1624 = new BitSet(new long[]{0x0000002018000002L});
	public static final BitSet FOLLOW_PLUS_in_constant1658 = new BitSet(new long[]{0x0000000018000000L});
	public static final BitSet FOLLOW_MINUS_in_constant1664 = new BitSet(new long[]{0x0000000018000000L});
	public static final BitSet FOLLOW_IDENT_DOT_in_constant1671 = new BitSet(new long[]{0x0000000080000002L});
	public static final BitSet FOLLOW_IDENT_in_constant1677 = new BitSet(new long[]{0x0000000080000002L});
	public static final BitSet FOLLOW_LPAREN_in_constant1693 = new BitSet(new long[]{0x0000003008000000L});
	public static final BitSet FOLLOW_NOT_in_constant1697 = new BitSet(new long[]{0x0000002008000000L});
	public static final BitSet FOLLOW_IDENT_in_constant1703 = new BitSet(new long[]{0x0000200000000400L});
	public static final BitSet FOLLOW_NUMBER_in_constant1709 = new BitSet(new long[]{0x0000200000000400L});
	public static final BitSet FOLLOW_COMMA_in_constant1726 = new BitSet(new long[]{0x0000003008000000L});
	public static final BitSet FOLLOW_NOT_in_constant1730 = new BitSet(new long[]{0x0000002008000000L});
	public static final BitSet FOLLOW_IDENT_in_constant1736 = new BitSet(new long[]{0x0000200000000400L});
	public static final BitSet FOLLOW_NUMBER_in_constant1742 = new BitSet(new long[]{0x0000200000000400L});
	public static final BitSet FOLLOW_RPAREN_in_constant1752 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_EQUALS_in_identifier1781 = new BitSet(new long[]{0x0000022218000000L});
	public static final BitSet FOLLOW_LESS_THAN_in_identifier1787 = new BitSet(new long[]{0x0000022218000000L});
	public static final BitSet FOLLOW_MORE_THAN_in_identifier1793 = new BitSet(new long[]{0x0000022218000000L});
	public static final BitSet FOLLOW_PLUS_in_identifier1800 = new BitSet(new long[]{0x0000002018000000L});
	public static final BitSet FOLLOW_MINUS_in_identifier1806 = new BitSet(new long[]{0x0000002018000000L});
	public static final BitSet FOLLOW_IDENT_DOT_in_identifier1813 = new BitSet(new long[]{0x0000000080000002L});
	public static final BitSet FOLLOW_IDENT_in_identifier1819 = new BitSet(new long[]{0x0000000080000002L});
	public static final BitSet FOLLOW_NUMBER_in_identifier1825 = new BitSet(new long[]{0x0000000080000002L});
	public static final BitSet FOLLOW_LPAREN_in_identifier1841 = new BitSet(new long[]{0x0000003008000000L});
	public static final BitSet FOLLOW_NOT_in_identifier1845 = new BitSet(new long[]{0x0000002008000000L});
	public static final BitSet FOLLOW_IDENT_in_identifier1851 = new BitSet(new long[]{0x0000200000000400L});
	public static final BitSet FOLLOW_NUMBER_in_identifier1857 = new BitSet(new long[]{0x0000200000000400L});
	public static final BitSet FOLLOW_COMMA_in_identifier1874 = new BitSet(new long[]{0x0000003008000000L});
	public static final BitSet FOLLOW_NOT_in_identifier1878 = new BitSet(new long[]{0x0000002008000000L});
	public static final BitSet FOLLOW_IDENT_in_identifier1884 = new BitSet(new long[]{0x0000200000000400L});
	public static final BitSet FOLLOW_NUMBER_in_identifier1890 = new BitSet(new long[]{0x0000200000000400L});
	public static final BitSet FOLLOW_RPAREN_in_identifier1900 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_IDENT_in_constantOperator1973 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_EQUALS_in_constantOperator1981 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_IDENT_in_identifierOperator2074 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_EQUALS_in_identifierOperator2082 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_IDENT_DOT_in_dbcolumn2130 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_IDENT_in_dbcolumn2136 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_IDENT_DOT_in_dbtable2163 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_IDENT_in_dbtable2169 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_WS_in_mapping2207 = new BitSet(new long[]{0x0004002008000000L});
	public static final BitSet FOLLOW_mappingItem_in_mapping2214 = new BitSet(new long[]{0x0004000000000002L});
	public static final BitSet FOLLOW_WS_in_mapping2221 = new BitSet(new long[]{0x0004002008000000L});
	public static final BitSet FOLLOW_mappingItem_in_mapping2226 = new BitSet(new long[]{0x0004000000000002L});
	public static final BitSet FOLLOW_WS_in_mapping2234 = new BitSet(new long[]{0x0004000000000002L});
	public static final BitSet FOLLOW_EOF_in_mapping2238 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_IDENT_in_mappingItem2273 = new BitSet(new long[]{0x0002000000000002L});
	public static final BitSet FOLLOW_NUMBER_in_mappingItem2279 = new BitSet(new long[]{0x0002000000000002L});
	public static final BitSet FOLLOW_STRING_in_mappingItem2289 = new BitSet(new long[]{0x0000002018000000L});
	public static final BitSet FOLLOW_IDENT_DOT_in_mappingItem2294 = new BitSet(new long[]{0x0000002098000002L});
	public static final BitSet FOLLOW_IDENT_in_mappingItem2300 = new BitSet(new long[]{0x0000002098000002L});
	public static final BitSet FOLLOW_NUMBER_in_mappingItem2306 = new BitSet(new long[]{0x0000002098000002L});
	public static final BitSet FOLLOW_LPAREN_in_mappingItem2323 = new BitSet(new long[]{0x0000002008000000L});
	public static final BitSet FOLLOW_IDENT_in_mappingItem2328 = new BitSet(new long[]{0x0000200000000400L});
	public static final BitSet FOLLOW_NUMBER_in_mappingItem2334 = new BitSet(new long[]{0x0000200000000400L});
	public static final BitSet FOLLOW_COMMA_in_mappingItem2352 = new BitSet(new long[]{0x0000002008000000L});
	public static final BitSet FOLLOW_IDENT_in_mappingItem2357 = new BitSet(new long[]{0x0000200000000400L});
	public static final BitSet FOLLOW_NUMBER_in_mappingItem2363 = new BitSet(new long[]{0x0000200000000400L});
	public static final BitSet FOLLOW_RPAREN_in_mappingItem2374 = new BitSet(new long[]{0x0000002098000002L});
	public static final BitSet FOLLOW_IDENT_DOT_in_mappingItem2390 = new BitSet(new long[]{0x0000002098000002L});
	public static final BitSet FOLLOW_IDENT_in_mappingItem2396 = new BitSet(new long[]{0x0000002098000002L});
	public static final BitSet FOLLOW_NUMBER_in_mappingItem2402 = new BitSet(new long[]{0x0000002098000002L});
	public static final BitSet FOLLOW_LPAREN_in_mappingItem2420 = new BitSet(new long[]{0x0000002008000000L});
	public static final BitSet FOLLOW_IDENT_in_mappingItem2425 = new BitSet(new long[]{0x0000200000000400L});
	public static final BitSet FOLLOW_NUMBER_in_mappingItem2431 = new BitSet(new long[]{0x0000200000000400L});
	public static final BitSet FOLLOW_COMMA_in_mappingItem2450 = new BitSet(new long[]{0x0000002008000000L});
	public static final BitSet FOLLOW_IDENT_in_mappingItem2455 = new BitSet(new long[]{0x0000200000000400L});
	public static final BitSet FOLLOW_NUMBER_in_mappingItem2461 = new BitSet(new long[]{0x0000200000000400L});
	public static final BitSet FOLLOW_RPAREN_in_mappingItem2473 = new BitSet(new long[]{0x0000002098000002L});
	public static final BitSet FOLLOW_set_in_option2520 = new BitSet(new long[]{0x0007BFFFFFFFFFF2L});
}
