/*
 * Decompiled with CFR 0.152.
 */
package com.intigua.antlr4.autosuggest;

import com.intigua.antlr4.autosuggest.CasePreference;
import com.intigua.antlr4.autosuggest.DefaultToCharStream;
import com.intigua.antlr4.autosuggest.LexerAndParserFactory;
import com.intigua.antlr4.autosuggest.LexerWrapper;
import com.intigua.antlr4.autosuggest.ParserWrapper;
import com.intigua.antlr4.autosuggest.TokenSuggester;
import com.intigua.antlr4.autosuggest.TransitionWrapper;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.atn.ATNState;
import org.antlr.v4.runtime.atn.AtomTransition;
import org.antlr.v4.runtime.atn.SetTransition;
import org.antlr.v4.runtime.atn.Transition;
import org.antlr.v4.runtime.misc.Interval;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoSuggester {
    private static final Logger logger = LoggerFactory.getLogger(AutoSuggester.class);
    private final ParserWrapper parserWrapper;
    private final LexerWrapper lexerWrapper;
    private final String input;
    private final Set<String> collectedSuggestions = new HashSet<String>();
    private List<? extends Token> inputTokens;
    private String untokenizedText = "";
    private String indent = "";
    private CasePreference casePreference = CasePreference.BOTH;
    private Map<ATNState, Integer> parserStateToTokenListIndexWhereLastVisited = new HashMap<ATNState, Integer>();

    public AutoSuggester(LexerAndParserFactory lexerAndParserFactory, String input) {
        this.lexerWrapper = new LexerWrapper(lexerAndParserFactory, new DefaultToCharStream());
        this.parserWrapper = new ParserWrapper(lexerAndParserFactory, this.lexerWrapper.getVocabulary());
        this.input = input;
    }

    public void setCasePreference(CasePreference casePreference) {
        this.casePreference = casePreference;
    }

    public Collection<String> suggestCompletions() {
        this.tokenizeInput();
        this.runParserAtnAndCollectSuggestions();
        return this.collectedSuggestions;
    }

    private void tokenizeInput() {
        LexerWrapper.TokenizationResult tokenizationResult = this.lexerWrapper.tokenizeNonDefaultChannel(this.input);
        this.inputTokens = tokenizationResult.tokens;
        this.untokenizedText = tokenizationResult.untokenizedText;
        if (logger.isDebugEnabled()) {
            logger.debug("TOKENS FOUND IN FIRST PASS:");
            for (Token token : this.inputTokens) {
                logger.debug(token.toString());
            }
        }
    }

    private void runParserAtnAndCollectSuggestions() {
        ATNState initialState = this.parserWrapper.getAtnState(0);
        logger.debug("Parser initial state: " + initialState);
        this.parseAndCollectTokenSuggestions(initialState, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseAndCollectTokenSuggestions(ATNState parserState, int tokenListIndex) {
        this.indent = this.indent + "  ";
        if (this.didVisitParserStateOnThisTokenIndex(parserState, tokenListIndex)) {
            logger.debug(this.indent + "State " + parserState + " had already been visited while processing token " + tokenListIndex + ", backtracking to avoid infinite loop.");
            return;
        }
        Integer previousTokenListIndexForThisState = this.setParserStateLastVisitedOnThisTokenIndex(parserState, tokenListIndex);
        try {
            if (logger.isDebugEnabled()) {
                logger.debug(this.indent + "State: " + this.parserWrapper.toString(parserState));
                logger.debug(this.indent + "State available transitions: " + this.parserWrapper.transitionsStr(parserState));
            }
            if (!this.haveMoreTokens(tokenListIndex)) {
                this.suggestNextTokensForParserState(parserState);
                return;
            }
            for (Transition trans : parserState.getTransitions()) {
                if (trans.isEpsilon()) {
                    this.handleEpsilonTransition(trans, tokenListIndex);
                    continue;
                }
                if (trans instanceof AtomTransition) {
                    this.handleAtomicTransition((AtomTransition)trans, tokenListIndex);
                    continue;
                }
                this.handleSetTransition((SetTransition)trans, tokenListIndex);
            }
        }
        finally {
            this.indent = this.indent.substring(2);
            this.setParserStateLastVisitedOnThisTokenIndex(parserState, previousTokenListIndexForThisState);
        }
    }

    private boolean didVisitParserStateOnThisTokenIndex(ATNState parserState, Integer currentTokenListIndex) {
        Integer lastVisitedThisStateAtTokenListIndex = this.parserStateToTokenListIndexWhereLastVisited.get(parserState);
        return currentTokenListIndex.equals(lastVisitedThisStateAtTokenListIndex);
    }

    private Integer setParserStateLastVisitedOnThisTokenIndex(ATNState parserState, Integer tokenListIndex) {
        if (tokenListIndex == null) {
            return this.parserStateToTokenListIndexWhereLastVisited.remove(parserState);
        }
        return this.parserStateToTokenListIndexWhereLastVisited.put(parserState, tokenListIndex);
    }

    private boolean haveMoreTokens(int tokenListIndex) {
        return tokenListIndex < this.inputTokens.size();
    }

    private void handleEpsilonTransition(Transition trans, int tokenListIndex) {
        this.parseAndCollectTokenSuggestions(trans.target, tokenListIndex);
    }

    private void handleAtomicTransition(AtomTransition trans, int tokenListIndex) {
        boolean nextTokenMatchesTransition;
        Token nextToken = this.inputTokens.get(tokenListIndex);
        int nextTokenType = this.inputTokens.get(tokenListIndex).getType();
        boolean bl = nextTokenMatchesTransition = trans.label == nextTokenType;
        if (nextTokenMatchesTransition) {
            logger.debug(this.indent + "Token " + nextToken + " following transition: " + this.parserWrapper.toString((Transition)trans));
            this.parseAndCollectTokenSuggestions(trans.target, tokenListIndex + 1);
        } else {
            logger.debug(this.indent + "Token " + nextToken + " NOT following transition: " + this.parserWrapper.toString((Transition)trans));
        }
    }

    private void handleSetTransition(SetTransition trans, int tokenListIndex) {
        Token nextToken = this.inputTokens.get(tokenListIndex);
        int nextTokenType = nextToken.getType();
        Iterator iterator = trans.label().toList().iterator();
        while (iterator.hasNext()) {
            boolean nextTokenMatchesTransition;
            int transitionTokenType = (Integer)iterator.next();
            boolean bl = nextTokenMatchesTransition = transitionTokenType == nextTokenType;
            if (nextTokenMatchesTransition) {
                logger.debug(this.indent + "Token " + nextToken + " following transition: " + this.parserWrapper.toString((Transition)trans) + " to " + transitionTokenType);
                this.parseAndCollectTokenSuggestions(trans.target, tokenListIndex + 1);
                continue;
            }
            logger.debug(this.indent + "Token " + nextToken + " NOT following transition: " + this.parserWrapper.toString((Transition)trans) + " to " + transitionTokenType);
        }
    }

    private void suggestNextTokensForParserState(ATNState parserState) {
        HashSet<Integer> transitionLabels = new HashSet<Integer>();
        this.fillParserTransitionLabels(parserState, transitionLabels, new HashSet<TransitionWrapper>());
        TokenSuggester tokenSuggester = new TokenSuggester(this.untokenizedText, this.lexerWrapper, this.casePreference);
        Collection<String> suggestions = tokenSuggester.suggest(transitionLabels);
        this.parseSuggestionsAndAddValidOnes(parserState, suggestions);
        logger.debug(this.indent + "WILL SUGGEST TOKENS FOR STATE: " + parserState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fillParserTransitionLabels(ATNState parserState, Collection<Integer> result, Set<TransitionWrapper> visitedTransitions) {
        for (Transition trans : parserState.getTransitions()) {
            TransitionWrapper transWrapper = new TransitionWrapper(parserState, trans);
            if (visitedTransitions.contains(transWrapper)) {
                logger.debug(this.indent + "Not following visited " + transWrapper);
                continue;
            }
            if (trans.isEpsilon()) {
                try {
                    visitedTransitions.add(transWrapper);
                    this.fillParserTransitionLabels(trans.target, result, visitedTransitions);
                    continue;
                }
                finally {
                    visitedTransitions.remove(transWrapper);
                }
            }
            if (trans instanceof AtomTransition) {
                int label = ((AtomTransition)trans).label;
                if (label < 1) continue;
                result.add(label);
                continue;
            }
            if (!(trans instanceof SetTransition)) continue;
            for (Interval interval : ((SetTransition)trans).label().getIntervals()) {
                for (int i = interval.a; i <= interval.b; ++i) {
                    result.add(i);
                }
            }
        }
    }

    private void parseSuggestionsAndAddValidOnes(ATNState parserState, Collection<String> suggestions) {
        for (String suggestion : suggestions) {
            logger.debug("CHECKING suggestion: " + suggestion);
            Token addedToken = this.getAddedToken(suggestion);
            if (this.isParseableWithAddedToken(parserState, addedToken, new HashSet<TransitionWrapper>())) {
                this.collectedSuggestions.add(suggestion);
                continue;
            }
            logger.debug("DROPPING non-parseable suggestion: " + suggestion);
        }
    }

    private Token getAddedToken(String suggestedCompletion) {
        String completedText = this.input + suggestedCompletion;
        List<? extends Token> completedTextTokens = this.lexerWrapper.tokenizeNonDefaultChannel((String)completedText).tokens;
        if (completedTextTokens.size() <= this.inputTokens.size()) {
            return null;
        }
        logger.debug("TOKENS IN COMPLETED TEXT: " + completedTextTokens);
        Token newToken = completedTextTokens.get(completedTextTokens.size() - 1);
        return newToken;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isParseableWithAddedToken(ATNState parserState, Token newToken, Set<TransitionWrapper> visitedTransitions) {
        if (newToken == null) {
            return false;
        }
        for (Transition parserTransition : parserState.getTransitions()) {
            if (parserTransition.isEpsilon()) {
                TransitionWrapper transWrapper = new TransitionWrapper(parserState, parserTransition);
                if (visitedTransitions.contains(transWrapper)) continue;
                visitedTransitions.add(transWrapper);
                try {
                    if (!this.isParseableWithAddedToken(parserTransition.target, newToken, visitedTransitions)) continue;
                    boolean bl = true;
                    return bl;
                }
                finally {
                    visitedTransitions.remove(transWrapper);
                }
            }
            if (parserTransition instanceof AtomTransition) {
                AtomTransition parserAtomTransition = (AtomTransition)parserTransition;
                int transitionTokenType = parserAtomTransition.label;
                if (transitionTokenType != newToken.getType()) continue;
                return true;
            }
            if (parserTransition instanceof SetTransition) {
                SetTransition parserSetTransition = (SetTransition)parserTransition;
                Iterator iterator = parserSetTransition.label().toList().iterator();
                while (iterator.hasNext()) {
                    int transitionTokenType = (Integer)iterator.next();
                    if (transitionTokenType != newToken.getType()) continue;
                    return true;
                }
                continue;
            }
            throw new IllegalStateException("Unexpected: " + this.parserWrapper.toString(parserTransition));
        }
        return false;
    }
}

