/*
 * Decompiled with CFR 0.152.
 */
package video.api.integration;

import java.io.File;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.condition.EnabledIfEnvironmentVariable;
import video.api.client.ApiVideoClient;
import video.api.client.api.ApiException;
import video.api.client.api.models.Metadata;
import video.api.client.api.models.Page;
import video.api.client.api.models.Video;
import video.api.client.api.models.VideoCreationPayload;
import video.api.client.api.models.VideoStatus;
import video.api.client.api.models.VideoThumbnailPickPayload;
import video.api.client.api.models.VideoUpdatePayload;

@DisplayName(value="Integration tests of api.videos() methods")
@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@EnabledIfEnvironmentVariable(named="INTEGRATION_TESTS_API_TOKEN", matches=".+")
public class VideosTest {
    ApiVideoClient apiClient = new ApiVideoClient(System.getenv().get("INTEGRATION_TESTS_API_TOKEN"), ApiVideoClient.Environment.SANDBOX);

    @Nested
    @DisplayName(value="video status")
    @TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
    class VideoStatusTest {
        private Video testVideo;

        VideoStatusTest() {
        }

        @BeforeAll
        public void createVideo() throws ApiException {
            this.testVideo = VideosTest.this.apiClient.videos().create(new VideoCreationPayload().title("[Java-SDK-tests] videoStatus"));
        }

        @Test
        public void getVideoStatus() throws ApiException {
            VideoStatus videoStatus = VideosTest.this.apiClient.videos().getStatus(this.testVideo.getVideoId());
            Assertions.assertThat((Object)videoStatus.getIngest()).isNull();
            Assertions.assertThat((Object)videoStatus.getEncoding()).isNotNull();
            Assertions.assertThat((Boolean)videoStatus.getEncoding().getPlayable()).isFalse();
        }

        @AfterAll
        public void deleteVideo() throws ApiException {
            VideosTest.this.apiClient.videos().delete(this.testVideo.getVideoId());
        }
    }

    @Nested
    @DisplayName(value="thumbnail")
    @TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
    class Thumbnail {
        private Video testVideo;

        Thumbnail() {
        }

        @BeforeAll
        public void createVideo() throws ApiException {
            this.testVideo = VideosTest.this.apiClient.videos().create(new VideoCreationPayload().title("[Java-SDK-tests] thumbnail"));
        }

        @Test
        public void uploadThumbnail() throws ApiException {
            File jpgFile = new File(this.getClass().getResource("/assets/cat.jpg").getFile());
            Video video = VideosTest.this.apiClient.videos().uploadThumbnail(this.testVideo.getVideoId(), jpgFile);
            Assertions.assertThat((Object)video.getAssets()).isNotNull();
            Assertions.assertThat((URI)video.getAssets().getThumbnail()).isNotNull();
        }

        @Test
        public void pickThumbnail() throws ApiException {
            Video video = VideosTest.this.apiClient.videos().pickThumbnail(this.testVideo.getVideoId(), new VideoThumbnailPickPayload().timecode("00:00:02"));
            Assertions.assertThat((Object)video.getAssets()).isNotNull();
            Assertions.assertThat((URI)video.getAssets().getThumbnail()).isNotNull();
        }

        @AfterAll
        public void deleteVideo() throws ApiException {
            VideosTest.this.apiClient.videos().delete(this.testVideo.getVideoId());
        }
    }

    @Nested
    @DisplayName(value="list with tags")
    @TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
    class ListWithTags {
        private Video testVideo;

        ListWithTags() {
        }

        @BeforeAll
        public void createVideo() throws ApiException {
            this.testVideo = VideosTest.this.apiClient.videos().create(new VideoCreationPayload().tags(Arrays.asList("tag1", "tag2")).title("[Java-SDK-tests] list tags"));
        }

        @Test
        public void listTagNotFound() throws ApiException {
            Page page = VideosTest.this.apiClient.videos().list().tags(Collections.singletonList("valueNotFound")).execute();
            Assertions.assertThat((Integer)page.getItemsTotal()).isEqualTo(0);
        }

        @Test
        public void listTagFound() throws ApiException {
            Page page = VideosTest.this.apiClient.videos().list().tags(Arrays.asList("tag1", "tag2")).execute();
            Assertions.assertThat((Integer)page.getItemsTotal()).isGreaterThan(0);
        }

        @AfterAll
        public void deleteVideo() throws ApiException {
            VideosTest.this.apiClient.videos().delete(this.testVideo.getVideoId());
        }
    }

    @Nested
    @DisplayName(value="list with metadata")
    @TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
    class ListWithMetadata {
        private Video testVideo;

        ListWithMetadata() {
        }

        @BeforeAll
        public void createVideo() throws ApiException {
            this.testVideo = VideosTest.this.apiClient.videos().create(new VideoCreationPayload().metadata(Collections.singletonList(new Metadata("key1", "value1"))).title("[Java-SDK-tests] list metadatas"));
        }

        @Test
        public void listMetadataNotFound() throws ApiException {
            HashMap<String, String> metadata = new HashMap<String, String>();
            metadata.put("key1", "valueNotFound");
            Page page = VideosTest.this.apiClient.videos().list().metadata(metadata).execute();
            Assertions.assertThat((Integer)page.getItemsTotal()).isEqualTo(0);
        }

        @Test
        public void listMetadataFound() throws ApiException {
            HashMap<String, String> metadata = new HashMap<String, String>();
            metadata.put("key1", "value1");
            Page page = VideosTest.this.apiClient.videos().list().metadata(metadata).execute();
            Assertions.assertThat((Integer)page.getItemsTotal()).isGreaterThan(0);
        }

        @AfterAll
        public void deleteVideo() throws ApiException {
            VideosTest.this.apiClient.videos().delete(this.testVideo.getVideoId());
        }
    }

    @Nested
    @DisplayName(value="get")
    @TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
    class Get {
        private Video testVideo;

        Get() {
        }

        @BeforeAll
        public void createVideo() throws ApiException {
            this.testVideo = VideosTest.this.apiClient.videos().create(new VideoCreationPayload().title("[Java-SDK-tests] get"));
        }

        @Test
        public void get() throws ApiException {
            Video video = VideosTest.this.apiClient.videos().get(this.testVideo.getVideoId());
            Assertions.assertThat((String)video.getVideoId()).isEqualTo(this.testVideo.getVideoId());
            Assertions.assertThat((String)video.getTitle()).isEqualTo(this.testVideo.getTitle());
        }

        @AfterAll
        public void deleteVideo() throws ApiException {
            VideosTest.this.apiClient.videos().delete(this.testVideo.getVideoId());
        }
    }

    @Nested
    @DisplayName(value="update")
    @TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
    class Update {
        private Video testVideo;

        Update() {
        }

        @BeforeAll
        public void createVideo() throws ApiException {
            this.testVideo = VideosTest.this.apiClient.videos().create(new VideoCreationPayload().title("[Java-SDK-tests] video updates"));
        }

        @Test
        public void addMetadata() throws ApiException {
            Video updated = VideosTest.this.apiClient.videos().update(this.testVideo.getVideoId(), new VideoUpdatePayload().addMetadataItem(new Metadata("firstKey", "firstValue")).addMetadataItem(new Metadata("secondKey", "secondValue")));
            Assertions.assertThat((List)updated.getMetadata()).containsExactlyInAnyOrder((Object[])new Metadata[]{new Metadata("firstKey", "firstValue"), new Metadata("secondKey", "secondValue")});
            Video updated2 = VideosTest.this.apiClient.videos().update(this.testVideo.getVideoId(), new VideoUpdatePayload().metadata(updated.addMetadataItem(new Metadata("thirdKey", "thirdValue")).getMetadata()));
            Assertions.assertThat((List)updated2.getMetadata()).containsExactlyInAnyOrder((Object[])new Metadata[]{new Metadata("firstKey", "firstValue"), new Metadata("secondKey", "secondValue"), new Metadata("thirdKey", "thirdValue")});
            Video updated3 = VideosTest.this.apiClient.videos().update(this.testVideo.getVideoId(), new VideoUpdatePayload().metadata(Collections.emptyList()));
            Assertions.assertThat((List)updated3.getMetadata()).isEmpty();
        }

        @AfterAll
        public void deleteVideo() throws ApiException {
            VideosTest.this.apiClient.videos().delete(this.testVideo.getVideoId());
        }
    }

    @Nested
    @DisplayName(value="upload without chunk")
    @TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
    class Upload {
        private Video testVideo;

        Upload() {
        }

        @BeforeAll
        public void createVideo() throws ApiException {
            this.testVideo = VideosTest.this.apiClient.videos().create(new VideoCreationPayload().title("[Java-SDK-tests] upload without chunk"));
        }

        @Test
        public void uploadVideo() throws ApiException {
            File mp4File = new File(this.getClass().getResource("/assets/558k.mp4").getFile());
            long fileSize = mp4File.length();
            long chunkSize = VideosTest.this.apiClient.getHttpClient().getUploadChunkSize();
            AtomicLong totalUploadedAtomic = new AtomicLong(0L);
            AtomicLong totalBytesAtomic = new AtomicLong(0L);
            AtomicLong chunkCountAtomic = new AtomicLong(0L);
            HashSet seenChunkNums = new HashSet();
            VideosTest.this.apiClient.videos().upload(this.testVideo.getVideoId(), mp4File, (bytesWritten, totalBytes, chunkCount, chunkNum) -> {
                totalUploadedAtomic.set(bytesWritten);
                totalBytesAtomic.set(totalBytes);
                chunkCountAtomic.set(chunkCount);
                seenChunkNums.add(chunkNum);
            });
            Assertions.assertThat((long)totalBytesAtomic.get()).isEqualTo(fileSize);
            Assertions.assertThat((long)totalUploadedAtomic.get()).isEqualTo(fileSize);
            Assertions.assertThat((long)chunkCountAtomic.get()).isEqualTo(1L);
            Assertions.assertThat(seenChunkNums).containsExactly((Object[])new Integer[]{1});
        }

        @AfterAll
        public void deleteVideo() throws ApiException {
            VideosTest.this.apiClient.videos().delete(this.testVideo.getVideoId());
        }
    }

    @Nested
    @DisplayName(value="upload by chunk")
    @TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
    class UploadByChunk {
        private Video testVideo;

        UploadByChunk() {
        }

        @BeforeAll
        public void createVideo() throws ApiException {
            this.testVideo = VideosTest.this.apiClient.videos().create(new VideoCreationPayload().title("[Java-SDK-tests] upload with chunk")._public(Boolean.valueOf(false)));
        }

        @Test
        public void uploadVideo() throws ApiException {
            File mp4File = new File(this.getClass().getResource("/assets/10m.mp4").getFile());
            long fileSize = mp4File.length();
            int chunkSize = 0x500000;
            VideosTest.this.apiClient.getHttpClient().setUploadChunkSize((long)chunkSize);
            AtomicLong totalUploadedAtomic = new AtomicLong(0L);
            AtomicLong totalBytesAtomic = new AtomicLong(0L);
            AtomicLong chunkCountAtomic = new AtomicLong(0L);
            HashSet seenChunkNums = new HashSet();
            VideosTest.this.apiClient.videos().upload(this.testVideo.getVideoId(), mp4File, (bytesWritten, totalBytes, chunkCount, chunkNum) -> {
                totalUploadedAtomic.set(bytesWritten);
                totalBytesAtomic.set(totalBytes);
                chunkCountAtomic.set(chunkCount);
                seenChunkNums.add(chunkNum);
            });
            Assertions.assertThat((long)totalBytesAtomic.get()).isEqualTo(fileSize);
            Assertions.assertThat((long)totalUploadedAtomic.get()).isEqualTo(fileSize);
            Assertions.assertThat((long)chunkCountAtomic.get()).isEqualTo(new Double(Math.ceil((float)fileSize / (float)chunkSize)).longValue());
            Assertions.assertThat(seenChunkNums).containsExactly((Object[])new Integer[]{1, 2, 3});
            System.out.println(this.testVideo);
        }

        @AfterAll
        public void deleteVideo() throws ApiException {
            VideosTest.this.apiClient.videos().delete(this.testVideo.getVideoId());
        }
    }
}

