/*
 * Decompiled with CFR 0.152.
 */
package video.api.client.api.upload;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okhttp3.internal.Util;
import okio.BufferedSink;
import okio.Okio;
import okio.Source;
import video.api.client.api.ApiException;
import video.api.client.api.upload.UploadPartProgressListener;
import video.api.client.api.upload.UploadProgressListener;

public class UploadChunkRequestBody
extends RequestBody {
    private final InputStream inputStream;
    private final long chunkLength;
    private final String fileName;

    public UploadChunkRequestBody(File file, Integer chunksCount, Integer chunkNum, long totalBytes, long chunkStart, long chunkEnd, UploadProgressListener progressListener) throws ApiException {
        this.chunkLength = chunkEnd - chunkStart;
        this.fileName = file.getName();
        try {
            this.inputStream = new ChunkedInputStream(file, chunkStart, chunkEnd, progress -> {
                if (progressListener != null) {
                    progressListener.onProgress((Long)progress, totalBytes, chunksCount, chunkNum);
                }
            });
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
    }

    public UploadChunkRequestBody(File file, long totalBytes, UploadPartProgressListener progressListener) throws ApiException {
        this.chunkLength = totalBytes;
        this.fileName = file.getName();
        try {
            this.inputStream = new ChunkedInputStream(file, 0L, totalBytes, progress -> {
                if (progressListener != null) {
                    progressListener.onProgress((Long)progress, totalBytes);
                }
            });
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
    }

    @Nullable
    public MediaType contentType() {
        return MediaType.parse((String)"video/mp4");
    }

    public long contentLength() {
        return this.chunkLength;
    }

    public void writeTo(BufferedSink sink) throws IOException {
        Source source = null;
        try {
            source = Okio.source((InputStream)this.inputStream);
            sink.writeAll(source);
        }
        finally {
            Util.closeQuietly((Closeable)source);
        }
    }

    public String getFileName() {
        return this.fileName;
    }

    private static class ChunkedInputStream
    extends InputStream {
        private final long start;
        private final InputStream source;
        private final long end;
        private final Consumer<Long> progressListener;
        private long pos = 0L;

        public ChunkedInputStream(File file, long start, long end, Consumer<Long> progressListener) throws IOException {
            this.source = new FileInputStream(file);
            this.start = start;
            this.end = end;
            this.progressListener = progressListener;
            progressListener.accept(start);
            this.source.skip(start);
        }

        @Override
        public int read() throws IOException {
            if (this.start + this.pos < this.end) {
                ++this.pos;
                if (this.start + this.pos % 1024L == 0L) {
                    this.progressListener.accept(this.start + this.pos);
                }
                return this.source.read();
            }
            this.progressListener.accept(this.start + this.pos);
            return -1;
        }
    }
}

