/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.afp.util;

import java.io.ByteArrayOutputStream;

public final class BinaryUtils {
    private BinaryUtils() {
    }

    public static byte[] convert(int integer, int bufsize) {
        int size2;
        StringBuffer buf = new StringBuffer(Integer.toHexString(integer));
        if (buf.length() % 2 != 0) {
            buf.insert(0, "0");
        }
        if ((size2 = buf.length() / 2) > bufsize) {
            buf.delete(0, buf.length() - bufsize * 2);
        } else {
            while (size2 < bufsize) {
                buf.insert(0, "00");
                ++size2;
            }
        }
        return BinaryUtils.convert(buf.toString());
    }

    public static byte[] convert(int integer) {
        return BinaryUtils.convert(Integer.toHexString(integer));
    }

    public static byte[] convert(String digits) {
        if (digits.length() % 2 != 0) {
            digits = "0" + digits;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        for (int i = 0; i < digits.length(); i += 2) {
            char c1 = digits.charAt(i);
            char c2 = digits.charAt(i + 1);
            int b = 0;
            if (c1 >= '0' && c1 <= '9') {
                b = (byte)(b + (c1 - 48) * 16);
            } else if (c1 >= 'a' && c1 <= 'f') {
                b = (byte)(b + (c1 - 97 + 10) * 16);
            } else if (c1 >= 'A' && c1 <= 'F') {
                b = (byte)(b + (c1 - 65 + 10) * 16);
            } else {
                throw new IllegalArgumentException("Bad hexadecimal digit");
            }
            if (c2 >= '0' && c2 <= '9') {
                b = (byte)(b + (c2 - 48));
            } else if (c2 >= 'a' && c2 <= 'f') {
                b = (byte)(b + (c2 - 97 + 10));
            } else if (c2 >= 'A' && c2 <= 'F') {
                b = (byte)(b + (c2 - 65 + 10));
            } else {
                throw new IllegalArgumentException("Bad hexadecimal digit");
            }
            baos.write(b);
        }
        return baos.toByteArray();
    }

    public static void shortToByteArray(short value2, byte[] array, int offset) {
        array[offset] = (byte)(value2 >>> 8);
        array[offset + 1] = (byte)value2;
    }

    public static byte[] shortToByteArray(short value2) {
        byte[] serverValue = new byte[2];
        BinaryUtils.shortToByteArray(value2, serverValue, 0);
        return serverValue;
    }
}

