/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.complexscripts.bidi;

import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import org.apache.fop.area.inline.Anchor;
import org.apache.fop.area.inline.InlineArea;
import org.apache.fop.area.inline.InlineBlockParent;
import org.apache.fop.area.inline.InlineParent;
import org.apache.fop.area.inline.InlineViewport;
import org.apache.fop.area.inline.Leader;
import org.apache.fop.area.inline.Space;
import org.apache.fop.area.inline.SpaceArea;
import org.apache.fop.area.inline.UnresolvedPageNumber;
import org.apache.fop.area.inline.WordArea;
import org.apache.fop.util.CharUtilities;

public class InlineRun {
    private InlineArea inline;
    private int[] levels;
    private int minLevel;
    private int maxLevel;
    private int reversals;

    public InlineRun(InlineArea inline2, int[] levels) {
        assert (inline2 != null);
        assert (levels != null);
        this.inline = inline2;
        this.levels = levels;
        this.setMinMax(levels);
    }

    public InlineRun(InlineArea inline2, int level, int count2) {
        this(inline2, InlineRun.makeLevels(level, count2));
    }

    public InlineArea getInline() {
        return this.inline;
    }

    public int getMinLevel() {
        return this.minLevel;
    }

    public int getMaxLevel() {
        return this.maxLevel;
    }

    private void setMinMax(int[] levels) {
        int mn = Integer.MAX_VALUE;
        int mx = Integer.MIN_VALUE;
        if (levels != null && levels.length > 0) {
            for (int l : levels) {
                if (l < mn) {
                    mn = l;
                }
                if (l <= mx) continue;
                mx = l;
            }
        } else {
            mx = -1;
            mn = -1;
        }
        this.minLevel = mn;
        this.maxLevel = mx;
    }

    public boolean isHomogenous() {
        return this.minLevel == this.maxLevel;
    }

    public List split() {
        Vector<InlineRun> runs = new Vector<InlineRun>();
        int i = 0;
        int n = this.levels.length;
        while (i < n) {
            int s2;
            int e;
            int l = this.levels[i];
            for (e = s2 = i; e < n && this.levels[e] == l; ++e) {
            }
            if (s2 < e) {
                runs.add(new InlineRun(this.inline, l, e - s2));
            }
            i = e;
        }
        assert (runs.size() < 2) : "heterogeneous inlines not yet supported!!";
        return runs;
    }

    public void updateMinMax(int[] mm) {
        if (this.minLevel < mm[0]) {
            mm[0] = this.minLevel;
        }
        if (this.maxLevel > mm[1]) {
            mm[1] = this.maxLevel;
        }
    }

    public boolean maybeNeedsMirroring() {
        return this.minLevel == this.maxLevel && (this.minLevel & 1) != 0;
    }

    public void reverse() {
        ++this.reversals;
    }

    public void maybeReverseWord(boolean mirror) {
        WordArea w;
        if (this.inline instanceof WordArea && !(w = (WordArea)this.inline).isReversed()) {
            if ((this.reversals & 1) != 0) {
                w.reverse(mirror);
            } else if (mirror && this.maybeNeedsMirroring()) {
                w.mirror();
            }
        }
    }

    public boolean equals(Object o) {
        if (o instanceof InlineRun) {
            InlineRun ir = (InlineRun)o;
            if (ir.inline != this.inline) {
                return false;
            }
            if (ir.minLevel != this.minLevel) {
                return false;
            }
            if (ir.maxLevel != this.maxLevel) {
                return false;
            }
            if (ir.levels != null && this.levels != null) {
                if (ir.levels.length != this.levels.length) {
                    return false;
                }
                int n = this.levels.length;
                for (int i = 0; i < n; ++i) {
                    if (ir.levels[i] == this.levels[i]) continue;
                    return false;
                }
                return true;
            }
            return ir.levels == null && this.levels == null;
        }
        return false;
    }

    public int hashCode() {
        int l = this.inline != null ? this.inline.hashCode() : 0;
        l = (l ^ this.minLevel) + (l << 19);
        l = (l ^ this.maxLevel) + (l << 11);
        return l;
    }

    public String toString() {
        int c;
        StringBuffer sb = new StringBuffer("RR: { type = '");
        String content = null;
        if (this.inline instanceof WordArea) {
            c = 87;
            content = ((WordArea)this.inline).getWord();
        } else if (this.inline instanceof SpaceArea) {
            c = 83;
            content = ((SpaceArea)this.inline).getSpace();
        } else if (this.inline instanceof Anchor) {
            c = 65;
        } else if (this.inline instanceof Leader) {
            c = 76;
        } else if (this.inline instanceof Space) {
            c = 83;
        } else if (this.inline instanceof UnresolvedPageNumber) {
            c = 35;
            content = ((UnresolvedPageNumber)this.inline).getText();
        } else {
            c = this.inline instanceof InlineBlockParent ? 66 : (this.inline instanceof InlineViewport ? 86 : (this.inline instanceof InlineParent ? 73 : 63));
        }
        sb.append((char)c);
        sb.append("', levels = '");
        sb.append(this.generateLevels(this.levels));
        sb.append("', min = ");
        sb.append(this.minLevel);
        sb.append(", max = ");
        sb.append(this.maxLevel);
        sb.append(", reversals = ");
        sb.append(this.reversals);
        sb.append(", content = <");
        sb.append(CharUtilities.toNCRefs(content));
        sb.append("> }");
        return sb.toString();
    }

    private String generateLevels(int[] levels) {
        StringBuffer lb;
        block7: {
            int i;
            lb = new StringBuffer();
            int maxLevel = -1;
            int numLevels = levels.length;
            for (i = 0; i < numLevels; ++i) {
                int l = levels[i];
                if (l <= maxLevel) continue;
                maxLevel = l;
            }
            if (maxLevel < 0) break block7;
            if (maxLevel < 10) {
                for (i = 0; i < numLevels; ++i) {
                    lb.append((char)(48 + levels[i]));
                }
            } else {
                boolean first = true;
                for (int i2 = 0; i2 < numLevels; ++i2) {
                    if (first) {
                        first = false;
                    } else {
                        lb.append(',');
                    }
                    lb.append(levels[i2]);
                }
            }
        }
        return lb.toString();
    }

    private static int[] makeLevels(int level, int count2) {
        int[] levels = new int[count2];
        Arrays.fill(levels, level);
        return levels;
    }
}

