/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.complexscripts.fonts;

import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.complexscripts.fonts.AdvancedTypographicTableFormatException;
import org.apache.fop.complexscripts.fonts.GlyphClassMapping;
import org.apache.fop.complexscripts.fonts.GlyphDefinitionSubtable;
import org.apache.fop.complexscripts.fonts.GlyphMappingTable;
import org.apache.fop.complexscripts.fonts.GlyphSubtable;
import org.apache.fop.complexscripts.fonts.GlyphTable;
import org.apache.fop.complexscripts.scripts.ScriptProcessor;
import org.apache.fop.complexscripts.util.GlyphSequence;

public class GlyphDefinitionTable
extends GlyphTable {
    private static final Log log = LogFactory.getLog(GlyphDefinitionTable.class);
    public static final int GDEF_LOOKUP_TYPE_GLYPH_CLASS = 1;
    public static final int GDEF_LOOKUP_TYPE_ATTACHMENT_POINT = 2;
    public static final int GDEF_LOOKUP_TYPE_LIGATURE_CARET = 3;
    public static final int GDEF_LOOKUP_TYPE_MARK_ATTACHMENT = 4;
    public static final int GLYPH_CLASS_BASE = 1;
    public static final int GLYPH_CLASS_LIGATURE = 2;
    public static final int GLYPH_CLASS_MARK = 3;
    public static final int GLYPH_CLASS_COMPONENT = 4;
    private GlyphClassSubtable gct;
    private MarkAttachmentSubtable mat;

    public GlyphDefinitionTable(List subtables) {
        super(null, new HashMap(0));
        if (subtables == null || subtables.size() == 0) {
            throw new AdvancedTypographicTableFormatException("subtables must be non-empty");
        }
        for (Object o : subtables) {
            if (o instanceof GlyphDefinitionSubtable) {
                this.addSubtable((GlyphSubtable)o);
                continue;
            }
            throw new AdvancedTypographicTableFormatException("subtable must be a glyph definition subtable");
        }
        this.freezeSubtables();
    }

    public GlyphSequence reorderCombiningMarks(GlyphSequence gs, int[][] gpa, String script, String language2) {
        ScriptProcessor sp2 = ScriptProcessor.getInstance(script);
        return sp2.reorderCombiningMarks(this, gs, gpa, script, language2);
    }

    protected void addSubtable(GlyphSubtable subtable) {
        if (subtable instanceof GlyphClassSubtable) {
            this.gct = (GlyphClassSubtable)subtable;
        } else if (!(subtable instanceof AttachmentPointSubtable) && !(subtable instanceof LigatureCaretSubtable)) {
            if (subtable instanceof MarkAttachmentSubtable) {
                this.mat = (MarkAttachmentSubtable)subtable;
            } else {
                throw new UnsupportedOperationException("unsupported glyph definition subtable type: " + subtable);
            }
        }
    }

    public boolean isGlyphClass(int gid, int gc) {
        if (this.gct != null) {
            return this.gct.isGlyphClass(gid, gc);
        }
        return false;
    }

    public int getGlyphClass(int gid) {
        if (this.gct != null) {
            return this.gct.getGlyphClass(gid);
        }
        return -1;
    }

    public boolean isMarkAttachClass(int gid, int mac) {
        if (this.mat != null) {
            return this.mat.isMarkAttachClass(gid, mac);
        }
        return false;
    }

    public int getMarkAttachClass(int gid) {
        if (this.mat != null) {
            return this.mat.getMarkAttachClass(gid);
        }
        return -1;
    }

    public static int getLookupTypeFromName(String name) {
        String s2 = name.toLowerCase();
        int t = "glyphclass".equals(s2) ? 1 : ("attachmentpoint".equals(s2) ? 2 : ("ligaturecaret".equals(s2) ? 3 : ("markattachment".equals(s2) ? 4 : -1)));
        return t;
    }

    public static String getLookupTypeName(int type) {
        String tn = null;
        switch (type) {
            case 1: {
                tn = "glyphclass";
                break;
            }
            case 2: {
                tn = "attachmentpoint";
                break;
            }
            case 3: {
                tn = "ligaturecaret";
                break;
            }
            case 4: {
                tn = "markattachment";
                break;
            }
            default: {
                tn = "unknown";
            }
        }
        return tn;
    }

    public static GlyphSubtable createSubtable(int type, String id, int sequence2, int flags, int format2, GlyphMappingTable mapping, List entries) {
        GlyphDefinitionSubtable st = null;
        switch (type) {
            case 1: {
                st = GlyphClassSubtable.create(id, sequence2, flags, format2, mapping, entries);
                break;
            }
            case 2: {
                st = AttachmentPointSubtable.create(id, sequence2, flags, format2, mapping, entries);
                break;
            }
            case 3: {
                st = LigatureCaretSubtable.create(id, sequence2, flags, format2, mapping, entries);
                break;
            }
            case 4: {
                st = MarkAttachmentSubtable.create(id, sequence2, flags, format2, mapping, entries);
                break;
            }
        }
        return st;
    }

    private static class MarkAttachmentSubtableFormat1
    extends MarkAttachmentSubtable {
        MarkAttachmentSubtableFormat1(String id, int sequence2, int flags, int format2, GlyphMappingTable mapping, List entries) {
            super(id, sequence2, flags, format2, mapping, entries);
        }

        public List getEntries() {
            return null;
        }

        public boolean isCompatible(GlyphSubtable subtable) {
            return subtable instanceof MarkAttachmentSubtable;
        }

        public boolean isMarkAttachClass(int gid, int mac) {
            GlyphClassMapping cm = this.getClasses();
            if (cm != null) {
                return cm.getClassIndex(gid, 0) == mac;
            }
            return false;
        }

        public int getMarkAttachClass(int gid) {
            GlyphClassMapping cm = this.getClasses();
            if (cm != null) {
                return cm.getClassIndex(gid, 0);
            }
            return -1;
        }
    }

    private static abstract class MarkAttachmentSubtable
    extends GlyphDefinitionSubtable {
        MarkAttachmentSubtable(String id, int sequence2, int flags, int format2, GlyphMappingTable mapping, List entries) {
            super(id, sequence2, flags, format2, mapping);
        }

        public int getType() {
            return 4;
        }

        public abstract boolean isMarkAttachClass(int var1, int var2);

        public abstract int getMarkAttachClass(int var1);

        static GlyphDefinitionSubtable create(String id, int sequence2, int flags, int format2, GlyphMappingTable mapping, List entries) {
            if (format2 == 1) {
                return new MarkAttachmentSubtableFormat1(id, sequence2, flags, format2, mapping, entries);
            }
            throw new UnsupportedOperationException();
        }
    }

    private static class LigatureCaretSubtableFormat1
    extends LigatureCaretSubtable {
        LigatureCaretSubtableFormat1(String id, int sequence2, int flags, int format2, GlyphMappingTable mapping, List entries) {
            super(id, sequence2, flags, format2, mapping, entries);
        }

        public List getEntries() {
            return null;
        }

        public boolean isCompatible(GlyphSubtable subtable) {
            return subtable instanceof LigatureCaretSubtable;
        }
    }

    private static abstract class LigatureCaretSubtable
    extends GlyphDefinitionSubtable {
        LigatureCaretSubtable(String id, int sequence2, int flags, int format2, GlyphMappingTable mapping, List entries) {
            super(id, sequence2, flags, format2, mapping);
        }

        public int getType() {
            return 3;
        }

        static GlyphDefinitionSubtable create(String id, int sequence2, int flags, int format2, GlyphMappingTable mapping, List entries) {
            if (format2 == 1) {
                return new LigatureCaretSubtableFormat1(id, sequence2, flags, format2, mapping, entries);
            }
            throw new UnsupportedOperationException();
        }
    }

    private static class AttachmentPointSubtableFormat1
    extends AttachmentPointSubtable {
        AttachmentPointSubtableFormat1(String id, int sequence2, int flags, int format2, GlyphMappingTable mapping, List entries) {
            super(id, sequence2, flags, format2, mapping, entries);
        }

        public List getEntries() {
            return null;
        }

        public boolean isCompatible(GlyphSubtable subtable) {
            return subtable instanceof AttachmentPointSubtable;
        }
    }

    private static abstract class AttachmentPointSubtable
    extends GlyphDefinitionSubtable {
        AttachmentPointSubtable(String id, int sequence2, int flags, int format2, GlyphMappingTable mapping, List entries) {
            super(id, sequence2, flags, format2, mapping);
        }

        public int getType() {
            return 2;
        }

        static GlyphDefinitionSubtable create(String id, int sequence2, int flags, int format2, GlyphMappingTable mapping, List entries) {
            if (format2 == 1) {
                return new AttachmentPointSubtableFormat1(id, sequence2, flags, format2, mapping, entries);
            }
            throw new UnsupportedOperationException();
        }
    }

    private static class GlyphClassSubtableFormat1
    extends GlyphClassSubtable {
        GlyphClassSubtableFormat1(String id, int sequence2, int flags, int format2, GlyphMappingTable mapping, List entries) {
            super(id, sequence2, flags, format2, mapping, entries);
        }

        public List getEntries() {
            return null;
        }

        public boolean isCompatible(GlyphSubtable subtable) {
            return subtable instanceof GlyphClassSubtable;
        }

        public boolean isGlyphClass(int gid, int gc) {
            GlyphClassMapping cm = this.getClasses();
            if (cm != null) {
                return cm.getClassIndex(gid, 0) == gc;
            }
            return false;
        }

        public int getGlyphClass(int gid) {
            GlyphClassMapping cm = this.getClasses();
            if (cm != null) {
                return cm.getClassIndex(gid, 0);
            }
            return -1;
        }
    }

    private static abstract class GlyphClassSubtable
    extends GlyphDefinitionSubtable {
        GlyphClassSubtable(String id, int sequence2, int flags, int format2, GlyphMappingTable mapping, List entries) {
            super(id, sequence2, flags, format2, mapping);
        }

        public int getType() {
            return 1;
        }

        public abstract boolean isGlyphClass(int var1, int var2);

        public abstract int getGlyphClass(int var1);

        static GlyphDefinitionSubtable create(String id, int sequence2, int flags, int format2, GlyphMappingTable mapping, List entries) {
            if (format2 == 1) {
                return new GlyphClassSubtableFormat1(id, sequence2, flags, format2, mapping, entries);
            }
            throw new UnsupportedOperationException();
        }
    }
}

