/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.bitmap;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class MultiFileRenderingUtil {
    private String filePrefix;
    private String fileExtension;
    private File outputDir;

    public MultiFileRenderingUtil(String ext, File outputFile) {
        this.fileExtension = ext;
        if (outputFile == null) {
            this.outputDir = null;
            this.filePrefix = null;
        } else {
            this.outputDir = outputFile.getParentFile();
            String s2 = outputFile.getName();
            int i = s2.lastIndexOf(".");
            if (i > 0) {
                String extension2 = s2.substring(i + 1).toLowerCase();
                if (!ext.equals(extension2)) {
                    throw new IllegalArgumentException("Invalid file extension ('" + extension2 + "') specified");
                }
            } else if (i == -1) {
                i = s2.length();
            } else {
                throw new IllegalArgumentException("Invalid file name ('" + s2 + "') specified");
            }
            if (s2.charAt(i - 1) == '1') {
                --i;
            }
            this.filePrefix = s2.substring(0, i);
        }
    }

    public OutputStream createOutputStream(int pageNumber) throws IOException {
        if (this.filePrefix == null) {
            return null;
        }
        File f = new File(this.outputDir, this.filePrefix + (pageNumber + 1) + "." + this.fileExtension);
        BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(f));
        return os;
    }
}

