/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.svg;

import java.awt.Font;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.StringTokenizer;
import org.apache.batik.dom.svg.SVGDOMImplementation;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public final class SVGUtilities {
    private static final String SVG_NS = "http://www.w3.org/2000/svg";

    private SVGUtilities() {
    }

    public static Document createSVGDocument(float width, float height) {
        DOMImplementation impl = SVGDOMImplementation.getDOMImplementation();
        Document doc = impl.createDocument(SVG_NS, "svg", null);
        Element svgRoot = doc.getDocumentElement();
        svgRoot.setAttributeNS(null, "width", "" + width);
        svgRoot.setAttributeNS(null, "height", "" + height);
        return doc;
    }

    public static float getStringWidth(String str, Font font) {
        Rectangle2D rect = font.getStringBounds(str, 0, str.length(), new FontRenderContext(new AffineTransform(), true, true));
        return (float)rect.getWidth();
    }

    public static float getStringHeight(String str, Font font) {
        Rectangle2D rect = font.getStringBounds(str, 0, str.length(), new FontRenderContext(new AffineTransform(), true, true));
        return (float)rect.getHeight();
    }

    public static Rectangle2D getStringBounds(String str, Font font) {
        return font.getStringBounds(str, 0, str.length(), new FontRenderContext(new AffineTransform(), true, true));
    }

    public static Element createLine(Document doc, float x, float y, float x2, float y2) {
        Element ellipse = doc.createElementNS(SVG_NS, "line");
        ellipse.setAttributeNS(null, "x1", "" + x);
        ellipse.setAttributeNS(null, "x2", "" + x2);
        ellipse.setAttributeNS(null, "y1", "" + y);
        ellipse.setAttributeNS(null, "y2", "" + y2);
        return ellipse;
    }

    public static Element createEllipse(Document doc, float cx, float cy, float rx, float ry) {
        Element ellipse = doc.createElementNS(SVG_NS, "ellipse");
        ellipse.setAttributeNS(null, "cx", "" + cx);
        ellipse.setAttributeNS(null, "rx", "" + rx);
        ellipse.setAttributeNS(null, "cy", "" + cy);
        ellipse.setAttributeNS(null, "ry", "" + ry);
        return ellipse;
    }

    public static Element createPath(Document doc, String str) {
        Element path = doc.createElementNS(SVG_NS, "path");
        path.setAttributeNS(null, "d", str);
        return path;
    }

    public static Element createText(Document doc, float x, float y, String str) {
        Element textGraph = doc.createElementNS(SVG_NS, "text");
        textGraph.setAttributeNS(null, "x", "" + x);
        textGraph.setAttributeNS(null, "y", "" + y);
        Text text2 = doc.createTextNode(str);
        textGraph.appendChild(text2);
        return textGraph;
    }

    public static Element createRect(Document doc, float x, float y, float width, float height) {
        Element border = doc.createElementNS(SVG_NS, "rect");
        border.setAttributeNS(null, "x", "" + x);
        border.setAttributeNS(null, "y", "" + y);
        border.setAttributeNS(null, "width", "" + width);
        border.setAttributeNS(null, "height", "" + height);
        return border;
    }

    public static Element createG(Document doc) {
        Element border = doc.createElementNS(SVG_NS, "g");
        return border;
    }

    public static Element createClip(Document doc, Element els, String id) {
        Element border = doc.createElementNS(SVG_NS, "clipPath");
        border.setAttributeNS(null, "id", id);
        border.appendChild(els);
        return border;
    }

    public static Element createImage(Document doc, String ref, float width, float height) {
        Element border = doc.createElementNS(SVG_NS, "image");
        border.setAttributeNS("http://www.w3.org/1999/xlink", "href", ref);
        border.setAttributeNS(null, "width", "" + width);
        border.setAttributeNS(null, "height", "" + height);
        return border;
    }

    public static Element wrapText(Document doc, String str, Font font, float width) {
        Element g = SVGUtilities.createG(doc);
        StringTokenizer st = new StringTokenizer(str, " \t\r\n");
        float totalWidth = 0.0f;
        String totalStr = "";
        int line = 0;
        float height = SVGUtilities.getStringHeight(str, font);
        while (st.hasMoreTokens()) {
            String token2 = st.nextToken();
            float strwidth = SVGUtilities.getStringWidth(token2, font);
            if ((totalWidth += strwidth) > width) {
                if (totalStr.equals("")) {
                    totalStr = token2;
                    token2 = "";
                    strwidth = 0.0f;
                }
                Element text2 = SVGUtilities.createText(doc, 0.0f, (float)line * (height + 5.0f), totalStr);
                g.appendChild(text2);
                totalStr = token2;
                totalWidth = strwidth;
                ++line;
                continue;
            }
            totalStr = totalStr + " " + token2;
        }
        return g;
    }
}

